/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import plugin.ChangeLogPanel;
import plugin.MainUI;

public class XMLHandler {
    private MainUI mainUI;
    private ChangeLogPanel changelog;
    private Document schweiz_doc;

    protected XMLHandler() {
    }

    protected XMLHandler(boolean save) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            URL xmlurl = new URL("http://sts.armar.de/schweiz_data.xml");
            InputStream stream = xmlurl.openStream();
            this.schweiz_doc = docBuilder.parse(stream);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected XMLHandler(MainUI mainUI) {
        this.mainUI = mainUI;
    }

    protected XMLHandler(ChangeLogPanel changelog) {
        this.changelog = changelog;
    }

    protected void convertFromUpdateXML() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            URL xmlurl = new URL("http://sts.armar.de/changelog.xml");
            InputStream stream = xmlurl.openStream();
            Document doc = docBuilder.parse(stream);
            Element root = doc.getDocumentElement();
            NodeList itemList = root.getElementsByTagName("update");
            Element currentBook = (Element)itemList.item(0);
            String version = currentBook.getElementsByTagName("version").item(0).getTextContent().trim();
            if (this.mainUI != null) {
                this.mainUI.setUpdateInfos(version);
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    protected void convertFromChangelogXML() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            URL xmlurl = new URL("http://sts.armar.de/changelog.xml");
            InputStream stream = xmlurl.openStream();
            Document doc = docBuilder.parse(stream);
            Element root = doc.getDocumentElement();
            NodeList itemList = root.getElementsByTagName("update");
            int i = 0;
            while (i < itemList.getLength()) {
                Element currentBook = (Element)itemList.item(i);
                String version = currentBook.getElementsByTagName("version").item(0).getTextContent().trim();
                String date = currentBook.getElementsByTagName("date").item(0).getTextContent().trim();
                Element description = (Element)currentBook.getElementsByTagName("descriptions").item(0);
                NodeList verbessertList = description.getElementsByTagName("verbessert");
                String[] upgrades = new String[verbessertList.getLength()];
                int j = 0;
                while (j < verbessertList.getLength()) {
                    upgrades[j] = verbessertList.item(j).getTextContent().trim();
                    ++j;
                }
                NodeList behobenList = description.getElementsByTagName("behoben");
                String[] fixed = new String[behobenList.getLength()];
                int j2 = 0;
                while (j2 < behobenList.getLength()) {
                    fixed[j2] = behobenList.item(j2).getTextContent().trim();
                    ++j2;
                }
                this.changelog.addUpdate(version, date, upgrades, fixed);
                ++i;
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    protected boolean istAnlageInSchweiz(String anlagen_name) {
        boolean result = false;
        Element root = this.schweiz_doc.getDocumentElement();
        Element anlagen = (Element)root.getElementsByTagName("anlagen").item(0);
        NodeList itemList = anlagen.getElementsByTagName("Record");
        int i = 0;
        while (i < itemList.getLength()) {
            Element currentBook = (Element)itemList.item(i);
            String name = currentBook.getElementsByTagName("stellwerk_name").item(0).getTextContent().trim();
            if (name.equals(anlagen_name)) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    protected String getNameOf(String zugnummer) {
        return String.valueOf(this.getKuerzel(zugnummer)) + " " + zugnummer;
    }

    protected String getKuerzel(String zugnummer) {
        String result = "";
        if (this.isNumber(zugnummer)) {
            int number = Integer.parseInt(zugnummer);
            if (number < 200) {
                Element root = this.schweiz_doc.getDocumentElement();
                Element nummern = (Element)root.getElementsByTagName("nummern").item(0);
                NodeList itemList = nummern.getElementsByTagName("item");
                int i = 0;
                while (i < itemList.getLength()) {
                    Element currentBook = (Element)itemList.item(i);
                    String nummer = currentBook.getElementsByTagName("nummer").item(0).getTextContent().trim();
                    if (nummer.equals(zugnummer)) {
                        String kuerzel;
                        result = kuerzel = currentBook.getElementsByTagName("kuerzel").item(0).getTextContent().trim();
                        break;
                    }
                    ++i;
                }
                if (result.equals("")) {
                    result = "EC/ICE/D";
                }
            } else {
                result = this.getKuerzel(number);
            }
        }
        if (result.equals("")) {
            System.err.println("Zug hat bereits K\u00fcrzel: [" + zugnummer + "]");
        }
        return result;
    }

    private String getKuerzel(int number) {
        String result = "Extra";
        if (number > 0 && number < 500) {
            result = "Int";
        } else if (number > 499 && number < 1100) {
            result = "IC";
        } else if (number > 1099 && number < 1400) {
            result = "IntS";
        } else if (number > 1399 && number < 2600) {
            result = "IR";
        } else if (number > 2599 && number < 4000) {
            result = "RE";
        } else if (number > 3999 && number < 9000) {
            result = "R";
        } else if (number > 8999 && number < 9100) {
            result = "Jailtr.";
        } else if (number > 9099 && number < 9800) {
            result = "TGV";
        } else if (number > 9799 && number < 10000) {
            result = "R";
        } else if (number > 10999 && number < 13000) {
            result = "S";
        } else if (number > 13999 && number < 26000) {
            result = "S";
        } else if (number > 25999 && number < 27000) {
            result = "R/S";
        } else if (number > 26999 && number < 28000) {
            result = "A-Tunn.";
        } else if (number > 27999 && number < 38000) {
            result = "Lr/Tfzf";
        } else if (number > 29999 && number < 40000) {
            result = "Extra";
        } else if (number > 39999 && number < 50000) {
            result = "I-G\u00fcter";
        } else if (number > 49999 && number < 50700) {
            result = "CargoX";
        } else if (number > 50699 && number < 51000) {
            result = "Post";
        } else if (number > 55999 && number < 59000) {
            result = "N-G\u00fcter";
        } else if (number > 59999 && number < 61000) {
            result = "F-G\u00fcter";
        } else if (number > 60999 && number < 66000) {
            result = "N-G\u00fcter";
        } else if (number > 65999 && number < 69000) {
            result = "G-G\u00fcter";
        } else if (number > 79899 && number < 79960) {
            result = "Lr/Tfzf";
        } else if (number > 87799 && number < 87900) {
            result = "Grenz-Z";
        } else if (number > 95999 && number < 97000) {
            result = "Grenz-Z";
        } else if (number > 98999 && number < 99600) {
            result = "Lr/Tfzf";
        }
        return result;
    }

    private boolean isNumber(String zugnummer) {
        boolean result = true;
        try {
            Integer.parseInt(zugnummer);
        }
        catch (NumberFormatException e) {
            result = false;
        }
        return result;
    }

    protected String getDate() {
        GregorianCalendar calendar = new GregorianCalendar();
        DateFormat format = DateFormat.getDateTimeInstance(3, 3);
        Date date = calendar.getTime();
        return format.format((Object)date);
    }
}

