/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;

public class VerticalLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    public static final int ROTATE = 11;
    public static final int BELOW = 22;
    private int style;

    protected VerticalLabel(String aText, int style) {
        super(aText, 0);
        this.setStyle(style);
        this.setFont(new Font("Dialog", 1, 10));
    }

    protected void setStyle(int style) {
        this.style = style != 11 && style != 22 ? 11 : style;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.style == 11) {
            AffineTransform at = new AffineTransform();
            Graphics2D g2D = (Graphics2D)g;
            g2D.setColor(this.getBackground());
            g2D.fillRect(0, 0, this.getSize().width, this.getSize().height);
            at.setToTranslation(this.getSize().getWidth(), this.getSize().getHeight());
            g2D.setFont(new Font("Dialog", 1, 10));
            g2D.transform(at);
            at.setToRotation(4.71238898038469);
            g2D.transform(at);
            FontMetrics fontMetrics = g2D.getFontMetrics();
            Rectangle2D rect = fontMetrics.getStringBounds(this.getText(), g2D);
            g2D.setColor(this.getForeground());
            g2D.drawString(this.getText(), this.getSize().height / 2 - (int)rect.getCenterX() + 1, -1);
        } else {
            this.convertTextToHTML();
            super.paintComponent(g);
        }
    }

    private void convertTextToHTML() {
        if (this.getText().length() < 5 || !this.getText().substring(0, 6).equals("<html>")) {
            String result = "<html>";
            int i = 0;
            while (i < this.getText().length()) {
                result = String.valueOf(result) + this.getText().charAt(i);
                result = String.valueOf(result) + "<br>";
                ++i;
            }
            result = String.valueOf(result) + "</html>";
            this.setText(result);
        }
    }
}

