/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import plugin.AlarmWindow;
import plugin.GridPane;
import plugin.Train;
import plugin.TrainAllOutsidePane;
import plugin.TrainPane;

public class TrainPaneOutside
extends TrainPane
implements Comparable<TrainPaneOutside> {
    private static final long serialVersionUID = 1L;
    private TrainAllOutsidePane pane;
    private boolean sichtbarCache = false;
    private Timer activationTimer;
    private JLabel countdown_label;
    private Timer refreshTimer;
    protected String oldText = "";

    protected TrainPaneOutside(Train zug, TrainAllOutsidePane trainAllOutsidePane, GridPane gridpane) {
        super(zug, trainAllOutsidePane, gridpane);
        this.pane = trainAllOutsidePane;
        this.getZug().setTrainPanelOutside(this);
        this.setVisible(false);
        try {
            if (zug.getUi().getMainUI().getClock().isReached(zug.plan.eta - (long)(zug.getUi().getMainUI().getOptions().getMaxMinutes() * 60))) {
                this.setVisible(true);
            } else {
                this.addActivationTimer();
            }
        }
        catch (NullPointerException e) {
            this.addActivationTimer();
        }
        JPanel namePane = new JPanel();
        JLabel name = new JLabel(this.getTrainName(), 0);
        namePane.setLayout(new GridLayout(2, 1));
        namePane.add(name);
        try {
            this.countdown_label = zug.getUi().getMainUI().getClock().getMinutesToTime(zug.plan.eta) < 1 ? new JLabel("(unverz\u00fcglich)", 0) : new JLabel("(in ca." + zug.getUi().getMainUI().getClock().getMinutesToTime(zug.plan.eta) + " Min.)", 0);
        }
        catch (NullPointerException e) {
            this.countdown_label = new JLabel("(Warte auf Uhrzeit)", 0);
        }
        name.setFont(new Font("Sans Serif", 1, 14));
        namePane.add(this.countdown_label);
        namePane.setOpaque(false);
        this.setNameB(namePane);
        this.addTimeRefreshTimer();
        if (this.getZug().von.equals("")) {
            this.alarm_button.setEnabled(false);
        }
        if (this.getMain().getOptions().isAlarmEnabled()) {
            this.switchAlarm();
        }
    }

    @Override
    protected void registerPanel() {
    }

    @Override
    protected void addMouseListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                TrainPaneOutside.this.setBackground(Color.LIGHT_GRAY);
                TrainPaneOutside.this.setBorder(new CompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(0, 0, 0, 5)));
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                TrainPaneOutside.this.setBackground(new Color(240, 240, 240));
                TrainPaneOutside.this.setBorder(new CompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(0, 0, 0, 5)));
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.checkPopup(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.checkPopup(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.checkPopup(evt);
            }

            private void checkPopup(MouseEvent evt) {
                if (evt.isPopupTrigger() || SwingUtilities.isRightMouseButton(evt)) {
                    TrainPaneOutside.this.showPopUpMenu(evt.getX(), evt.getY(), TrainPaneOutside.this, TrainPaneOutside.this.getZug());
                } else if (evt.isAltDown() || evt.getButton() == 3) {
                    TrainPaneOutside.this.copyToClipboard();
                } else {
                    TrainPaneOutside.this.leftclick();
                }
            }
        });
    }

    @Override
    protected void setWarningLevelHigh(boolean levelHigh) {
    }

    @Override
    protected void abwinken2() {
        this.pane.remove(this);
        this.pane.revalidate();
        this.pane.repaint();
        this.revalidate();
        this.repaint();
    }

    @Override
    protected boolean removesOnEvent(String eventName) {
        return eventName.equals("ausfahrt");
    }

    private void addActivationTimer() {
        this.activationTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (TrainPaneOutside.this.getZug() != null && TrainPaneOutside.this.getZug().plan != null && TrainPaneOutside.this.getZug().getUi().getMainUI().getClock().isReached(TrainPaneOutside.this.getZug().plan.eta - (long)(TrainPaneOutside.this.getZug().getUi().getMainUI().getOptions().getMaxMinutes() * 60))) {
                    TrainPaneOutside.this.setVisible(true);
                    TrainPaneOutside.this.revalidate();
                    TrainPaneOutside.this.repaint();
                    TrainPaneOutside.this.pane.refresh();
                    if (TrainPaneOutside.this.activationTimer != null) {
                        TrainPaneOutside.this.activationTimer.stop();
                    }
                    TrainPaneOutside.this.activationTimer = null;
                }
            }
        });
        this.activationTimer.start();
    }

    private void addTimeRefreshTimer() {
        this.refreshTimer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String newText;
                String string = newText = TrainPaneOutside.this.getZug().getUi().getMainUI().getClock().getMinutesToTime(TrainPaneOutside.this.getZug().plan.eta) < 1 ? "(unverz\u00fcglich)" : "(in ca." + TrainPaneOutside.this.getZug().getUi().getMainUI().getClock().getMinutesToTime(TrainPaneOutside.this.getZug().plan.eta) + " Min.)";
                if (!TrainPaneOutside.this.oldText.equals(newText)) {
                    TrainPaneOutside.this.countdown_label.setText(newText);
                    TrainPaneOutside.this.oldText = newText;
                    TrainPaneOutside.this.pane.resort();
                }
            }
        });
        this.refreshTimer.start();
    }

    @Override
    protected void update(int verspaetung, String gleis, String plangleis, boolean sichtbar, int eigeneVerspaetung, int eigeneVerspaetungFix, boolean amgleis) {
        if (!this.sichtbarCache && sichtbar && !this.isRemoving()) {
            this.abwinken2();
        }
        if (this.getZug().von.equals("")) {
            this.alarm_button.setEnabled(false);
        }
        this.sichtbarCache = sichtbar;
        this.getVerspA().setText("Versp\u00e4tung: " + this.getZeit(verspaetung));
        this.getVerspEigeneB().setText("" + eigeneVerspaetung);
        this.getVerspEigeneBFix().setText("" + eigeneVerspaetungFix);
        this.checkSymbolsAndColor(verspaetung);
        this.getVerspEigeneB().setText("" + eigeneVerspaetung);
        this.getVerspEigeneA().setText("Eigene Versp\u00e4tung:" + this.getZeit(eigeneVerspaetung));
        this.getGleisA().setText(gleis);
        this.createGleisB();
        this.setWarningLevelHigh(verspaetung >= 0);
        this.getGridTrainPane().setWarningLevelHigh(verspaetung >= 0);
        this.revalidate();
        this.repaint();
        this.getZug().getUi().getMainUI().validate();
        this.getZug().getUi().getMainUI().repaint();
    }

    @Override
    public int compareTo(TrainPaneOutside other) {
        return (int)(this.getZug().plan.eta - other.getZug().plan.eta);
    }

    public void setAlarmEnabled(boolean e) {
        if (e && !this.getZug().sichtbar && this.alarm_button.isEnabled()) {
            this.alarm_button.setName("aktiviert");
            this.alarm_button.setIcon(this.animations ? TrainPane.ICON_ARMED : this.X_ICON_ARMED);
            this.alarm_window = new AlarmWindow(this);
        } else if (!e && !this.getZug().sichtbar) {
            this.alarm_button.setName("deaktiviert");
            this.alarm_button.setIcon(this.animations ? TrainPane.ICON_DISARMED : this.X_ICON_DISARMED);
            this.alarm_window = null;
        }
    }
}

