/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import js.java.stspluginlib.PluginClient;
import layout.TableLayout;
import plugin.AlarmChoice;
import plugin.AlarmWindow;
import plugin.AlarmWindowExtended;
import plugin.ButtonPane;
import plugin.DecryptedTimeTableSingle;
import plugin.GridPane;
import plugin.InfoWindow;
import plugin.MainUI;
import plugin.Train;
import plugin.TrainButtonPane;
import plugin.TrainDelayPane;
import plugin.VerticalLabel;

public class TrainPane
extends ButtonPane {
    private static final ImageIcon ARROW = new ImageIcon("./src/plugin/images/arrow_right_small.png");
    private static final ImageIcon ICON_HALT = new ImageIcon("./src/plugin/images/halt_small.gif");
    private static final ImageIcon ICON_HALT_ROT = new ImageIcon("./src/plugin/images/halt_small_go_anim.gif");
    private static final long serialVersionUID = 1L;
    private static final ImageIcon VORRANG = new ImageIcon("./src/plugin/images/warning.gif");
    private static final ImageIcon X_ICON_HALT = new ImageIcon("./src/plugin/images/x_halt_small.gif");
    private static final ImageIcon X_ICON_HALT_ROT = new ImageIcon("./src/plugin/images/x_halt_small_go_anim.gif");
    private static final ImageIcon X_VORRANG = new ImageIcon("./src/plugin/images/x_warning.gif");
    protected JButton alarm_button;
    protected int eingetroffen_vor_sekunden = 0;
    protected TrainDelayPane mainPanel;
    protected boolean removes = false;
    private JLabel reserve_icon;
    protected AlarmWindow alarm_window = null;
    private JPanel alternativeBoxPane;
    protected boolean animations;
    private Timer arrivedTimer;
    private CardLayout cards;
    protected static final ImageIcon CLOCK = new ImageIcon("./src/plugin/images/clock.png");
    private VerticalLabel eingetroffen_label;
    private JLabel gleisA;
    private GridPane gridpane;
    private TrainButtonPane gridTrainPane;
    private JLabel h\u00e4lt;
    private JPanel h\u00e4lt_panel;
    private JPanel symbol_panel;
    private JLabel h\u00e4lt_warning;
    private JTextField hiddenField;
    protected static final ImageIcon ICON_ARMED = new ImageIcon("./src/plugin/images/alarm_armed.gif");
    protected static final ImageIcon ICON_DISABLED = new ImageIcon("./src/plugin/images/alarm_disabled.gif");
    protected static final ImageIcon ICON_DISARMED = new ImageIcon("./src/plugin/images/alarm_unarmed.gif");
    private static final String WARNING = "WARNING";
    private static final String RESERVE = "RESERVE";
    private static final String LEER = "LEER";
    private JLabel nachA;
    private JLabel nachB;
    private JLabel nameA;
    private JPanel nameB;
    protected JTextField notizB;
    private JPanel pane;
    private JPanel paneHorizontal;
    private JLabel spacer;
    private JLabel spacer6;
    private final double[][] tbHorizontal = new double[][]{{-3.0, -1.0, -2.0}, {-1.0}};
    private final double[][] tbSize = new double[][]{{-3.0, -3.0, -3.0, -1.0, -3.0, 0.2, -3.0, -1.0, 0.1, 0.1}, {-1.0}};
    private final double[][] tbSize_zwischenhalt = new double[][]{{-1.0, -3.0}, {-1.0}};
    private final double[][] tbVertical = new double[][]{{-1.0}, {-1.0, -2.0}};
    private final JPanel textFieldPane;
    private final double[][] textFieldSize = new double[][]{{1.0E-6, -1.0, -2.0}, {-1.0}};
    private JLabel verspA;
    private JLabel verspB;
    private JLabel verspEigeneA;
    private JLabel verspEigeneB;
    private JLabel verspEigeneBfix;
    private JLabel vonA;
    private JLabel vonB;
    private JLabel warning_icon;
    protected final ImageIcon X_ICON_ARMED = new ImageIcon("./src/plugin/images/x_alarm_armed.gif");
    private final ImageIcon X_ICON_DISABLED = new ImageIcon("./src/plugin/images/alarm_disabled.gif");
    protected final ImageIcon X_ICON_DISARMED = new ImageIcon("./src/plugin/images/alarm_unarmed.gif");
    private Train zug;
    private String zugShort;
    private String zwischenhalt_firstname_cache = "";
    private JPanel zwischenhalt_panel;
    private int zwischenhalt_size_cache = 0;
    private CardLayout cards_symbols;
    private JLabel emptypane;
    protected JLabel nameB_label;
    private CardLayout versp_eigene_card;
    private JPanel versp_eigene_panel;

    protected TrainPane(Train zug, TrainDelayPane trainDelayPane, GridPane gridpane) {
        this.zug = zug;
        this.mainPanel = trainDelayPane;
        this.gridpane = gridpane;
        this.animations = this.mainPanel.mainUI.getOptions().isAnimationEnabled();
        this.alternativeBoxPane = new JPanel();
        this.pane = new JPanel();
        this.pane.setLayout((LayoutManager)new TableLayout(this.tbSize));
        this.pane.setOpaque(false);
        this.textFieldPane = new JPanel();
        this.paneHorizontal = new JPanel();
        this.textFieldPane.setLayout((LayoutManager)new TableLayout(this.textFieldSize));
        this.paneHorizontal.setLayout((LayoutManager)new TableLayout(this.tbVertical));
        this.paneHorizontal.setOpaque(false);
        this.setLayout((LayoutManager)new TableLayout(this.tbHorizontal));
        this.alternativeBoxPane.setLayout(new GridLayout(1, 5));
        this.notizB = new JTextField(this.zug.getNote(), 100);
        this.notizB.setHorizontalAlignment(0);
        this.notizB.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
        this.notizB.setBackground(new Color(215, 215, 215));
        this.notizB.setFocusCycleRoot(false);
        this.notizB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10) {
                    TrainPane.this.vonB.requestFocus();
                    TrainPane.this.getZug().setNote(TrainPane.this.notizB.getText());
                    TrainPane.this.notizB.setForeground(Color.BLACK);
                }
            }
        });
        this.notizB.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                TrainPane.this.notizB.setForeground(TrainPane.this.getZug().marker_color.getForegroundActive());
            }

            @Override
            public void focusLost(FocusEvent e) {
                TrainPane.this.vonB.requestFocus();
                TrainPane.this.getZug().setNote(TrainPane.this.notizB.getText());
                TrainPane.this.notizB.setForeground(TrainPane.this.getZug().marker_color.getForeground());
            }
        });
        this.notizB.setFont(new Font("Verdana", 1, 10));
        this.notizB.setPreferredSize(new Dimension(3000, 20));
        this.notizB.setMaximumSize(new Dimension(3000, 20));
        this.notizB.setMinimumSize(new Dimension(1, 20));
        this.hiddenField = new JTextField();
        this.nameB = new JPanel();
        double[][] nameSize = new double[][]{{-2.0, -3.0, -1.0}, {-1.0}};
        this.nameB.setLayout((LayoutManager)new TableLayout((double[][])nameSize));
        this.nameB_label = new JLabel(this.getTrainName());
        this.nameB_label.setFont(new Font("Sans Serif", 1, 14));
        this.nameB_label.setPreferredSize(new Dimension(110, 1));
        this.h\u00e4lt_panel = new JPanel();
        this.h\u00e4lt_panel.setOpaque(false);
        this.symbol_panel = new JPanel();
        this.symbol_panel.setOpaque(false);
        this.cards = new CardLayout();
        this.cards_symbols = new CardLayout();
        this.h\u00e4lt_panel.setLayout(this.cards);
        this.symbol_panel.setLayout(this.cards_symbols);
        this.h\u00e4lt = new JLabel(this.animations ? ICON_HALT : X_ICON_HALT, 4);
        this.reserve_icon = new JLabel(CLOCK, 4);
        this.warning_icon = new JLabel(this.animations ? VORRANG : X_VORRANG);
        this.emptypane = new JLabel("", 4);
        this.emptypane.setMinimumSize(new Dimension(22, 22));
        this.emptypane.setMaximumSize(new Dimension(22, 22));
        this.emptypane.setPreferredSize(new Dimension(22, 22));
        this.symbol_panel.add((Component)this.reserve_icon, RESERVE);
        this.symbol_panel.add((Component)this.warning_icon, WARNING);
        this.symbol_panel.add((Component)this.emptypane, LEER);
        this.reserve_icon.setToolTipText("Schnellzug (m\u00f6glichst Vorrang!)");
        this.h\u00e4lt_warning = new JLabel(this.animations ? ICON_HALT_ROT : X_ICON_HALT_ROT, 4);
        this.nameB.add((Component)this.nameB_label, "0,0");
        this.nameB.add((Component)this.h\u00e4lt_panel, "1,0");
        this.h\u00e4lt_panel.add((Component)this.h\u00e4lt, "HALT");
        this.h\u00e4lt_panel.add((Component)this.h\u00e4lt_warning, "WEITER");
        this.h\u00e4lt_panel.setVisible(false);
        this.h\u00e4lt.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        this.h\u00e4lt_warning.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        this.setVerspB(new JLabel("" + this.zug.verspaetung, 0));
        this.vonB = this.zug.von.equals("") ? new JLabel(this.zug.gleis, 4) : new JLabel(this.zug.von, 4);
        this.nachB = this.zug.nach.equals("") ? new JLabel(this.zug.gleis) : new JLabel(this.zug.nach);
        this.setVerspEigeneB(new JLabel("" + this.zug.eigeneVerspaetung, 0));
        this.setVerspEigeneBFix(new JLabel("" + this.zug.eigeneVerspaetungFix, 0));
        this.setVerspEigeneA(new JLabel("Eigene Versp\u00e4tung: " + this.getZeit(this.zug.eigeneVerspaetung), 0));
        this.nameA = new JLabel(this.zug.name, 0);
        this.setVerspA(new JLabel("Versp\u00e4tung: " + this.getZeit(this.zug.verspaetung), 0));
        this.vonA = new JLabel(this.zug.von, 4);
        this.nachA = new JLabel(this.zug.nach, 2);
        this.setGleisA(new JLabel(this.zug.gleis, 0));
        this.zugShort = this.zug.name.split(" ")[0];
        this.spacer = new JLabel(ARROW, 0);
        this.spacer.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 7));
        this.spacer6 = new JLabel(ARROW, 0);
        this.spacer6.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 7));
        this.alarm_button = new JButton(this.animations ? ICON_DISARMED : this.X_ICON_DISARMED);
        this.alarm_button.setDisabledIcon(this.animations ? ICON_DISABLED : this.X_ICON_DISABLED);
        this.alarm_button.setPreferredSize(new Dimension(30, 20));
        this.alarm_button.setFocusPainted(false);
        this.alarm_button.setName("deaktiviert");
        this.alarm_button.setOpaque(false);
        this.alarm_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrainPane.this.switchAlarm();
            }
        });
        this.addComponents();
        this.setComponentsLayout();
        this.registerPanel();
        if (zug.verspaetung < 0) {
            this.setWarningLevelHigh(false);
            this.getGridTrainPane().setWarningLevelHigh(false);
        }
        if (this.mainPanel.mainUI.getOptions().isTrainInvisible(this.zugShort)) {
            this.setVisible(false);
        }
    }

    protected String getTrainName() {
        return this.getMain().schweiz_mode ? this.getMain().schweiz_xml.getNameOf(this.getZug().name) : this.getZug().name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainPane)) {
            return false;
        }
        TrainPane other = (TrainPane)obj;
        return !(this.zug == null ? other.getZug() != null : !this.zug.equals(other.getZug()));
    }

    public void setAlarm(String eventname, String gleis, boolean durchfahrt) {
        this.alarm_button.setName("aktiviert");
        this.alarm_button.setIcon(this.animations ? ICON_ARMED : this.X_ICON_ARMED);
        this.alarm_window = new AlarmWindowExtended(this);
        this.alarm_window.setEventname(eventname);
        this.alarm_window.setDurchfahrt(durchfahrt);
        this.alarm_window.setGleis(gleis);
    }

    @Override
    public void setForeground(Color fg) {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.setForeground(fg);
            ++n2;
        }
    }

    protected void abwinken2() {
        try {
            this.removes = true;
            this.zug.abwinken();
            this.mainPanel.startRemoving(this);
            this.mainPanel.repaint();
            this.gridpane.startRemoving(this.getGridTrainPane());
            this.gridpane.repaint();
        }
        catch (Exception e) {
            System.err.println("catched trainpane abwinken2");
        }
    }

    @Override
    protected void copyToClipboard() {
        try {
            String[] tmp = this.zug.name.split(" ");
            String tmpString = "";
            int i = 1;
            while (i < tmp.length) {
                if (i > 1) {
                    tmpString = String.valueOf(tmpString) + " ";
                }
                tmpString = String.valueOf(tmpString) + tmp[i];
                ++i;
            }
            this.copy(tmpString);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.copy("Fehler bei Zugnummernermittlung");
        }
    }

    @Override
    protected void copyToClipboard_einfahrt() {
        this.copy("Zugeinfahrt blockiert! (meine Ausfahrt: " + this.zug.nach + "), Bitte um R\u00e4umung f\u00fcr " + this.zug.name);
    }

    @Override
    protected void copyToClipboard_stoerung(boolean einfahrt) {
        this.copy(einfahrt ? "Durch eine St\u00f6rung kann ich keine Z\u00fcge aus Richtung " + this.zug.von + " annehmen. Bitte um Geduld!" : "Durch eine St\u00f6rung kann ich keine Z\u00fcge in Richtung " + this.zug.nach + " weiterleiten. Bitte um Geduld!");
    }

    @Override
    protected void copyToClipboard_stoerungEnde(boolean einfahrt) {
        this.copy("St\u00f6rung behoben! Zuglauf wieder m\u00f6glich.");
    }

    @Override
    protected void copyToClipboardAll() {
        this.copy(String.valueOf(this.zug.name) + ", Von [" + this.zug.von + "] nach [" + this.zug.nach + "], Versp\u00e4tung " + this.zug.verspaetung + " Min.");
    }

    @Override
    protected void copyToClipboardGWB() {
        this.copy("Erbitte Linksfahrt f\u00fcr Zug: " + this.zug.name + " (meine Ausfahrt: " + this.zug.nach + ")");
    }

    protected void createGleisB() {
        this.createGleisB(false);
    }

    protected void createGleisB(boolean override) {
        try {
            if (this.zug.plan == null) {
                this.startCreateGleisB_timer();
                return;
            }
            if (!override && this.zwischenhalt_size_cache == this.zug.plan.size() && this.zwischenhalt_firstname_cache.equals(this.zug.tmpGleis)) {
                return;
            }
            int maxrows = this.getMain().getOptions().getMaxStops();
            boolean more = false;
            boolean next_stop = false;
            if (this.zwischenhalt_size_cache != this.zug.plan.size()) {
                next_stop = true;
            }
            this.zwischenhalt_size_cache = this.zug.plan.size();
            this.zwischenhalt_firstname_cache = this.zug.tmpGleis;
            this.zwischenhalt_panel.removeAll();
            if (this.zug.plan.size() < maxrows + 1 && this.zug.plan.size() > 0) {
                this.zwischenhalt_panel.setLayout(new GridLayout(this.zug.plan.size(), 1));
            } else if (this.zug.plan.size() == 0) {
                this.zwischenhalt_panel.setLayout(new GridLayout(1, 1));
            } else {
                this.zwischenhalt_panel.setLayout(new GridLayout(maxrows, 1));
                more = true;
            }
            if (this.zug.plan.size() < 3) {
                this.setPreferredSize(new Dimension(50, 47));
                this.setMaximumSize(new Dimension(2000, 47));
                this.setMinimumSize(new Dimension(2000, 47));
            } else if (this.zug.plan.size() == 3) {
                this.setPreferredSize(new Dimension(50, 60));
                this.setMaximumSize(new Dimension(2000, 60));
                this.setMinimumSize(new Dimension(2000, 60));
            } else if (this.zug.plan.size() <= maxrows) {
                this.setPreferredSize(new Dimension(50, 60 + (this.zug.plan.size() - 3) * 15));
                this.setMaximumSize(new Dimension(2000, 60 + (this.zug.plan.size() - 3) * 15));
                this.setMinimumSize(new Dimension(2000, 60 + (this.zug.plan.size() - 3) * 15));
            } else if (this.zug.plan.size() > maxrows) {
                this.setPreferredSize(new Dimension(50, 60 + (maxrows - 3) * 15));
                this.setMaximumSize(new Dimension(2000, 60 + (maxrows - 3) * 15));
                this.setMinimumSize(new Dimension(2000, 60 + (maxrows - 3) * 15));
            }
            this.zwischenhalt_panel.setOpaque(false);
            int i = 0;
            String tooltip = "<html><B>";
            for (DecryptedTimeTableSingle plan : this.zug.plan) {
                JPanel tmp;
                if (++i < maxrows || !more) {
                    tmp = new JPanel();
                    tmp.setLayout((LayoutManager)new TableLayout(this.tbSize_zwischenhalt));
                    JLabel tmpLabel = null;
                    try {
                        if (this.zug.tmpGleis != null) {
                            tmpLabel = plan.plan.equals(this.zug.tmpGleis.equals("") || i > 1 || next_stop ? plan.gleis : this.zug.tmpGleis) ? new JLabel(plan.plan, 0) : new JLabel(this.zug.tmpGleis.equals("") || i > 1 || next_stop ? plan.plan : "<html>" + this.zug.tmpGleis + " (<s>" + plan.plan + "</s>)</html>", 0);
                        } else {
                            tmpLabel = new JLabel("Keine weiteren Stationen", 0);
                            tmpLabel.setForeground(Color.LIGHT_GRAY);
                        }
                        tmpLabel.setMaximumSize(new Dimension(2000, 13));
                        JPanel tmpLabelBox = new JPanel();
                        tmpLabelBox.setLayout(new BoxLayout(tmpLabelBox, 2));
                        JPanel tmpLabelBox2 = new JPanel();
                        tmpLabelBox2.setLayout(new BoxLayout(tmpLabelBox2, 3));
                        tmpLabelBox2.add(tmpLabel);
                        tmpLabelBox2.setOpaque(false);
                        tmpLabelBox2.setBorder(BorderFactory.createEmptyBorder(this.zug.plan.size() == 1 ? 2 : 1, 0, 0, 0));
                        tmpLabelBox.add(tmpLabelBox2);
                        tmpLabelBox.setOpaque(false);
                        tmp.add((Component)tmpLabelBox, "0,0");
                        if (this.zug.tmpGleis != null) {
                            JLabel symbol = new JLabel(plan.getSymbol(this.animations), 4);
                            symbol.setPreferredSize(new Dimension(30, 13));
                            tmp.add((Component)symbol, "1,0");
                        }
                        this.zwischenhalt_panel.add(tmp);
                        tmp.setOpaque(false);
                        tmpLabel.setFont(i == 1 ? new Font("Sans Serif", 1, 12) : new Font("Sans Serif", 1, 12));
                        if (this.zug.tmpGleis != null) {
                            tmpLabel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, Color.BLACK));
                        }
                        tmpLabel.setBackground(Color.WHITE);
                        tmpLabel.setOpaque(this.zug.tmpGleis != null);
                        tmpLabel.setMaximumSize(new Dimension(2000, 13));
                        tmpLabel.setMinimumSize(new Dimension(1, 13));
                    }
                    catch (NullPointerException e) {
                        e.printStackTrace();
                    }
                } else if (more && i == maxrows) {
                    tmp = new JPanel();
                    tmp.setLayout((LayoutManager)new TableLayout(this.tbSize_zwischenhalt));
                    JLabel moreLabel = new JLabel("(" + (this.zug.plan.size() - maxrows + 1) + " weitere)", 0);
                    moreLabel.setFont(new Font("Sans Serif", 1, 12));
                    tmp.add((Component)moreLabel, "0,0");
                    JLabel spacer_symbol = new JLabel(new ImageIcon("./src/plugin/images/icon_spacer.gif"), 4);
                    spacer_symbol.setPreferredSize(new Dimension(30, 13));
                    tmp.add((Component)spacer_symbol, "1,0");
                    tmp.setOpaque(false);
                    this.zwischenhalt_panel.add(tmp);
                }
                tooltip = String.valueOf(tooltip) + "<p>";
                tooltip = String.valueOf(tooltip) + (plan.plan.equals(plan.gleis) ? plan.plan : String.valueOf(plan.gleis) + "*");
                tooltip = String.valueOf(tooltip) + "</p>";
                tooltip = String.valueOf(tooltip) + "\n\r";
            }
            tooltip = String.valueOf(tooltip) + "</B></html>";
            if (more) {
                this.zwischenhalt_panel.setToolTipText(tooltip);
            }
        }
        catch (Exception e) {
            if (this.zug == null) {
                System.err.println("Zug nicht mehr vorhanden, TrainPane Gleisupdate");
            }
            e.printStackTrace();
        }
        this.zwischenhalt_panel.revalidate();
        this.zwischenhalt_panel.repaint();
        this.setVisible(!this.mainPanel.mainUI.getOptions().isTrainInvisible(this.zugShort));
    }

    protected void fireNote(String note) {
        this.notizB.setText(note);
    }

    protected Component getAlternativePane() {
        return this.getGridTrainPane();
    }

    protected JLabel getGleisA() {
        return this.gleisA;
    }

    protected GridPane getGridpane() {
        return this.gridpane;
    }

    protected TrainButtonPane getGridPane() {
        return this.getGridTrainPane();
    }

    protected TrainButtonPane getGridTrainPane() {
        return this.gridTrainPane;
    }

    protected MainUI getMain() {
        return this.mainPanel.mainUI;
    }

    protected JPanel getNameB() {
        return this.nameB;
    }

    protected JLabel getVerspA() {
        return this.verspA;
    }

    protected JLabel getVerspB() {
        return this.verspB;
    }

    protected JLabel getVerspEigeneA() {
        return this.verspEigeneA;
    }

    protected JLabel getVerspEigeneB() {
        return this.verspEigeneB;
    }

    protected JLabel getVerspEigeneBFix() {
        return this.verspEigeneBfix;
    }

    protected String getZeit(int verspaetung) {
        return verspaetung <= 0 ? (verspaetung < 0 ? "-(" + this.stunden(verspaetung) + ":" + this.minuten(verspaetung) + ")" : "(" + this.stunden(verspaetung) + ":" + this.minuten(verspaetung) + ")") : String.valueOf(this.stunden(verspaetung)) + ":" + this.minuten(verspaetung);
    }

    @Override
    protected Train getZug() {
        return this.zug;
    }

    protected boolean isRemoving() {
        return this.removes;
    }

    @Override
    protected void leftclick() {
        if (this.getZug().plan != null) {
            new InfoWindow(this);
        }
    }

    protected void registerPanel() {
        this.zug.setTrainPanel(this);
    }

    @Override
    protected void removeFromAll() {
        System.err.println("Zug " + this.getZug().name + " manuell \u00fcberall gel\u00f6scht");
        this.getZug().getUi().getAllpanel().remove(this.getZug());
    }

    protected boolean removesOnEvent(String eventName) {
        return true;
    }

    protected void setAnimationsEnabled(boolean b) {
        this.animations = b;
        if (this.alarm_button.getName().equals("aktiviert")) {
            this.alarm_button.setIcon(this.animations ? ICON_ARMED : this.X_ICON_ARMED);
        } else if (this.alarm_button.getName().equals("deaktiviert")) {
            this.alarm_button.setIcon(this.animations ? ICON_DISARMED : this.X_ICON_DISARMED);
        }
        this.h\u00e4lt.setIcon(this.animations ? ICON_HALT : X_ICON_HALT);
        this.h\u00e4lt_warning.setIcon(this.animations ? ICON_HALT_ROT : X_ICON_HALT_ROT);
        if (this.warning_icon != null) {
            this.warning_icon.setIcon(this.animations ? VORRANG : X_VORRANG);
        }
        this.zwischenhalt_size_cache = 0;
        this.createGleisB();
    }

    protected void setGleisA(JLabel gleisA) {
        this.gleisA = gleisA;
    }

    protected void setGridTrainPane(TrainButtonPane gridTrainPane) {
        this.gridTrainPane = gridTrainPane;
    }

    protected void setSymbol(String symbolName) {
        if (!(symbolName.equals(LEER) || symbolName.equals(RESERVE) || symbolName.equals(WARNING))) {
            symbolName = LEER;
        }
        this.cards_symbols.show(this.symbol_panel, symbolName);
    }

    protected void setNameB(JPanel content) {
        this.nameB.remove(0);
        this.nameB.add((Component)content, "0,0");
        this.nameB.revalidate();
        this.nameB.repaint();
    }

    protected void setTrainArrivedNow() {
        this.setTrainArrivedNow(true);
    }

    protected void setTrainArrivedNow(boolean with_timer) {
        this.eingetroffen_label.setText("");
        this.eingetroffen_label.setOpaque(true);
        this.eingetroffen_label.setForeground(new Color(100, 100, 100));
        this.eingetroffen_label.setBackground(with_timer ? new Color(252, 162, 162) : Color.RED);
        if (with_timer) {
            this.eingetroffen_label.setText("0");
            this.startArrivedTimer(true);
        } else {
            this.startArrivedTimer(false);
        }
    }

    protected void setVerspA(JLabel verspA) {
        this.verspA = verspA;
    }

    protected void setVerspB(JLabel verspB) {
        this.verspB = verspB;
    }

    protected void setVerspEigeneA(JLabel verspEigeneA) {
        this.verspEigeneA = verspEigeneA;
    }

    protected void setVerspEigeneB(JLabel verspEigeneB) {
        this.verspEigeneB = verspEigeneB;
    }

    protected void setVerspEigeneBFix(JLabel verspEigeneBfix) {
        this.verspEigeneBfix = verspEigeneBfix;
    }

    protected void showAlarm() {
        if (this.alarm_button.getName().equals("aktiviert")) {
            this.fire();
        }
    }

    protected void showHalt(boolean b) {
        this.h\u00e4lt_panel.setVisible(b);
        this.nameB.revalidate();
        this.nameB.repaint();
    }

    protected void setH\u00e4ltRed(boolean b) {
        if (!b) {
            this.cards.show(this.h\u00e4lt_panel, "HALT");
        } else {
            this.cards.show(this.h\u00e4lt_panel, "WEITER");
        }
    }

    @Override
    protected void showPopUpMenu(int x, int y, Component t, Train zug) {
        JMenuItem zugname = (JMenuItem)this.menu.getComponent(2);
        zugname.setText(" Folgende Daten von " + zug.name + " kopieren");
        this.menu.show(t, x, y);
    }

    protected void switchAlarm() {
        if (this.alarm_button.getName().equals("deaktiviert") && !this.getZug().sichtbar) {
            this.alarm_button.setName("aktiviert");
            this.alarm_button.setIcon(this.animations ? ICON_ARMED : this.X_ICON_ARMED);
            this.alarm_window = new AlarmWindow(this);
        } else if (this.alarm_button.getName().equals("deaktiviert") && this.getZug().sichtbar) {
            final AlarmChoice alarm_choice_window = new AlarmChoice(this);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    alarm_choice_window.show(TrainPane.this, TrainPane.this.alarm_button.getLocation().x, TrainPane.this.alarm_button.getLocation().y);
                }
            });
        } else if (this.alarm_button.getName().equals("aktiviert")) {
            this.alarm_button.setName("deaktiviert");
            this.alarm_button.setIcon(this.animations ? ICON_DISARMED : this.X_ICON_DISARMED);
        }
    }

    protected void checkSymbolsAndColor(int verspaetung) {
        if (verspaetung < 0) {
            this.setSymbol(RESERVE);
        } else if (this.getMain().getOptions().isTrainEnabled(this.zugShort)) {
            this.setSymbol(WARNING);
        } else {
            this.setSymbol(LEER);
        }
        int optionscolor = this.getMain().getOptions().getTrainColor(this.zugShort);
        if (this.getZug() != null && this.getZug().marker_color != null && optionscolor != this.getZug().marker_color.ordinal() && this.getZug().marker_color.ordinal() == 0) {
            this.getZug().setNotecolorEverywhere(ButtonPane.MarkerColors.values()[optionscolor]);
        } else if (this.getZug() != null && this.getZug().marker_color == null) {
            this.getZug().setNotecolorEverywhere(ButtonPane.MarkerColors.values()[optionscolor]);
        }
    }

    protected void update(int verspaetung, String gleis, String plangleis, boolean sichtbar, int eigeneVerspaetung, int eigeneVerspaetungFix, boolean amgleis) {
        if (!sichtbar || gleis != null && !gleis.equals(this.getGleisA().getText())) {
            this.abwinken2();
        }
        this.getVerspA().setText("Versp\u00e4tung: " + this.getZeit(verspaetung));
        this.checkSymbolsAndColor(verspaetung);
        this.getVerspB().setText("" + verspaetung);
        this.getVerspEigeneB().setText("" + eigeneVerspaetung);
        this.getVerspEigeneBFix().setText("" + eigeneVerspaetungFix);
        this.getVerspEigeneA().setText("Eigene Versp\u00e4tung:" + this.getZeit(eigeneVerspaetung));
        this.getGleisA().setText(gleis);
        this.createGleisB();
        this.setWarningLevelHigh(verspaetung >= 0);
        this.getGridTrainPane().setWarningLevelHigh(verspaetung >= 0);
        if (sichtbar) {
            this.alarm_button.setEnabled(false);
        }
        this.revalidate();
        this.repaint();
    }

    protected void updateName() {
        this.nameB_label.setText(this.getMain().schweiz_xml.getNameOf(this.getZug().name));
    }

    private void addComponents() {
        JLabel spacer1 = new JLabel(ARROW, 0);
        JLabel spacer2 = new JLabel(ARROW, 0);
        this.checkSymbolsAndColor(this.getZug().verspaetung);
        this.pane.add((Component)this.nameB, "1,0");
        this.pane.add((Component)this.symbol_panel, "2,0");
        this.pane.add((Component)this.getVerspB(), "8,0");
        this.pane.add((Component)this.vonB, "3,0");
        this.pane.add((Component)this.spacer, "4,0");
        this.pane.add((Component)this.nachB, "7,0");
        this.pane.add((Component)this.spacer6, "6,0");
        JLabel spacer = new JLabel("");
        spacer.setOpaque(false);
        spacer.setMinimumSize(new Dimension(5, 10));
        spacer.setPreferredSize(new Dimension(5, 10));
        spacer.setMaximumSize(new Dimension(5, 2000));
        this.pane.add((Component)spacer, "0,0");
        this.eingetroffen_label = new VerticalLabel("", 22);
        this.eingetroffen_label.setOpaque(false);
        this.eingetroffen_label.setMinimumSize(new Dimension(10, 10));
        this.eingetroffen_label.setPreferredSize(new Dimension(10, 10));
        this.eingetroffen_label.setMaximumSize(new Dimension(10, 2000));
        this.add((Component)this.eingetroffen_label, "0,0");
        this.zwischenhalt_panel = new JPanel();
        this.createGleisB();
        this.pane.add((Component)this.zwischenhalt_panel, "5,0");
        JPanel verspEigeneBstretcher = new JPanel();
        verspEigeneBstretcher.setLayout(new BoxLayout(verspEigeneBstretcher, 2));
        verspEigeneBstretcher.add(Box.createHorizontalGlue());
        this.versp_eigene_panel = new JPanel();
        this.versp_eigene_card = new CardLayout();
        this.versp_eigene_panel.setLayout(this.versp_eigene_card);
        this.versp_eigene_panel.setOpaque(false);
        this.versp_eigene_panel.add((Component)this.getVerspEigeneB(), "NORMAL");
        this.versp_eigene_panel.add((Component)this.getVerspEigeneBFix(), "HART");
        this.versp_eigene_card.show(this.versp_eigene_panel, this.getMain().getOptions().isHardModeEnabled() ? "HART" : "NORMAL");
        verspEigeneBstretcher.add(this.versp_eigene_panel);
        verspEigeneBstretcher.add(Box.createHorizontalGlue());
        verspEigeneBstretcher.setOpaque(false);
        this.pane.add((Component)verspEigeneBstretcher, "9,0");
        this.setGridTrainPane(new TrainButtonPane(this.zug, this));
        this.getGridTrainPane().setLayout(new GridLayout(4, 1));
        this.getGridTrainPane().add((Component)this.nameA, 0);
        this.getGridTrainPane().add((Component)this.getVerspA(), 0);
        this.alternativeBoxPane.setOpaque(false);
        this.alternativeBoxPane.add(this.vonA);
        this.alternativeBoxPane.add(spacer1);
        this.alternativeBoxPane.add(this.getGleisA());
        this.alternativeBoxPane.add(spacer2);
        this.alternativeBoxPane.add(this.nachA);
        this.getGridTrainPane().add(this.alternativeBoxPane);
        this.textFieldPane.add((Component)this.hiddenField, "0,0");
        this.textFieldPane.add((Component)this.notizB, "1,0");
        this.textFieldPane.setOpaque(false);
        this.paneHorizontal.add((Component)this.pane, "0,0");
        this.paneHorizontal.add((Component)this.textFieldPane, "0,1");
        this.textFieldPane.setPreferredSize(new Dimension(3000, 14));
        this.add((Component)this.paneHorizontal, "1,0");
        this.add((Component)this.alarm_button, "2,0");
        if (this.zug.sichtbar) {
            this.alarm_button.setEnabled(false);
        }
    }

    @Override
    protected void setNoteColor(ButtonPane.MarkerColors color) {
        this.getZug().setNotecolorEverywhere(color);
    }

    protected void updateAnzeigeHardMode() {
        this.versp_eigene_card.show(this.versp_eigene_panel, this.getMain().getOptions().isHardModeEnabled() ? "HART" : "NORMAL");
    }

    private void copy(String string) {
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
        }
        catch (HeadlessException e) {
            System.err.println("Konnte nicht kopiert werden");
        }
    }

    private void fire() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TrainPane.this.alarm_window.showNow();
            }
        });
        this.switchAlarm();
    }

    private String minuten(int zeit) {
        String tmp;
        String string = tmp = zeit < 0 ? "" + (0 - zeit) % 60 : "" + zeit % 60;
        if (tmp.length() == 1) {
            tmp = "0" + tmp;
        }
        return tmp;
    }

    private void setComponentsLayout() {
        Font font = new Font("Sans Serif", 1, 14);
        Font bigfont = new Font("Sans Serif", 1, 14);
        this.nameA.setFont(bigfont);
        this.getVerspA().setFont(font);
        this.vonA.setFont(font);
        this.nachA.setFont(font);
        this.getGleisA().setFont(font);
        this.nachB.setFont(bigfont);
        this.nameB.setOpaque(false);
        this.nameB.getComponents()[0].setFont(font);
        this.getVerspB().setFont(font);
        this.vonB.setFont(font);
        this.getVerspEigeneB().setFont(font);
        this.getVerspEigeneBFix().setFont(font);
        this.getGridTrainPane().setPreferredSize(new Dimension(50, 20));
        this.getGridTrainPane().setMaximumSize(new Dimension(2000, 20));
        if (this.getZug().marker_color == null) {
            this.getZug().marker_color = ButtonPane.MarkerColors.Keine;
        }
        this.notizB.setBackground(this.getZug().marker_color.getBackground());
    }

    private void startArrivedTimer(final boolean showlabel) {
        if (this.arrivedTimer != null) {
            this.arrivedTimer.stop();
        }
        this.arrivedTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ++TrainPane.this.eingetroffen_vor_sekunden;
                if (TrainPane.this.eingetroffen_vor_sekunden <= TrainPane.this.mainPanel.mainUI.getOptions().getEingetroffenSek() && showlabel) {
                    TrainPane.this.eingetroffen_label.setText("" + TrainPane.this.eingetroffen_vor_sekunden);
                } else if (TrainPane.this.eingetroffen_vor_sekunden > TrainPane.this.mainPanel.mainUI.getOptions().getEingetroffenSek() || showlabel) {
                    TrainPane.this.eingetroffen_label.setText("");
                    TrainPane.this.eingetroffen_label.setOpaque(false);
                    TrainPane.this.arrivedTimer.stop();
                    TrainPane.this.arrivedTimer = null;
                }
            }
        });
        this.eingetroffen_vor_sekunden = 0;
        this.arrivedTimer.start();
    }

    private void startCreateGleisB_timer() {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() {
                try {
                    TrainPane.this.zwischenhalt_panel.removeAll();
                    TrainPane.this.zwischenhalt_panel.setLayout(new GridLayout(1, 1));
                    JLabel loading = new JLabel(new ImageIcon("./src/plugin/images/wait.gif"));
                    TrainPane.this.zwischenhalt_panel.add(loading);
                    TrainPane.this.zwischenhalt_panel.revalidate();
                    TrainPane.this.zwischenhalt_panel.repaint();
                    while (((TrainPane)TrainPane.this).zug.plan == null) {
                        Thread.sleep(2000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return true;
            }

            @Override
            protected void done() {
                TrainPane.this.createGleisB();
            }
        };
        worker.execute();
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    private String stunden(int zeit) {
        String tmp = "" + zeit / 60;
        if (("" + zeit / 60).length() == 1) {
            tmp = "0" + tmp;
        }
        return tmp;
    }

    public void pushEvent(String eventName, PluginClient.ZugDetails zd) {
        Train temptrain = this.getZug();
        if (eventName.equals("ankunft") && this.alarm_button.getName().equals("aktiviert") && temptrain.sichtbar && this.alarm_window.getEventname().equals(eventName)) {
            if (this.alarm_window.getAlarmGleis().equals(temptrain.tmpGleis) && !this.alarm_window.isDurchfahrt()) {
                this.switchAlarm();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TrainPane.this.alarm_window.showNow();
                    }
                });
            } else if (this.alarm_window.getAlarmGleis().equals(temptrain.tmpGleis) && this.alarm_window.isDurchfahrt()) {
                this.switchAlarm();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TrainPane.this.alarm_window.showNow();
                    }
                });
            }
        } else if (eventName.equals("abfahrt") && this.alarm_button.getName().equals("aktiviert") && temptrain.sichtbar && this.alarm_window.getEventname().equals(eventName) && this.alarm_window.getAlarmGleis().equals(temptrain.tmpGleis)) {
            this.switchAlarm();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TrainPane.this.alarm_window.showNow();
                }
            });
        }
    }
}

