/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import layout.TableLayout;
import plugin.GridPane;
import plugin.MainUI;
import plugin.Train;
import plugin.TrainButtonPane;
import plugin.TrainDescriptionsPane;
import plugin.TrainPane;

public class TrainDelayPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected HashMap<Integer, Train> zuglist;
    protected List<Train> zugpanellist = new LinkedList<Train>();
    protected GridPane gridpane;
    protected MainUI mainUI;
    private double[][] tbSize = new double[][]{{-1.0}, {-3.0, -1.0}};
    protected JPanel train_content_pane;
    private boolean retry_repaint = false;
    private Timer refreshTimer;

    public TrainDelayPane(MainUI ui) {
        this.setLayout((LayoutManager)new TableLayout(this.tbSize));
        TrainDescriptionsPane descriptions = new TrainDescriptionsPane();
        this.add((Component)descriptions, "0,0");
        this.train_content_pane = new JPanel();
        this.train_content_pane.setLayout(new BoxLayout(this.train_content_pane, 3));
        JScrollPane scroller = new JScrollPane(this.train_content_pane, 22, 31);
        scroller.getVerticalScrollBar().setUnitIncrement(15);
        this.add((Component)scroller, "0,1");
        this.mainUI = ui;
        this.gridpane = new GridPane();
        this.addAutoRefresh();
    }

    protected void addAutoRefresh() {
        this.refreshTimer = new Timer(3000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrainDelayPane.this.refresh();
            }
        });
        this.refreshTimer.start();
    }

    protected void refresh() {
        try {
            this.update_panel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected synchronized void push(HashMap<Integer, Train> zuglist) {
        this.zuglist = zuglist;
        this.repaint();
    }

    protected void repaintSuper() {
        try {
            super.revalidate();
            super.repaint();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void repaint() {
        this.revalidate();
        super.repaint();
    }

    protected void update_panel() {
        do {
            try {
                if (this.zuglist != null) {
                    for (final Train zug : this.zuglist.values()) {
                        if (zug == null || !zug.sichtbar || !zug.steht || this.zugpanellist.contains(zug)) continue;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TrainPane newOne = new TrainPane(zug, TrainDelayPane.this, TrainDelayPane.this.gridpane);
                                TrainDelayPane.this.train_content_pane.add(newOne);
                                TrainDelayPane.this.gridpane.add(newOne.getAlternativePane());
                                TrainDelayPane.this.zugpanellist.add(zug);
                                TrainDelayPane.this.startFlashing(zug.getTrainPanel());
                                TrainDelayPane.this.gridpane.startFlashing(zug.getTrainPanel().getGridPane());
                                int status = 0;
                                if (TrainDelayPane.this.zugpanellist != null && TrainDelayPane.this.zugpanellist.size() > 0) {
                                    status = 1;
                                    if (zug.verspaetung >= 0) {
                                        status = 2;
                                    }
                                }
                                if (TrainDelayPane.this.mainUI != null) {
                                    TrainDelayPane.this.mainUI.setWarning(status);
                                }
                            }
                        });
                    }
                }
                this.revalidate();
                super.repaint();
            }
            catch (ConcurrentModificationException e) {
                this.retry_repaint = true;
            }
        } while (this.retry_repaint);
    }

    protected synchronized void remove(TrainPane t) {
        this.zugpanellist.remove(t.getZug());
        this.train_content_pane.remove(t);
    }

    protected void remove(TrainButtonPane t) {
        this.train_content_pane.remove(t);
    }

    protected JPanel getGridPane() {
        return this.gridpane;
    }

    protected void startRemoving(final TrainPane train) {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() {
                try {
                    int i = 1;
                    while (i < 401) {
                        if (train.getZug().verspaetung >= 0) {
                            train.setBackground(new Color((int)(255.0f + 0.0f * (float)i), (int)(115.0f + 0.35f * (float)i), (int)(115.0f + 0.35f * (float)i)));
                            train.setForeground(new Color(150, 150, 150));
                        } else {
                            train.setBackground(new Color((int)(255.0f + 0.0f * (float)i), (int)(240.0f + 0.0375f * (float)i), (int)(84.0f + 0.4275f * (float)i)));
                            train.setForeground(new Color(150, 150, 150));
                        }
                        Thread.sleep(10L);
                        ++i;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return true;
            }

            @Override
            protected void done() {
                TrainDelayPane.this.remove(train);
            }
        };
        worker.execute();
    }

    protected void startFlashing(final TrainPane train) {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() {
                try {
                    boolean red = train.getZug().verspaetung >= 0;
                    int j = 1;
                    while (j < 5) {
                        int i = 1;
                        while (i < 401) {
                            train.setBackground(red ? new Color((int)(255.0f + 0.0f * (float)i), (int)(115.0f + 0.35f * (float)i), (int)(115.0f + 0.35f * (float)i)) : new Color((int)(255.0f + 0.0f * (float)i), (int)(240.0f + 0.0375f * (float)i), (int)(84.0f + 0.4275f * (float)i)));
                            Thread.sleep(1L);
                            ++i;
                        }
                        i = 200;
                        while (i > 0) {
                            train.setBackground(red ? new Color((int)(255.0f + 0.0f * (float)i), (int)(115.0f + 0.7f * (float)i), (int)(115.0f + 0.7f * (float)i)) : new Color((int)(255.0f + 0.0f * (float)i), (int)(240.0f + 0.075f * (float)i), (int)(84.0f + 0.855f * (float)i)));
                            Thread.sleep(1L);
                            --i;
                        }
                        ++j;
                    }
                }
                catch (InterruptedException red) {
                }
                catch (Exception e) {
                    System.err.println("EXCEPTION IN SWINGWORKER / TrainDelayPane / startFlashing" + e);
                }
                return true;
            }

            @Override
            protected void done() {
            }
        };
        worker.execute();
    }

    public boolean hasElements() {
        return this.zugpanellist.size() > 0;
    }
}

