/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import plugin.ButtonPane;
import plugin.Train;
import plugin.TrainPane;

public class TrainButtonPane
extends ButtonPane {
    private static final long serialVersionUID = 1L;
    private TrainPane train;
    private Train zug;

    public TrainButtonPane(Train zug, TrainPane train) {
        this.train = train;
        this.zug = zug;
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.initPopup();
    }

    @Override
    public Train getZug() {
        return this.zug;
    }

    @Override
    public void setWarningLevelHigh(boolean levelHigh) {
        this.levelHigh = levelHigh;
        this.setBackground(levelHigh ? new Color(255, 115, 115) : new Color(255, 240, 84));
    }

    @Override
    public void leftclick() {
        this.train.leftclick();
    }

    @Override
    public void copyToClipboard() {
        this.train.copyToClipboard();
    }

    @Override
    public void copyToClipboardAll() {
        this.train.copyToClipboardAll();
    }

    @Override
    public void copyToClipboardGWB() {
        this.train.copyToClipboardGWB();
    }

    @Override
    protected void copyToClipboard_einfahrt() {
        this.train.copyToClipboard_einfahrt();
    }

    @Override
    protected void copyToClipboard_stoerungEnde(boolean einfahrt) {
        this.train.copyToClipboard_stoerungEnde(einfahrt);
    }

    @Override
    protected void copyToClipboard_stoerung(boolean einfahrt) {
        this.train.copyToClipboard_stoerung(einfahrt);
    }

    @Override
    public void showPopUpMenu(int x, int y, Component t, Train zug) {
        JMenuItem zugname = (JMenuItem)this.menu.getComponent(2);
        zugname.setText(" Folgende Daten von " + this.train.getZug().name + " kopieren");
        this.menu.show(t, x, y);
    }

    @Override
    protected void addMouseListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                TrainButtonPane.this.setBackground(TrainButtonPane.this.train.isWarningLevelHigh() ? new Color(255, 145, 145) : new Color(255, 244, 128));
                TrainButtonPane.this.setBorder(new CompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                TrainButtonPane.this.setBackground(TrainButtonPane.this.train.isWarningLevelHigh() ? new Color(255, 115, 115) : new Color(255, 240, 84));
                TrainButtonPane.this.setBorder(new CompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.checkPopup(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.checkPopup(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.checkPopup(evt);
            }

            private void checkPopup(MouseEvent evt) {
                if (evt.isPopupTrigger() || SwingUtilities.isRightMouseButton(evt)) {
                    TrainButtonPane.this.showPopUpMenu(evt.getX(), evt.getY(), TrainButtonPane.this, TrainButtonPane.this.getZug());
                } else if (evt.isAltDown() || evt.getButton() == 3) {
                    TrainButtonPane.this.copyToClipboard();
                } else {
                    TrainButtonPane.this.leftclick();
                }
            }
        });
    }

    public void startFlashing() {
        if (this.getZug() != null && this.getZug().getTrainPanel() != null && this.getZug().getTrainPanel().getGridPane() != null) {
            this.getZug().getTrainPanel().getGridpane().startFlashing(this);
        }
    }
}

