/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.Color;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import plugin.MainUI;
import plugin.Train;
import plugin.TrainButtonPane;
import plugin.TrainDelayPane;
import plugin.TrainPane;
import plugin.TrainPaneGreen;

public class TrainAllPane
extends TrainDelayPane {
    private static final long serialVersionUID = 1L;
    private HashMap<Integer, Train> trains_toshow = new HashMap();
    private LinkedList<Train> archive = new LinkedList();
    private int cacheContentCount;
    private Timer refreshTimer;
    protected String maxTrainsTime;
    protected String maxTrainsRealTime;
    protected int maxTrains = 0;

    protected LinkedList<Train> getArchive() {
        return this.archive;
    }

    public TrainAllPane(MainUI ui) {
        super(ui);
    }

    @Override
    protected void refresh() {
        try {
            this.update_panel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void update_panel() {
        try {
            if (this.trains_toshow != null && this.trains_toshow.values().size() > this.cacheContentCount) {
                for (Train zug : this.trains_toshow.values()) {
                    if (zug == null) continue;
                    if (!this.zugpanellist.contains(zug) && zug.sichtbar && !zug.deleted) {
                        TrainPaneGreen newOne = new TrainPaneGreen(zug, this, this.gridpane);
                        this.train_content_pane.add(newOne);
                        newOne.setBackground(new Color(240, 240, 240));
                        this.zugpanellist.add(zug);
                        if (this.zugpanellist.size() <= this.maxTrains) continue;
                        this.maxTrains = this.zugpanellist.size();
                        this.maxTrainsRealTime = this.mainUI.getClock().getRealCurrentTime();
                        this.maxTrainsTime = this.mainUI.getClock().getTimeString();
                        continue;
                    }
                    if (!zug.deleted) continue;
                    this.removeTrain(zug.zid, zug);
                }
                this.cacheContentCount = this.trains_toshow.values().size();
            } else if (this.trains_toshow != null && this.trains_toshow.values().size() < this.cacheContentCount) {
                LinkedList tmplist = new LinkedList();
                tmplist.addAll(this.zugpanellist);
                for (Train zug : tmplist) {
                    if (zug == null || this.trains_toshow.values().contains(zug)) continue;
                    this.remove(zug);
                }
                this.cacheContentCount = this.trains_toshow.values().size();
            }
        }
        catch (ConcurrentModificationException tmplist) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.refreshTimer != null && !this.refreshTimer.isRunning()) {
            this.refreshTimer.start();
        }
    }

    public void push(int zid, Train train) {
        try {
            if (!this.trains_toshow.containsKey(zid) && train.gleis != null) {
                this.trains_toshow.put(zid, train);
            }
        }
        catch (Exception e) {
            System.err.println("train==null, Eintrag nicht mehr mgl. (TrainAllPane.push()), wird \u00fcbersprungen");
        }
    }

    public void removeTrain(int zid, Train train) {
        if (this.trains_toshow.containsKey(zid)) {
            this.trains_toshow.remove(zid);
        }
    }

    public synchronized void addPanelToTrain(Train train) {
        if (train != null) {
            TrainPaneGreen newOne = new TrainPaneGreen(train, this, this.gridpane);
            this.train_content_pane.add(newOne);
            newOne.setBackground(new Color(240, 240, 240));
            this.zugpanellist.add(train);
            if (this.zugpanellist.size() > this.maxTrains) {
                this.maxTrains = this.zugpanellist.size();
                this.maxTrainsRealTime = this.mainUI.getClock().getRealCurrentTime();
                this.maxTrainsTime = this.mainUI.getClock().getTimeString();
            }
        }
    }

    @Override
    public synchronized void repaint() {
        this.update_panel();
        this.revalidate();
        super.repaintSuper();
    }

    public void remove(Train t) {
        TrainPane tpane = t.getTrainPanel();
        if (tpane != null) {
            super.remove(tpane);
        }
        if (t.isForArchive()) {
            Train train_for_archive = t;
            if (!this.archive.contains(train_for_archive)) {
                this.archive.add(train_for_archive);
            }
            train_for_archive.delPanels();
        } else {
            t.delPanels();
        }
        this.zugpanellist.remove(t);
    }

    @Override
    public synchronized void remove(TrainPane t) {
        this.remove(t.getZug());
        super.remove(t);
    }

    @Override
    public void remove(TrainButtonPane t) {
        super.remove(t);
    }

    @Override
    public JPanel getGridPane() {
        return this.gridpane;
    }

    @Override
    public void startRemoving(TrainPane train) {
        this.setBackground(new Color(240, 240, 240));
        this.remove(train);
    }

    @Override
    public void startFlashing(final TrainPane train) {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() {
                try {
                    boolean red = train.getZug().verspaetung >= 0;
                    int j = 1;
                    while (j < 5) {
                        int i = 1;
                        while (i < 401) {
                            train.setBackground(red ? new Color((int)(255.0f + 0.0f * (float)i), (int)(115.0f + 0.35f * (float)i), (int)(115.0f + 0.35f * (float)i)) : new Color((int)(255.0f + 0.0f * (float)i), (int)(240.0f + 0.0375f * (float)i), (int)(84.0f + 0.4275f * (float)i)));
                            Thread.sleep(1L);
                            ++i;
                        }
                        i = 200;
                        while (i > 0) {
                            train.setBackground(red ? new Color((int)(255.0f + 0.0f * (float)i), (int)(115.0f + 0.7f * (float)i), (int)(115.0f + 0.7f * (float)i)) : new Color((int)(255.0f + 0.0f * (float)i), (int)(240.0f + 0.075f * (float)i), (int)(84.0f + 0.855f * (float)i)));
                            Thread.sleep(1L);
                            --i;
                        }
                        ++j;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return true;
            }

            @Override
            protected void done() {
            }
        };
        worker.execute();
    }

    protected void addFromSinglePanel(TrainPaneGreen zug) {
        if (zug != null && zug.getZug() != null) {
            this.train_content_pane.add(zug);
            zug.setBackground(new Color(240, 240, 240));
        }
    }
}

