/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import plugin.MainUI;
import plugin.Train;
import plugin.TrainButtonPane;
import plugin.TrainDelayPane;
import plugin.TrainPane;
import plugin.TrainPaneGreen;
import plugin.TrainPaneOutside;

public class TrainAllOutsidePane
extends TrainDelayPane {
    private static final long serialVersionUID = 1L;
    private LinkedList<Train> zuglist = new LinkedList();
    private int cacheContentCount;
    private Timer refreshTimer;

    public TrainAllOutsidePane(MainUI ui) {
        super(ui);
    }

    @Override
    protected void refresh() {
        try {
            this.update_panel();
            this.repaint();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void push(int zid, final Train train) {
        if (train.gleis != null) {
            SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

                @Override
                protected Boolean doInBackground() {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    return true;
                }

                @Override
                protected void done() {
                    TrainAllOutsidePane.this.zuglist.add(train);
                }
            };
            worker.execute();
        }
    }

    public void addPanelToTrain(final Train train) {
        SwingWorker<TrainPaneOutside, Void> worker = new SwingWorker<TrainPaneOutside, Void>(){

            @Override
            protected TrainPaneOutside doInBackground() {
                return new TrainPaneOutside(train, TrainAllOutsidePane.this, TrainAllOutsidePane.this.gridpane);
            }

            @Override
            protected void done() {
                TrainPaneOutside newOne = null;
                try {
                    newOne = (TrainPaneOutside)this.get();
                    TrainAllOutsidePane.this.train_content_pane.add(newOne);
                    newOne.setBackground(new Color(240, 240, 240));
                    TrainAllOutsidePane.this.zugpanellist.add(train);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        };
        worker.execute();
    }

    @Override
    public synchronized void repaint() {
        super.revalidate();
        super.repaintSuper();
    }

    @Override
    protected void update_panel() {
        block9: {
            try {
                if (this.zuglist != null && this.zuglist.size() > this.cacheContentCount) {
                    this.cacheContentCount = this.zuglist.size();
                    for (Train zug : this.zuglist) {
                        if (zug == null || this.zugpanellist.contains(zug) || zug.sichtbar) continue;
                        TrainPaneOutside newOne = new TrainPaneOutside(zug, this, this.gridpane);
                        this.zugpanellist.add(zug);
                        try {
                            this.train_content_pane.add((Component)newOne, this.zuglist.indexOf(zug));
                        }
                        catch (IllegalArgumentException e) {
                            this.train_content_pane.add(newOne);
                        }
                        newOne.setBackground(new Color(240, 240, 240));
                    }
                    break block9;
                }
                if (this.zuglist != null && this.zuglist.size() < this.cacheContentCount) {
                    LinkedList tmplist = new LinkedList();
                    tmplist.addAll(this.zugpanellist);
                    for (Train zug : tmplist) {
                        if (zug == null || this.zuglist.contains(zug)) continue;
                        this.remove(zug.getTrainPanel());
                    }
                    this.cacheContentCount = this.zuglist.size();
                }
            }
            catch (ConcurrentModificationException e) {
                e.printStackTrace();
            }
        }
        if (this.refreshTimer != null && !this.refreshTimer.isRunning()) {
            this.refreshTimer.start();
        }
    }

    public synchronized void removeTrain(int zid, Train train) {
        this.zuglist.remove(train);
        this.cacheContentCount = this.zuglist.size();
    }

    @Override
    public synchronized void remove(TrainPane t) {
        this.zugpanellist.remove(t.getZug());
        this.zuglist.remove(t.getZug());
        this.cacheContentCount = this.zuglist.size();
        super.remove(t);
    }

    @Override
    public synchronized void remove(TrainButtonPane t) {
        super.remove(t);
    }

    @Override
    public JPanel getGridPane() {
        return this.gridpane;
    }

    @Override
    public void startRemoving(TrainPane train) {
        this.setBackground(new Color(240, 240, 240));
    }

    @Override
    public void startFlashing(final TrainPane train) {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() {
                try {
                    boolean red = train.getZug().verspaetung >= 0;
                    int j = 1;
                    while (j < 5) {
                        int i = 1;
                        while (i < 401) {
                            train.setBackground(red ? new Color((int)(255.0f + 0.0f * (float)i), (int)(115.0f + 0.35f * (float)i), (int)(115.0f + 0.35f * (float)i)) : new Color((int)(255.0f + 0.0f * (float)i), (int)(240.0f + 0.0375f * (float)i), (int)(84.0f + 0.4275f * (float)i)));
                            Thread.sleep(1L);
                            ++i;
                        }
                        i = 200;
                        while (i > 0) {
                            train.setBackground(red ? new Color((int)(255.0f + 0.0f * (float)i), (int)(115.0f + 0.7f * (float)i), (int)(115.0f + 0.7f * (float)i)) : new Color((int)(255.0f + 0.0f * (float)i), (int)(240.0f + 0.075f * (float)i), (int)(84.0f + 0.855f * (float)i)));
                            Thread.sleep(1L);
                            --i;
                        }
                        ++j;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return true;
            }

            @Override
            protected void done() {
            }
        };
        worker.execute();
    }

    protected void addFromSinglePanel(TrainPaneGreen zug) {
        this.train_content_pane.add(zug);
        zug.setBackground(new Color(240, 240, 240));
    }

    public void resort() {
        Collections.sort(this.zuglist);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TrainAllOutsidePane.this.train_content_pane.removeAll();
                for (Train zug : TrainAllOutsidePane.this.zuglist) {
                    if (zug.getTrainPanelOutside() == null) continue;
                    TrainAllOutsidePane.this.train_content_pane.add(zug.getTrainPanelOutside());
                }
            }
        });
    }
}

