/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import js.java.stspluginlib.PluginClient;
import plugin.ButtonPane;
import plugin.DecryptedTimeTable;
import plugin.TabbedPluginPane;
import plugin.TrainPane;
import plugin.TrainPaneGreen;
import plugin.TrainPaneOutside;

public class Train
implements Comparable<Train> {
    protected boolean amgleis;
    protected int eigeneVerspaetung = 0;
    protected int eigeneVerspaetungFix = 0;
    protected String gleis;
    public final String nach;
    protected final String name;
    private String notiz = "";
    protected DecryptedTimeTable plan = null;
    protected String plangleis;
    protected boolean sichtbar;
    protected boolean steht;
    private TrainPaneOutside train_outside_pane;
    private TrainPaneGreen trainPaneGreen;
    private TrainPane trainPanel = null;
    private final TabbedPluginPane ui;
    protected int verspaetung;
    public final String von;
    protected final int zid;
    private Timer archivetimer;
    protected boolean archived = false;
    protected String tmpGleis = "";
    protected boolean deleted = false;
    protected long real_arrival = 0L;
    protected long real_exit = 0L;
    private boolean isRemoving = false;
    protected ButtonPane.MarkerColors marker_color;

    protected Train(PluginClient.ZugDetails start_data, TabbedPluginPane ui) {
        this.zid = start_data.zid;
        this.name = start_data.name;
        this.verspaetung = start_data.verspaetung;
        this.gleis = start_data.gleis;
        this.plangleis = start_data.plangleis;
        this.von = start_data.von;
        this.nach = start_data.nach;
        this.sichtbar = start_data.sichtbar;
        this.amgleis = start_data.amgleis;
        this.ui = ui;
        this.startArchiveTimer();
    }

    @Override
    public int compareTo(Train o) {
        int result = 0;
        if (this.zid == o.zid) {
            return 0;
        }
        if (this.plan == null || o.plan == null) {
            // empty if block
        }
        result = !this.archived && !this.sichtbar ? (this.plan != null && o.plan != null ? ((int)(this.plan.eta - o.plan.eta) == 0 ? (this.von.compareTo(o.von) == 0 ? (this.nach.compareTo(o.nach) == 0 ? (this.name.compareTo(o.name) == 0 ? 0 : this.name.compareTo(o.name)) : this.nach.compareTo(o.nach)) : this.von.compareTo(o.von)) : (int)(this.plan.eta - o.plan.eta)) : this.von.compareTo(o.von)) : (!this.archived && this.sichtbar ? (this.plan != null && o.plan != null ? ((int)(this.plan.eta - o.plan.eta) == 0 ? (this.von.compareTo(o.von) == 0 ? (this.nach.compareTo(o.nach) == 0 ? (this.name.compareTo(o.name) == 0 ? 0 : this.name.compareTo(o.name)) : this.nach.compareTo(o.nach)) : this.von.compareTo(o.von)) : (int)(this.plan.eta - o.plan.eta)) : this.von.compareTo(o.von)) : (int)(this.real_exit - o.real_exit > 0L ? this.real_exit - o.real_exit : this.real_arrival - o.real_arrival));
        return result;
    }

    public void forceGleisUpdate() {
        if (this.trainPanel != null) {
            this.trainPanel.createGleisB(true);
        }
        if (this.trainPaneGreen != null) {
            this.trainPaneGreen.createGleisB(true);
        }
        if (this.train_outside_pane != null) {
            this.train_outside_pane.createGleisB(true);
        }
    }

    public void setAlarmEnabled(boolean e) {
        if (this.train_outside_pane != null) {
            this.train_outside_pane.setAlarmEnabled(e);
        }
    }

    public void setNotecolorEverywhere(ButtonPane.MarkerColors color) {
        this.marker_color = color;
        if (this.train_outside_pane != null) {
            this.train_outside_pane.notizB.setBackground(color.getBackground());
            this.train_outside_pane.notizB.setForeground(color.getForeground());
        }
        if (this.trainPaneGreen != null) {
            this.trainPaneGreen.notizB.setBackground(color.getBackground());
            this.trainPaneGreen.notizB.setForeground(color.getForeground());
        }
        if (this.trainPanel != null) {
            this.trainPanel.notizB.setBackground(color.getBackground());
            this.trainPanel.notizB.setForeground(color.getForeground());
        }
    }

    public void updateName() {
        if (this.train_outside_pane != null) {
            this.train_outside_pane.updateName();
        }
        if (this.trainPaneGreen != null) {
            this.trainPaneGreen.updateName();
        }
        if (this.trainPanel != null) {
            this.trainPanel.updateName();
        }
    }

    public void setTrainPanelOutside(TrainPaneOutside trainPaneOutside) {
        this.train_outside_pane = trainPaneOutside;
    }

    protected void abwinken() {
        this.steht = false;
    }

    protected void delPanels() {
        this.deleted = true;
        if (!this.isRemoving()) {
            this.isRemoving = true;
            SwingWorker<Boolean, Boolean> worker = new SwingWorker<Boolean, Boolean>(){

                @Override
                protected Boolean doInBackground() {
                    Train.this.real_exit = Train.this.ui.getMainUI().getClock().getTime();
                    Train.this.archived = true;
                    try {
                        Thread.sleep(6000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (Train.this.trainPanel != null) {
                        Train.this.getTrainPanel().abwinken2();
                    }
                    if (Train.this.trainPanel != null) {
                        Train.this.getTrainPanel().mainPanel.remove(Train.this.getTrainPanel());
                    }
                    if (Train.this.trainPaneGreen != null) {
                        Train.this.trainPaneGreen.abwinken2();
                    }
                    if (Train.this.train_outside_pane != null) {
                        Train.this.train_outside_pane.abwinken2();
                    }
                    return true;
                }

                @Override
                protected void done() {
                    Train.this.train_outside_pane = null;
                    Train.this.trainPaneGreen = null;
                    Train.this.trainPanel = null;
                }
            };
            worker.execute();
        }
    }

    protected String getNote() {
        return this.notiz;
    }

    protected TrainPane getTrainPanel() {
        return this.trainPanel;
    }

    protected TrainPaneGreen getTrainPanelGreen() {
        return this.trainPaneGreen;
    }

    protected TrainPaneOutside getTrainPanelOutside() {
        return this.train_outside_pane;
    }

    protected TabbedPluginPane getUi() {
        return this.ui;
    }

    protected boolean isForArchive() {
        return this.archivetimer == null;
    }

    protected boolean isSichtbar() {
        return this.sichtbar;
    }

    protected void removeFromOutsideList() {
        if (this.train_outside_pane != null) {
            this.train_outside_pane.abwinken2();
        }
        if (this.trainPaneGreen != null) {
            this.trainPaneGreen.setTrainArrivedNow(this.von.equals(""));
        }
        this.real_arrival = this.ui.getMainUI().getClock().getTime();
    }

    protected void setAnimationsEnabled(boolean b) {
        if (this.trainPanel != null) {
            this.trainPanel.setAnimationsEnabled(b);
        }
        if (this.trainPaneGreen != null) {
            this.trainPaneGreen.setAnimationsEnabled(b);
        }
        if (this.train_outside_pane != null) {
            this.train_outside_pane.setAnimationsEnabled(b);
        }
    }

    public void refreshVerspaetungHardMode() {
        if (this.trainPanel != null) {
            this.trainPanel.updateAnzeigeHardMode();
        }
        if (this.trainPaneGreen != null) {
            this.trainPaneGreen.updateAnzeigeHardMode();
        }
        if (this.train_outside_pane != null) {
            this.train_outside_pane.updateAnzeigeHardMode();
        }
    }

    protected void setNewMaxStops() {
        this.forceGleisUpdate();
    }

    protected void setNote(String note) {
        this.notiz = note;
        if (this.trainPaneGreen != null) {
            this.trainPaneGreen.fireNote(note);
        }
        if (this.trainPanel != null) {
            this.trainPanel.fireNote(note);
        }
    }

    protected void setSichtbar(boolean sichtbarNew) {
        if (!this.sichtbar && sichtbarNew && this.trainPaneGreen == null) {
            this.ui.getAllpanel().addPanelToTrain(this);
            this.removeFromOutsideList();
        } else if (this.sichtbar && !sichtbarNew && this.trainPaneGreen != null) {
            this.ui.getAllpanel().removeTrain(this.zid, this);
        }
        this.sichtbar = sichtbarNew;
    }

    protected void setTrainPanel(TrainPane t) {
        this.trainPanel = t;
    }

    protected void setTrainPanelGreen(TrainPaneGreen trainPane) {
        this.trainPaneGreen = trainPane;
    }

    protected boolean update(PluginClient.ZugDetails other) {
        boolean ret = false;
        if (this.gleis == null) {
            return ret;
        }
        this.tmpGleis = other.gleis;
        if (this.plangleis != null && other.plangleis != null) {
            boolean bl = ret = !this.plangleis.equals(other.plangleis);
        }
        if (this.sichtbar && other.sichtbar && this.verspaetung != other.verspaetung && this.isForArchive()) {
            this.steht = true;
            if (other.verspaetung > 0) {
                if (other.verspaetung < this.verspaetung) {
                    if (this.eigeneVerspaetung != 0) {
                        int plusminus = other.verspaetung - this.verspaetung;
                        this.ui.korrigiereVerspaetung(plusminus);
                        this.eigeneVerspaetung += plusminus;
                        if (this.eigeneVerspaetung < 0) {
                            this.eigeneVerspaetung = 0;
                        }
                    }
                } else {
                    this.ui.meldeVerspaetung();
                    ++this.eigeneVerspaetung;
                    ++this.eigeneVerspaetungFix;
                }
            }
        }
        if (this.gleis != null && other.gleis != null && !this.gleis.equals(other.gleis)) {
            this.steht = false;
        }
        if (!(this.trainPaneGreen == null || this.amgleis == other.amgleis && this.verspaetung == other.verspaetung && this.sichtbar == other.sichtbar && this.gleis.equals(other.gleis) && this.plangleis.equals(other.plangleis))) {
            this.trainPaneGreen.update(other.verspaetung, other.gleis, other.plangleis, other.sichtbar, this.eigeneVerspaetung, this.eigeneVerspaetungFix, other.amgleis);
        }
        if (!(this.trainPanel == null || this.amgleis == other.amgleis && this.verspaetung == other.verspaetung && this.sichtbar == other.sichtbar && this.gleis.equals(other.gleis) && this.plangleis.equals(other.plangleis))) {
            this.trainPanel.update(other.verspaetung, other.gleis, other.plangleis, other.sichtbar, this.eigeneVerspaetung, this.eigeneVerspaetungFix, other.amgleis);
        }
        if (!(this.train_outside_pane == null || this.verspaetung == other.verspaetung && this.sichtbar == other.sichtbar && this.gleis.equals(other.gleis) && this.plangleis.equals(other.plangleis))) {
            this.train_outside_pane.update(other.verspaetung, other.gleis, other.plangleis, other.sichtbar, this.eigeneVerspaetung, this.eigeneVerspaetungFix, other.amgleis);
        }
        this.amgleis = other.amgleis;
        this.verspaetung = other.verspaetung;
        this.setSichtbar(other.sichtbar);
        this.gleis = other.gleis;
        this.plangleis = other.plangleis;
        return ret;
    }

    private boolean isRemoving() {
        return this.isRemoving;
    }

    private void startArchiveTimer() {
        this.archivetimer = new Timer(70000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Train.this.archivetimer.stop();
                Train.this.archivetimer = null;
            }
        });
        this.archivetimer.start();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.amgleis ? 1231 : 1237);
        result = 31 * result + this.eigeneVerspaetung;
        result = 31 * result + (this.gleis == null ? 0 : this.gleis.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.notiz == null ? 0 : this.notiz.hashCode());
        result = 31 * result + (this.plan == null ? 0 : this.plan.hashCode());
        result = 31 * result + (this.plangleis == null ? 0 : this.plangleis.hashCode());
        result = 31 * result + (this.sichtbar ? 1231 : 1237);
        result = 31 * result + (this.steht ? 1231 : 1237);
        result = 31 * result + this.verspaetung;
        result = 31 * result + this.zid;
        result = 31 * result + this.zid;
        return result;
    }
}

