/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import plugin.TrainButtonPane;

public class TablePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int maxContent;
    private int currentContentCount;
    private LinkedList<Component> stack;
    private Timer refreshTimer;

    protected TablePanel() {
        this(1, 1, 0, 0);
    }

    protected TablePanel(int x, int y, int spacer_x, int spacer_y) {
        this.maxContent = x * y;
        this.setLayout(new GridLayout(x, y, spacer_x, spacer_y));
        this.stack = new LinkedList();
        this.fillEmptys();
        this.addAutoRefresh();
    }

    private void addAutoRefresh() {
        this.refreshTimer = new Timer(1100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePanel.this.refresh();
            }
        });
        this.refreshTimer.start();
    }

    protected void refresh() {
        if (!this.stack.isEmpty()) {
            this.startFlashing();
        }
    }

    private void fillEmptys() {
        this.currentContentCount = this.getComponentCount();
        int i = this.getComponentCount();
        while (i < this.maxContent) {
            JPanel cont = new JPanel();
            cont.setName("delete_me");
            super.add(cont);
            ++i;
        }
    }

    protected void startFlashing() {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() {
                try {
                    boolean red = true;
                    int i = 200;
                    while (i > 0) {
                        TablePanel.this.setBackground(red ? new Color((int)(255.0f + -0.075f * (float)i), (int)(115.0f + 0.625f * (float)i), (int)(115.0f + 0.625f * (float)i)) : new Color((int)(255.0f + -0.075f * (float)i), (int)(240.0f + 0.0f * (float)i), (int)(84.0f + 0.78f * (float)i)));
                        Thread.sleep(2L);
                        --i;
                    }
                    i = 0;
                    while (i < 201) {
                        TablePanel.this.setBackground(red ? new Color((int)(255.0f + -0.075f * (float)i), (int)(115.0f + 0.625f * (float)i), (int)(115.0f + 0.625f * (float)i)) : new Color((int)(255.0f + -0.075f * (float)i), (int)(240.0f + 0.0f * (float)i), (int)(84.0f + 0.78f * (float)i)));
                        Thread.sleep(2L);
                        ++i;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }

            @Override
            protected void done() {
            }
        };
        worker.execute();
    }

    @Override
    public void remove(Component c) {
        super.remove(c);
        if (!this.stack.isEmpty()) {
            TrainButtonPane train = (TrainButtonPane)this.stack.pollFirst();
            if (train.getZug() != null && train.getZug().getTrainPanel() != null && train.getZug().getTrainPanel().getGridpane() != null) {
                super.add(train);
                train.startFlashing();
            }
        } else {
            --this.currentContentCount;
            JPanel cont = new JPanel();
            cont.setName("delete_me");
            super.add(cont);
        }
        if (this.getComponentCount() > this.maxContent) {
            this.repairGridContent();
        }
    }

    @Override
    public Component add(Component c) {
        if (this.currentContentCount < this.maxContent) {
            c.setName("");
            super.add(c, this.currentContentCount);
            ++this.currentContentCount;
            if (this.currentContentCount < this.getComponentCount() && this.getComponent(this.currentContentCount).getName().equals("delete_me")) {
                super.remove(this.currentContentCount);
            }
        } else {
            this.stack.addLast(c);
        }
        if (this.getComponentCount() > this.maxContent) {
            this.repairGridContent();
        }
        return c;
    }

    private void repairGridContent() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c.getName() == null || c.getName().equals("delete_me")) {
                super.remove(c);
            }
            ++n2;
        }
        this.fillEmptys();
    }
}

