/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import layout.TableLayout;
import plugin.ChangeLogPanel;
import plugin.MainUI;
import plugin.OptionsPane;
import plugin.TabbedTrainDelayPane;
import plugin.Train;
import plugin.TrainAllOutsidePane;
import plugin.TrainAllPane;

public class TabbedPluginPane
extends JTabbedPane {
    public static final boolean DEBUG = true;
    private static final long serialVersionUID = 1L;
    private TrainAllPane all_inside_panel;
    private TrainAllOutsidePane all_outside_panel;
    private int counter = 0;
    private int counterTmp;
    private boolean flashed;
    private MainUI mainUI;
    private Timer refreshTimer;
    private TabbedTrainDelayPane trainpane;
    private int warningstatus;
    private ChangeLogPanel changelog;

    protected TabbedPluginPane(MainUI ui) {
        this.trainpane = new TabbedTrainDelayPane(ui);
        this.all_inside_panel = new TrainAllPane(ui);
        this.all_outside_panel = new TrainAllOutsidePane(ui);
        this.addTab(" Versp\u00e4tung ", this.trainpane);
        this.addTab(" Alle im Stellwerk ", this.all_inside_panel);
        this.addTab(" Bald eintreffend ", this.all_outside_panel);
        OptionsPane optionenpanel = new OptionsPane(ui);
        ui.getOptions().setOptionsPane(optionenpanel.getContentPane());
        this.addTab(" Optionen ", optionenpanel);
        JPanel changelogpanel = new JPanel();
        changelogpanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, -3.0, -1.0}, {-1.0, -3.0, -1.0}}));
        this.changelog = new ChangeLogPanel();
        changelogpanel.add((Component)this.changelog, "1,1");
        this.addTab(" Versionsinfos ", changelogpanel);
        this.mainUI = ui;
        this.addAutoRefresh();
    }

    private void addAutoRefresh() {
        this.refreshTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabbedPluginPane.this.refresh();
            }
        });
        this.refreshTimer.start();
    }

    protected void addToAllList(Integer zid, Train train) {
        this.all_inside_panel.push(zid, train);
    }

    protected void addToOutsideList(int zid, Train train) {
        this.all_outside_panel.push(zid, train);
    }

    protected TrainAllPane getAllpanel() {
        return this.all_inside_panel;
    }

    protected MainUI getMainUI() {
        return this.mainUI;
    }

    protected void meldeVerspaetung() {
        this.mainUI.meldeVerspaetung();
    }

    protected void korrigiereVerspaetung(int plusminus) {
        this.mainUI.korrigiereVerspaetung(plusminus);
    }

    protected void push(HashMap<Integer, Train> zuglist) {
        this.trainpane.push(zuglist);
        this.all_inside_panel.push(zuglist);
        this.all_outside_panel.push(zuglist);
    }

    protected void refresh() {
        boolean bl = this.flashed = !this.flashed;
        if (this.getSelectedIndex() == 0 || this.counterTmp == this.counter || !this.trainpane.trainDelayPane.hasElements()) {
            if (this.counterTmp != this.counter) {
                this.counterTmp = this.counter;
            }
            this.warningstatus = 0;
            this.setForegroundAt(0, Color.BLACK);
            return;
        }
        if (!this.flashed) {
            try {
                this.setForegroundAt(0, this.warningstatus == 1 ? Color.ORANGE : (this.warningstatus == 2 ? Color.RED : Color.BLACK));
            }
            catch (NullPointerException e) {
                System.err.println("Caught in TabbedPluginPane.refresh() - " + e);
            }
        } else {
            try {
                this.setForegroundAt(0, Color.BLACK);
            }
            catch (NullPointerException e) {
                System.err.println("Caught in TabbedPluginPane.refresh() - " + e);
            }
        }
        this.revalidate();
        this.repaint();
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.validate();
            c.repaint();
            ++n2;
        }
    }

    protected void removeFromAllList(int zid, Train train) {
        this.all_inside_panel.removeTrain(zid, train);
    }

    protected void setStellwerk(String name) {
        this.mainUI.setStellwerk(name);
    }

    protected void setWarning(int i) {
        ++this.counter;
        if (this.warningstatus == 2) {
            if (i != 1) {
                this.warningstatus = i;
            }
        } else {
            this.warningstatus = i;
        }
    }

    public ChangeLogPanel getChangelog() {
        return this.changelog;
    }
}

