/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import plugin.OptionsManager;

public class SystemInfo {
    private String infos = String.valueOf(this.infos) + System.getProperties().getProperty("sun.os.patch.level") + "\r\n\r\n";

    public SystemInfo(OptionsManager options) {
        Runtime rt = Runtime.getRuntime();
        this.infos = String.valueOf(this.infos) + "VM-Arbeitsspeicher\r\nMax total:   " + rt.maxMemory() / 0x100000L + " MB\r\n" + "Max aktuell: " + rt.totalMemory() / 0x100000L + " MB\r\n" + "Verbraucht:  " + (rt.totalMemory() - rt.freeMemory()) / 0x100000L + " MB\r\n" + "Frei:        " + rt.freeMemory() / 0x100000L + " MB    \r\n\r\n";
        this.infos = String.valueOf(this.infos) + "STS Plugin Version\r\nLokal:  " + options.mainUI.build + "\r\n";
        this.infos = String.valueOf(this.infos) + "Online: " + (options.mainUI.onlineversion == 0 ? "unbekannt" : Integer.valueOf(options.mainUI.onlineversion)) + (options.mainUI.onlineversion > options.mainUI.build ? " (Update verf\u00fcgbar)" : "") + "\r\n\r\n";
        this.infos = String.valueOf(this.infos) + "Plugin, Debug-Modus: nicht aktiv\r\n";
        this.infos = String.valueOf(this.infos) + "Plugin, Events:      aktiv\r\n\r\n";
        this.infos = String.valueOf(this.infos) + "Session:\r\nSim-Zeit: " + options.mainUI.getClock().getTimeString() + "\r\n";
        this.infos = String.valueOf(this.infos) + "Echtzeit: " + options.mainUI.getClock().getRealCurrentTime() + "\r\n";
        this.infos = String.valueOf(this.infos) + "Dauer:    " + options.mainUI.getClock().getTotalTime() + "\r\n";
        JTextArea tf = new JTextArea(this.infos);
        tf.setEditable(false);
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 3));
        JButton copybutton = new JButton("Kopieren");
        copybutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(SystemInfo.this.infos), null);
                }
                catch (HeadlessException ex) {
                    System.err.println("Konnte nicht kopiert werden");
                }
            }
        });
        JScrollPane tf_scroller = new JScrollPane(tf);
        tf.setFont(new Font("Monospaced", 1, 12));
        copybutton.setFont(new Font("Dialog", 1, 14));
        JPanel stretchpane = new JPanel(new GridLayout(1, 1));
        stretchpane.setPreferredSize(new Dimension(200, 50));
        stretchpane.setMinimumSize(new Dimension(200, 50));
        stretchpane.setMaximumSize(new Dimension(2000, 50));
        stretchpane.add(copybutton);
        pane.add(tf_scroller);
        pane.add(stretchpane);
        JFrame frame = new JFrame("System-Informationen (STS Analyse-Plugin)");
        frame.setIconImage(new ImageIcon("./src/plugin/images/info.png").getImage());
        frame.add(pane);
        frame.pack();
        frame.setLocationRelativeTo(options.mainUI);
        frame.setVisible(true);
    }
}

