/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class StopTimeIcon {
    private RenderingHints hints;

    protected StopTimeIcon() {
        HashMap<RenderingHints.Key, Object> map = new HashMap<RenderingHints.Key, Object>();
        map.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        map.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        map.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.hints = new RenderingHints(map);
    }

    protected ImageIcon getStopImage(int minutes) {
        return new ImageIcon(this.addTimeToImage(minutes, new ImageIcon("./src/plugin/images/icon_halt.gif")));
    }

    protected ImageIcon getStopForceImage(int minutes) {
        return new ImageIcon(this.addTimeToImage(minutes, new ImageIcon("./src/plugin/images/icon_vorzeitig.gif")));
    }

    protected ImageIcon getStopIfNeededImage(int minutes) {
        return new ImageIcon(this.addTimeToImage(minutes, new ImageIcon("./src/plugin/images/icon_bedarfshalt.gif")));
    }

    protected ImageIcon getStopReverseImage(int minutes) {
        return new ImageIcon(this.addTimeToImage(minutes, new ImageIcon("./src/plugin/images/icon_halt_umdrehen.gif")));
    }

    protected BufferedImage addTimeToImage(int minutes, ImageIcon source) {
        String string = String.valueOf(minutes);
        if (string.equals("0")) {
            string = "K";
        }
        BufferedImage img = this.toBufferedImage(source.getImage(), false);
        BufferedImage aimg = new BufferedImage(img.getWidth(), img.getHeight(), 3);
        Graphics2D g = aimg.createGraphics();
        g.addRenderingHints(this.hints);
        g.drawImage(img, null, 0, 0);
        g.setColor(Color.BLACK);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setFont(new Font("Verdana", 1, 9));
        g.translate(aimg.getWidth() / 2, aimg.getHeight() / 2);
        FontMetrics fontMetrics = g.getFontMetrics();
        Rectangle2D rect = fontMetrics.getStringBounds(string, g);
        int relativePosX = 5;
        int relativePosY = 9;
        g.drawString(string, (0 - (int)rect.getWidth()) / 2 + relativePosX, (0 - (int)rect.getHeight()) / 2 + relativePosY);
        g.dispose();
        return aimg;
    }

    protected BufferedImage toBufferedImage(Image image, boolean hasAlpha) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = hasAlpha ? 2 : 1;
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics g = bimage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }
}

