/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowStateListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import layout.TableLayout;
import plugin.Blinker;
import plugin.MainUI;
import plugin.PlatformControl;
import plugin.PlatformOptions;
import plugin.PlatformTimeTable;
import plugin.PlatformUiHeader;
import plugin.Train;

public class PlatformUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    private MainUI mainUI;
    private TreeMap<String, PlatformTimeTable> bahnsteige;
    private HashMap<Integer, Train> zuglist;
    protected boolean docked = true;
    private JMenuBar menu;
    private JCheckBox dock_checkbox;
    private JMenu bahnsteig_menu;
    private JPanel leftpane;
    private JScrollPane leftscroller;
    private JPanel leftmainpane;
    protected boolean focustemp = false;
    private final double[][] main_tbSize = new double[][]{{-1.0}, {-3.0, -1.0}};
    private final int ONE = 1;
    private final int TWO = 2;
    private final int THREE = 3;
    private PlatformControl control;
    private PlatformUiHeader[] headers = new PlatformUiHeader[3];
    private Timer initTimer;
    private JMenu ansicht_menu;
    private JRadioButton ansicht_one;
    private JRadioButton ansicht_two;
    private JRadioButton ansicht_three;
    private ButtonGroup ansicht_group;
    private int columns;
    private int columns_old;
    private JPanel middlepane;
    private JScrollPane middlescroller;
    private JPanel mainpane;
    private JPanel middlemainpane;
    protected Dimension size;
    private JPanel rightpane;
    private JPanel rightmainpane;
    private JButton optionsbutton;
    private boolean edit_mode = false;
    private String name_registry;

    public String convertName(String name) {
        String result = name.replaceAll("[ [^\\w\\d\\-\u00e4\u00fc\u00f6\u00c4\u00dc\u00d6&\\._]]", "_");
        result = result.replaceAll("[\u00e4]", "ae");
        result = result.replaceAll("[\u00fc]", "ue");
        result = result.replaceAll("[\u00f6]", "oe");
        result = result.replaceAll("[\u00d6]", "Oe");
        result = result.replaceAll("[\u00c4]", "Ae");
        result = result.replaceAll("[\u00dc]", "Ue");
        result = result.replaceAll("[&]", "und");
        result = result.replaceAll("[.]", "");
        return result.toLowerCase();
    }

    public PlatformUI(MainUI mainUI) {
        this.setMainUI(mainUI);
        this.setTitle("Bahnsteige (STS Analyse Plugin)");
        this.setIconImage(new ImageIcon("./src/plugin/images/train_icon.png").getImage());
        this.leftpane = new JPanel();
        this.leftpane.setLayout(new BoxLayout(this.leftpane, 3));
        this.leftscroller = new JScrollPane(this.leftpane, 22, 31);
        this.middlepane = new JPanel();
        this.middlepane.setLayout(new BoxLayout(this.middlepane, 3));
        this.middlescroller = new JScrollPane(this.middlepane, 22, 31);
        this.rightpane = new JPanel();
        this.rightpane.setLayout(new BoxLayout(this.rightpane, 3));
        JScrollPane rightscroller = new JScrollPane(this.rightpane, 22, 31);
        this.columns = this.getMainUI().getOptions().getPlatformOptions().getMode();
        this.columns_old = this.getMainUI().getOptions().getPlatformOptions().getMode();
        this.setSize(new Dimension(this.columns == 1 ? 500 : (this.columns == 2 ? 700 : 900), 700));
        this.leftmainpane = new JPanel();
        this.leftmainpane.setLayout((LayoutManager)new TableLayout(this.main_tbSize));
        this.headers[0] = new PlatformUiHeader(this);
        this.leftmainpane.add((Component)this.headers[0], "0,0");
        this.leftmainpane.add((Component)this.leftscroller, "0,1");
        this.middlemainpane = new JPanel();
        this.middlemainpane.setLayout((LayoutManager)new TableLayout(this.main_tbSize));
        this.headers[1] = new PlatformUiHeader(this);
        this.middlemainpane.add((Component)this.headers[1], "0,0");
        this.middlemainpane.add((Component)this.middlescroller, "0,1");
        this.rightmainpane = new JPanel();
        this.rightmainpane.setLayout((LayoutManager)new TableLayout(this.main_tbSize));
        this.headers[2] = new PlatformUiHeader(this);
        this.rightmainpane.add((Component)this.headers[2], "0,0");
        this.rightmainpane.add((Component)rightscroller, "0,1");
        this.mainpane = new JPanel(new GridLayout(1, 3, 10, 0));
        this.mainpane.add(this.leftmainpane);
        this.setContentPane(this.mainpane);
        this.menu = new JMenuBar();
        this.bahnsteig_menu = new JMenu(" Bahnsteig-Auswahl ");
        this.menu.add(this.bahnsteig_menu);
        this.bahnsteig_menu.setFont(new Font("Sans Serif", 1, 10));
        this.ansicht_menu = new JMenu(" Ansicht ");
        this.menu.add(this.ansicht_menu);
        this.ansicht_menu.setFont(new Font("Sans Serif", 1, 10));
        this.menu.add(Box.createHorizontalGlue());
        this.optionsbutton = new JButton(" Bearbeiten ");
        this.optionsbutton.setFont(new Font("Sans Serif", 1, 10));
        this.optionsbutton.setFocusPainted(false);
        this.optionsbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlatformUI.this.edit_mode();
            }
        });
        this.optionsbutton.setVisible(!this.getMainUI().getOptions().getPlatformOptions().isMode(1));
        this.menu.add(this.optionsbutton);
        this.dock_checkbox = new JCheckBox("Andocken", true);
        this.menu.add(this.dock_checkbox);
        this.dock_checkbox.setFont(new Font("Sans Serif", 1, 10));
        this.dock_checkbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                PlatformUI.this.docked = PlatformUI.this.dock_checkbox.isSelected();
                if (PlatformUI.this.dock_checkbox.isSelected()) {
                    PlatformUI.this.setSizeAndPos(PlatformUI.this.mainUI.getSize(), PlatformUI.this.mainUI.getLocation());
                    if (Toolkit.getDefaultToolkit().isFrameStateSupported(0) && Toolkit.getDefaultToolkit().isFrameStateSupported(1) && PlatformUI.this.docked) {
                        PlatformUI.this.mainUI.setExtendedState(PlatformUI.this.getExtendedState());
                    }
                }
            }
        });
        this.dock_checkbox.setOpaque(false);
        this.dock_checkbox.setFocusPainted(false);
        this.ansicht_one = new JRadioButton("1 Spalte", this.getMainUI().getOptions().getPlatformOptions().isMode(1));
        this.ansicht_two = new JRadioButton("2 Spalten", this.getMainUI().getOptions().getPlatformOptions().isMode(2));
        this.ansicht_three = new JRadioButton("3 Spalten", this.getMainUI().getOptions().getPlatformOptions().isMode(3));
        this.ansicht_group = new ButtonGroup();
        this.ansicht_group.add(this.ansicht_one);
        this.ansicht_group.add(this.ansicht_two);
        this.ansicht_group.add(this.ansicht_three);
        this.ansicht_menu.add(this.ansicht_one);
        this.ansicht_menu.add(this.ansicht_two);
        this.ansicht_menu.add(this.ansicht_three);
        this.ansicht_one.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (PlatformUI.this.ansicht_one.isSelected() && PlatformUI.this.columns != 1) {
                    PlatformUI.this.columns_old = PlatformUI.this.columns;
                    PlatformUI.this.columns = 1;
                    PlatformUI.this.aufteilen();
                }
            }
        });
        this.ansicht_two.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (PlatformUI.this.ansicht_two.isSelected() && PlatformUI.this.columns != 2) {
                    PlatformUI.this.columns_old = PlatformUI.this.columns;
                    PlatformUI.this.columns = 2;
                    PlatformUI.this.aufteilen();
                }
            }
        });
        this.ansicht_three.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (PlatformUI.this.ansicht_three.isSelected() && PlatformUI.this.columns != 3) {
                    PlatformUI.this.columns_old = PlatformUI.this.columns;
                    PlatformUI.this.columns = 3;
                    PlatformUI.this.aufteilen();
                }
            }
        });
        this.setJMenuBar(this.menu);
        this.control = new PlatformControl(this);
        this.addComponentListener();
        this.addinitTimer();
    }

    protected void edit_mode() {
        this.edit_mode = !this.edit_mode;
        for (PlatformTimeTable platform : this.bahnsteige.values()) {
            platform.edit(this.edit_mode);
        }
        this.optionsbutton.setText(this.edit_mode ? "Bearbeitung beenden" : "Bearbeiten");
        this.optionsbutton.setForeground(this.edit_mode ? Color.RED : Color.BLACK);
        this.save();
    }

    protected void aufteilen() {
        int links = 0;
        int rechts = 0;
        int mitte = 0;
        if (this.columns == 2) {
            links = this.bahnsteige.size() / 2;
            if (links != (rechts = this.bahnsteige.size() / 2) || links + rechts != this.bahnsteige.size()) {
                if (links == rechts && links + rechts != this.bahnsteige.size()) {
                    ++links;
                } else if (links != rechts && links + rechts != this.bahnsteige.size()) {
                    ++rechts;
                }
            }
        } else if (this.columns == 3) {
            links = this.bahnsteige.size() / 3;
            mitte = this.bahnsteige.size() / 3;
            rechts = this.bahnsteige.size() / 3;
            if (links != rechts || rechts != links || links + rechts + mitte != this.bahnsteige.size()) {
                if (links == rechts && rechts == links && links + rechts + mitte != this.bahnsteige.size()) {
                    if (++links + rechts + mitte != this.bahnsteige.size() && links + rechts + ++mitte != this.bahnsteige.size()) {
                        System.err.println("FEHLBERECHNUNG SPALTENINHALTE");
                    }
                } else if (links > mitte && links + rechts + mitte != this.bahnsteige.size()) {
                    if (links + rechts + ++mitte != this.bahnsteige.size() && links + ++rechts + mitte != this.bahnsteige.size()) {
                        System.err.println("FEHLBERECHNUNG SPALTENINHALTE");
                    }
                } else if (links > mitte && links + rechts + mitte != this.bahnsteige.size() && links + ++rechts + mitte != this.bahnsteige.size()) {
                    System.err.println("FEHLBERECHNUNG SPALTENINHALTE");
                }
            }
        }
        LinkedList<PlatformTimeTable> sortedlist = new LinkedList<PlatformTimeTable>();
        sortedlist.addAll(this.bahnsteige.values());
        Collections.sort(sortedlist);
        JPanel target_pane = null;
        int count = 1;
        for (PlatformTimeTable platform : sortedlist) {
            if (this.columns == 1) {
                target_pane = this.leftpane;
                platform.leftbutton.setEnabled(false);
                platform.rightbutton.setEnabled(false);
                platform.column_owner = 1;
            } else if (this.columns == 2) {
                target_pane = count > links ? this.middlepane : this.leftpane;
                platform.leftbutton.setEnabled(count > links);
                platform.rightbutton.setEnabled(count <= links);
                platform.column_owner = count > links ? 2 : 1;
            } else if (this.columns == 3) {
                target_pane = count > links ? (count > mitte + links ? this.rightpane : this.middlepane) : this.leftpane;
                platform.leftbutton.setEnabled(count > links);
                platform.rightbutton.setEnabled(count <= links + mitte);
                platform.column_owner = count > links ? (count > links + mitte ? 3 : 2) : 1;
            }
            target_pane.add(platform);
            if (sortedlist.indexOf(platform) != sortedlist.size() - 1) {
                platform.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, Color.GRAY));
            }
            ++count;
        }
        this.mainpane.remove(this.middlemainpane);
        this.mainpane.remove(this.rightmainpane);
        this.optionsbutton.setVisible(false);
        if (this.columns == 2 || this.columns == 3) {
            this.mainpane.add(this.middlemainpane);
            this.optionsbutton.setVisible(true);
            if (this.columns == 3) {
                this.mainpane.add(this.rightmainpane);
            }
        }
        Component[] components = this.leftpane.getComponents();
        int i = 0;
        while (i < this.leftpane.getComponentCount()) {
            this.bahnsteige.get((Object)components[i].toString()).upbutton.setEnabled(i != 0);
            this.bahnsteige.get((Object)components[i].toString()).downbutton.setEnabled(i != this.leftpane.getComponentCount() - 1);
            ++i;
        }
        components = this.middlepane.getComponents();
        i = 0;
        while (i < this.middlepane.getComponentCount()) {
            this.bahnsteige.get((Object)components[i].toString()).upbutton.setEnabled(i != 0);
            this.bahnsteige.get((Object)components[i].toString()).downbutton.setEnabled(i != this.middlepane.getComponentCount() - 1);
            ++i;
        }
        components = this.rightpane.getComponents();
        i = 0;
        while (i < this.rightpane.getComponentCount()) {
            this.bahnsteige.get((Object)components[i].toString()).upbutton.setEnabled(i != 0);
            this.bahnsteige.get((Object)components[i].toString()).downbutton.setEnabled(i != this.rightpane.getComponentCount() - 1);
            ++i;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlatformUI.this.setSize(PlatformUI.this.size.width / PlatformUI.this.columns_old * PlatformUI.this.columns, PlatformUI.this.size.height);
            }
        });
        this.pack();
        this.setDivider(this.headers[0].splitPane.getDividerLocation());
        this.save();
    }

    protected void initFromOptions() {
        if (!this.getMainUI().getOptions().hasPlatformDataOf(this.getMainUI().getOptions().convertName(this.mainUI.getConnection().getName()))) {
            System.out.println("neues stellwerk saved: " + this.getMainUI().getOptions().convertName(this.mainUI.getConnection().getName()));
            this.aufteilen();
            return;
        }
        TreeMap<Integer, String> original_map = new TreeMap<Integer, String>();
        HashMap<String, Integer> swapped_map = this.getMainUI().getOptions().getPlatformOptions().getLeftList();
        for (String platform_name : swapped_map.keySet()) {
            original_map.put(swapped_map.get(platform_name), platform_name);
        }
        for (Integer a : original_map.keySet()) {
            this.leftpane.add(this.bahnsteige.get(original_map.get(a)));
            this.bahnsteige.get(original_map.get(a)).setVisible(this.getMainUI().getOptions().getPlatformOptions().isPlatformVisible((String)original_map.get(a)));
            this.bahnsteige.get(original_map.get((Object)a)).column_owner = 1;
            this.bahnsteige.get(original_map.get((Object)a)).leftbutton.setEnabled(false);
            this.bahnsteige.get(original_map.get((Object)a)).rightbutton.setEnabled(this.columns > 1);
        }
        swapped_map = this.getMainUI().getOptions().getPlatformOptions().getMiddleList();
        original_map = new TreeMap();
        for (String platform_name : swapped_map.keySet()) {
            original_map.put(swapped_map.get(platform_name), platform_name);
        }
        for (Integer a : original_map.keySet()) {
            this.middlepane.add(this.bahnsteige.get(original_map.get(a)));
            this.bahnsteige.get(original_map.get(a)).setVisible(this.getMainUI().getOptions().getPlatformOptions().isPlatformVisible((String)original_map.get(a)));
            this.bahnsteige.get(original_map.get((Object)a)).column_owner = 2;
            this.bahnsteige.get(original_map.get((Object)a)).leftbutton.setEnabled(true);
            this.bahnsteige.get(original_map.get((Object)a)).rightbutton.setEnabled(this.columns > 2);
        }
        swapped_map = this.getMainUI().getOptions().getPlatformOptions().getRightList();
        original_map = new TreeMap();
        for (String platform_name : swapped_map.keySet()) {
            original_map.put(swapped_map.get(platform_name), platform_name);
        }
        for (Integer a : original_map.keySet()) {
            this.rightpane.add(this.bahnsteige.get(original_map.get(a)));
            this.bahnsteige.get(original_map.get(a)).setVisible(this.getMainUI().getOptions().getPlatformOptions().isPlatformVisible((String)original_map.get(a)));
            this.bahnsteige.get(original_map.get((Object)a)).column_owner = 3;
            this.bahnsteige.get(original_map.get((Object)a)).leftbutton.setEnabled(true);
            this.bahnsteige.get(original_map.get((Object)a)).rightbutton.setEnabled(false);
        }
        this.mainpane.remove(this.middlemainpane);
        this.mainpane.remove(this.rightmainpane);
        this.optionsbutton.setVisible(false);
        if (this.columns == 2 || this.columns == 3) {
            this.mainpane.add(this.middlemainpane);
            this.optionsbutton.setVisible(true);
            if (this.columns == 3) {
                this.mainpane.add(this.rightmainpane);
            }
        }
        Component[] components = this.leftpane.getComponents();
        int i = 0;
        while (i < this.leftpane.getComponentCount()) {
            this.bahnsteige.get((Object)components[i].toString()).upbutton.setEnabled(i != 0);
            this.bahnsteige.get((Object)components[i].toString()).downbutton.setEnabled(i != this.leftpane.getComponentCount() - 1);
            ++i;
        }
        components = this.middlepane.getComponents();
        i = 0;
        while (i < this.middlepane.getComponentCount()) {
            this.bahnsteige.get((Object)components[i].toString()).upbutton.setEnabled(i != 0);
            this.bahnsteige.get((Object)components[i].toString()).downbutton.setEnabled(i != this.middlepane.getComponentCount() - 1);
            ++i;
        }
        components = this.rightpane.getComponents();
        i = 0;
        while (i < this.rightpane.getComponentCount()) {
            this.bahnsteige.get((Object)components[i].toString()).upbutton.setEnabled(i != 0);
            this.bahnsteige.get((Object)components[i].toString()).downbutton.setEnabled(i != this.rightpane.getComponentCount() - 1);
            ++i;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlatformUI.this.setSize(PlatformUI.this.size.width / PlatformUI.this.columns_old * PlatformUI.this.columns, PlatformUI.this.size.height);
            }
        });
        this.pack();
        this.setDivider(this.headers[0].splitPane.getDividerLocation());
        this.save();
    }

    private void addinitTimer() {
        this.initTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlatformUI.this.checkInit();
            }
        });
        this.initTimer.setInitialDelay(500);
        this.initTimer.start();
    }

    protected void checkInit() {
        boolean result = true;
        for (PlatformTimeTable platform : this.bahnsteige.values()) {
            result &= platform.ready;
        }
        if (result) {
            this.initTimer.stop();
            System.out.println("Bahnsteig-Fenster: Einstellungen aus Registry geladen.");
            this.initFromOptions();
            new Blinker(this.mainUI.platform_button, Color.RED, true);
            this.mainUI.platform_button.setEnabled(true);
        }
    }

    private void addComponentListener() {
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (PlatformUI.this.docked) {
                    PlatformUI.this.mainUI.setSize(((PlatformUI)PlatformUI.this).mainUI.getSize().width, PlatformUI.this.getSize().height);
                }
                if (PlatformUI.this.docked) {
                    PlatformUI.this.setSize(PlatformUI.this.getSize().width, ((PlatformUI)PlatformUI.this).mainUI.getSize().height);
                }
                if (PlatformUI.this.docked) {
                    PlatformUI.this.mainUI.setLocation(new Point(PlatformUI.this.getLocation().x - ((PlatformUI)PlatformUI.this).mainUI.getSize().width, PlatformUI.this.getLocation().y));
                }
                PlatformUI.this.save();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                if (PlatformUI.this.docked) {
                    PlatformUI.this.mainUI.setSize(((PlatformUI)PlatformUI.this).mainUI.getSize().width, PlatformUI.this.getSize().height);
                }
                if (PlatformUI.this.docked) {
                    PlatformUI.this.setSize(PlatformUI.this.getSize().width, ((PlatformUI)PlatformUI.this).mainUI.getSize().height);
                }
                if (PlatformUI.this.docked) {
                    PlatformUI.this.mainUI.setLocation(new Point(PlatformUI.this.getLocation().x - ((PlatformUI)PlatformUI.this).mainUI.getSize().width, PlatformUI.this.getLocation().y));
                }
                if (PlatformUI.this.headers != null && ((PlatformUI)PlatformUI.this).headers[0].splitPane != null) {
                    PlatformUI.this.setDivider(((PlatformUI)PlatformUI.this).headers[0].splitPane.getDividerLocation());
                }
                PlatformUI.this.size = PlatformUI.this.getSize();
                PlatformUI.this.save();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                if (PlatformUI.this.docked) {
                    PlatformUI.this.mainUI.setSize(((PlatformUI)PlatformUI.this).mainUI.getSize().width, PlatformUI.this.getSize().height);
                }
                if (PlatformUI.this.docked) {
                    PlatformUI.this.setSize(PlatformUI.this.getSize().width, ((PlatformUI)PlatformUI.this).mainUI.getSize().height);
                }
                if (PlatformUI.this.docked) {
                    PlatformUI.this.mainUI.setLocation(new Point(PlatformUI.this.getLocation().x - ((PlatformUI)PlatformUI.this).mainUI.getSize().width, PlatformUI.this.getLocation().y));
                }
                PlatformUI.this.save();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent arg0) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(0) && Toolkit.getDefaultToolkit().isFrameStateSupported(1)) {
                    if (PlatformUI.this.docked) {
                        PlatformUI.this.mainUI.setExtendedState(PlatformUI.this.getExtendedState());
                    }
                    PlatformUI.this.save();
                }
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                if (!((PlatformUI)PlatformUI.this).mainUI.focustemp) {
                    boolean bl = PlatformUI.this.focustemp = !PlatformUI.this.focustemp;
                }
                if (PlatformUI.this.docked && PlatformUI.this.focustemp && !((PlatformUI)PlatformUI.this).mainUI.focustemp) {
                    PlatformUI.this.mainUI.requestFocus();
                }
                if (PlatformUI.this.docked && PlatformUI.this.focustemp && !((PlatformUI)PlatformUI.this).mainUI.focustemp) {
                    PlatformUI.this.requestFocus();
                }
                PlatformUI.this.save();
            }
        });
    }

    public MainUI getMainUI() {
        return this.mainUI;
    }

    public void setMainUI(MainUI mainUI) {
        this.mainUI = mainUI;
    }

    public void push(HashMap<Integer, Train> zuglist) {
        this.setZuglist(zuglist);
    }

    public HashMap<Integer, Train> getZuglist() {
        return this.zuglist;
    }

    public void setZuglist(HashMap<Integer, Train> zuglist) {
        this.zuglist = zuglist;
    }

    public TreeMap<String, PlatformTimeTable> getBahnsteige() {
        return this.bahnsteige;
    }

    public void setTrainArrived(int zid, String gleis) {
        try {
            this.bahnsteige.get(this.zuglist.get((Object)Integer.valueOf((int)zid)).tmpGleis).setTrainArrived(zid);
        }
        catch (Exception e) {
            System.out.println("zuglist==null -> " + (this.zuglist == null));
            System.out.println("zid==null -> " + (zid == 0));
            System.out.println(this.zuglist.get(zid) == null);
            System.out.println(this.bahnsteige.get(this.zuglist.get((Object)Integer.valueOf((int)zid)).tmpGleis) == null);
            e.printStackTrace();
        }
    }

    public synchronized void setBahnsteige(TreeMap<String, PlatformTimeTable> bahnsteige) {
        this.bahnsteige = bahnsteige;
        LinkedList<PlatformTimeTable> sortedlist = new LinkedList<PlatformTimeTable>();
        sortedlist.addAll(bahnsteige.values());
        Collections.sort(sortedlist);
        for (final PlatformTimeTable platform : sortedlist) {
            platform.setPlatformUI(this);
            final JCheckBox platform_menu = new JCheckBox(platform.platform_name, this.mainUI.getOptions().getPlatformOptions().isPlatformVisible(platform.platform_name));
            platform_menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent arg0) {
                    ((PlatformTimeTable)PlatformUI.this.bahnsteige.get(platform.platform_name)).setVisible(platform_menu.isSelected());
                }
            });
            this.bahnsteig_menu.add(platform_menu);
            platform_menu.setFocusPainted(false);
            this.leftpane.add(platform);
            platform.column_owner = 3;
            if (sortedlist.indexOf(platform) == sortedlist.size() - 1) continue;
            platform.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, Color.GRAY));
        }
        Component[] components = this.leftpane.getComponents();
        int i = 0;
        while (i < this.leftpane.getComponentCount()) {
            this.bahnsteige.get((Object)components[i].toString()).upbutton.setEnabled(i != 0);
            this.bahnsteige.get((Object)components[i].toString()).leftbutton.setEnabled(false);
            this.bahnsteige.get((Object)components[i].toString()).rightbutton.setEnabled(true);
            this.bahnsteige.get((Object)components[i].toString()).downbutton.setEnabled(i != this.leftpane.getComponentCount() - 1);
            ++i;
        }
        components = this.middlepane.getComponents();
        i = 0;
        while (i < this.middlepane.getComponentCount()) {
            this.bahnsteige.get((Object)components[i].toString()).upbutton.setEnabled(i != 0);
            this.bahnsteige.get((Object)components[i].toString()).leftbutton.setEnabled(true);
            this.bahnsteige.get((Object)components[i].toString()).rightbutton.setEnabled(true);
            this.bahnsteige.get((Object)components[i].toString()).downbutton.setEnabled(i != this.middlepane.getComponentCount() - 1);
            ++i;
        }
        components = this.rightpane.getComponents();
        i = 0;
        while (i < this.rightpane.getComponentCount()) {
            this.bahnsteige.get((Object)components[i].toString()).upbutton.setEnabled(i != 0);
            this.bahnsteige.get((Object)components[i].toString()).leftbutton.setEnabled(true);
            this.bahnsteige.get((Object)components[i].toString()).rightbutton.setEnabled(false);
            this.bahnsteige.get((Object)components[i].toString()).downbutton.setEnabled(i != this.rightpane.getComponentCount() - 1);
            ++i;
        }
        this.pack();
        this.save();
        this.control.setPlatform_timetable(bahnsteige);
    }

    public void setSizeAndPos(Dimension size, Point location) {
        location.x += size.width;
        int n = size.width = this.getSize().width == 0 ? 300 : this.getSize().width;
        if (this.docked) {
            this.setSize(size);
            this.setPreferredSize(size);
            this.setLocation(location);
            this.pack();
        }
    }

    public PlatformControl getControl() {
        return this.control;
    }

    public synchronized void setDivider(int dividerLocation) {
        if (this.bahnsteige != null) {
            for (PlatformTimeTable bahnsteig : this.bahnsteige.values()) {
                bahnsteig.setDividerLoc(dividerLocation);
            }
            PlatformUiHeader[] platformUiHeaderArray = this.headers;
            int n = this.headers.length;
            int n2 = 0;
            while (n2 < n) {
                PlatformUiHeader header = platformUiHeaderArray[n2];
                header.setDivider(dividerLocation);
                ++n2;
            }
        }
    }

    public void shiftLeft(final PlatformTimeTable platform) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (platform.column_owner == 2) {
                    platform.column_owner = 1;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PlatformUI.this.middlepane.remove(platform);
                            PlatformUI.this.leftpane.add(platform);
                            platform.leftbutton.setEnabled(false);
                            platform.rightbutton.setEnabled(true);
                            platform.upbutton.setEnabled(true);
                            platform.downbutton.setEnabled(false);
                            PlatformUI.this.mainpane.revalidate();
                            PlatformUI.this.mainpane.repaint();
                        }
                    });
                } else if (platform.column_owner == 3) {
                    platform.column_owner = 2;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PlatformUI.this.rightpane.remove(platform);
                            PlatformUI.this.middlepane.add(platform);
                            platform.leftbutton.setEnabled(true);
                            platform.rightbutton.setEnabled(true);
                            platform.upbutton.setEnabled(true);
                            platform.downbutton.setEnabled(false);
                            PlatformUI.this.mainpane.revalidate();
                            PlatformUI.this.mainpane.repaint();
                        }
                    });
                }
                PlatformUI.this.handle_buttons(PlatformUI.this.middlepane);
                PlatformUI.this.handle_buttons(PlatformUI.this.rightpane);
                PlatformUI.this.handle_buttons(PlatformUI.this.leftpane);
                PlatformUI.this.save();
            }
        });
    }

    public void shiftRight(final PlatformTimeTable platform) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (platform.column_owner == 1) {
                    platform.column_owner = 2;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PlatformUI.this.leftpane.remove(platform);
                            PlatformUI.this.middlepane.add(platform);
                            platform.leftbutton.setEnabled(true);
                            platform.rightbutton.setEnabled(PlatformUI.this.columns == 3);
                            PlatformUI.this.mainpane.revalidate();
                            PlatformUI.this.mainpane.repaint();
                        }
                    });
                } else if (platform.column_owner == 2) {
                    platform.column_owner = 3;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PlatformUI.this.middlepane.remove(platform);
                            PlatformUI.this.rightpane.add(platform);
                            platform.leftbutton.setEnabled(true);
                            platform.rightbutton.setEnabled(false);
                            PlatformUI.this.mainpane.revalidate();
                            PlatformUI.this.mainpane.repaint();
                        }
                    });
                }
                PlatformUI.this.handle_buttons(PlatformUI.this.middlepane);
                PlatformUI.this.handle_buttons(PlatformUI.this.rightpane);
                PlatformUI.this.handle_buttons(PlatformUI.this.leftpane);
                PlatformUI.this.save();
            }
        });
    }

    private void handle_buttons(final JPanel target_pane) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component[] components = target_pane.getComponents();
                boolean visible_found = false;
                int i = 0;
                while (i < target_pane.getComponentCount()) {
                    ((PlatformTimeTable)((PlatformUI)PlatformUI.this).bahnsteige.get((Object)components[i].toString())).upbutton.setEnabled(i != 0 && visible_found);
                    if (components[i].isVisible()) {
                        visible_found = true;
                    }
                    ++i;
                }
                visible_found = false;
                i = target_pane.getComponentCount() - 1;
                while (i > -1) {
                    ((PlatformTimeTable)((PlatformUI)PlatformUI.this).bahnsteige.get((Object)components[i].toString())).downbutton.setEnabled(i != target_pane.getComponentCount() - 1 && visible_found);
                    if (components[i].isVisible()) {
                        visible_found = true;
                    }
                    --i;
                }
            }
        });
    }

    public void shiftUp(final PlatformTimeTable platform) {
        final JPanel target_pane = platform.column_owner == 1 ? this.leftpane : (platform.column_owner == 2 ? this.middlepane : this.rightpane);
        Component[] components = target_pane.getComponents();
        int oldpos_tmp = 0;
        int i = 0;
        while (i < target_pane.getComponentCount()) {
            if (components[i].equals(platform)) {
                oldpos_tmp = i;
            }
            ++i;
        }
        final int oldpos = oldpos_tmp;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int newpos = oldpos - 1;
                boolean found = false;
                do {
                    try {
                        if (!target_pane.getComponents()[newpos].isVisible() && newpos != 0) {
                            --newpos;
                            continue;
                        }
                        found = true;
                    }
                    catch (Exception e) {
                        System.err.println("newpos: " + newpos + " - oldpos: " + oldpos + " - platform.column_owner: " + platform.column_owner);
                        e.printStackTrace();
                    }
                } while (!found && newpos != 0);
                target_pane.remove(platform);
                target_pane.add((Component)platform, newpos);
                PlatformUI.this.mainpane.revalidate();
                PlatformUI.this.mainpane.repaint();
                if (newpos == 0) {
                    platform.upbutton.setEnabled(false);
                }
                PlatformUI.this.handle_buttons(target_pane);
                PlatformUI.this.save();
            }
        });
    }

    public void shiftDown(final PlatformTimeTable platform) {
        final JPanel target_pane = platform.column_owner == 1 ? this.leftpane : (platform.column_owner == 2 ? this.middlepane : this.rightpane);
        Component[] components = target_pane.getComponents();
        int oldpos_tmp = 0;
        int i = 0;
        while (i < target_pane.getComponentCount()) {
            if (components[i].equals(platform)) {
                oldpos_tmp = i;
            }
            ++i;
        }
        final int oldpos = oldpos_tmp;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int newpos = oldpos + 1;
                boolean found = false;
                do {
                    if (!target_pane.getComponents()[newpos].isVisible() && newpos != target_pane.getComponentCount() - 1) {
                        ++newpos;
                        continue;
                    }
                    found = true;
                } while (!found && newpos != target_pane.getComponentCount());
                target_pane.remove(platform);
                target_pane.add((Component)platform, newpos);
                PlatformUI.this.mainpane.revalidate();
                PlatformUI.this.mainpane.repaint();
                PlatformUI.this.handle_buttons(target_pane);
                PlatformUI.this.save();
            }
        });
    }

    private void save() {
        PlatformTimeTable platform;
        Component platform_component;
        PlatformTimeTable platform2;
        Component platform_component2;
        if (!this.mainUI.platform_button.isEnabled()) {
            return;
        }
        HashMap<String, Integer> links_liste = new HashMap<String, Integer>();
        HashMap<String, Integer> mitte_liste = new HashMap<String, Integer>();
        HashMap<String, Integer> rechts_liste = new HashMap<String, Integer>();
        int tmp = 0;
        Component[] componentArray = this.leftpane.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            platform_component2 = componentArray[n2];
            platform2 = (PlatformTimeTable)platform_component2;
            links_liste.put(platform2.platform_name, tmp);
            ++tmp;
            ++n2;
        }
        tmp = 0;
        componentArray = this.middlepane.getComponents();
        n = componentArray.length;
        n2 = 0;
        while (n2 < n) {
            platform_component2 = componentArray[n2];
            platform2 = (PlatformTimeTable)platform_component2;
            mitte_liste.put(platform2.platform_name, tmp);
            ++tmp;
            ++n2;
        }
        tmp = 0;
        componentArray = this.rightpane.getComponents();
        n = componentArray.length;
        n2 = 0;
        while (n2 < n) {
            platform_component2 = componentArray[n2];
            platform2 = (PlatformTimeTable)platform_component2;
            rechts_liste.put(platform2.platform_name, tmp);
            ++tmp;
            ++n2;
        }
        HashMap<String, Boolean> links_visibles = new HashMap<String, Boolean>();
        HashMap<String, Boolean> mitte_visibles = new HashMap<String, Boolean>();
        HashMap<String, Boolean> rechts_visibles = new HashMap<String, Boolean>();
        Component[] componentArray2 = this.leftpane.getComponents();
        int n3 = componentArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            platform_component = componentArray2[n4];
            platform = (PlatformTimeTable)platform_component;
            links_visibles.put(platform.platform_name, platform_component.isVisible());
            ++n4;
        }
        componentArray2 = this.middlepane.getComponents();
        n3 = componentArray2.length;
        n4 = 0;
        while (n4 < n3) {
            platform_component = componentArray2[n4];
            platform = (PlatformTimeTable)platform_component;
            mitte_visibles.put(platform.platform_name, platform_component.isVisible());
            ++n4;
        }
        componentArray2 = this.rightpane.getComponents();
        n3 = componentArray2.length;
        n4 = 0;
        while (n4 < n3) {
            platform_component = componentArray2[n4];
            platform = (PlatformTimeTable)platform_component;
            rechts_visibles.put(platform.platform_name, platform_component.isVisible());
            ++n4;
        }
        this.getMainUI().getOptions().savePlatformOptions(new PlatformOptions(this.name_registry, this.docked, this.ansicht_one.isSelected(), this.ansicht_two.isSelected(), this.ansicht_three.isSelected(), links_liste, mitte_liste, rechts_liste, links_visibles, mitte_visibles, rechts_visibles, false));
    }
}

