/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.util.HashMap;
import java.util.Iterator;
import plugin.DecryptedTimeTable;
import plugin.DecryptedTimeTableSingle;
import plugin.PlatformControl;
import plugin.PlatformTimeTable;
import plugin.Train;

public class PlatformTrain {
    private Train train;
    private PlatformControl control;
    private int hashchanger = 0;
    private int hash;
    protected HashMap<String, PlatformTimeTable> registered_tables = new HashMap();
    private DecryptedTimeTable oldplan;
    private static final boolean DEBUG = false;

    protected Train getTrain() {
        return this.train;
    }

    protected PlatformTrain(Train t, PlatformControl control, PlatformTimeTable table) {
        this.train = t;
        this.setControl(control);
        this.registered_tables.put(table.platform_name, table);
        this.oldplan = t.plan;
    }

    protected synchronized void register(PlatformTimeTable table) {
        this.registered_tables.put(table.platform_name, table);
    }

    protected synchronized void deregister(PlatformTimeTable table) {
        this.deregister(table, false);
    }

    protected boolean wasDurchfahrt(String gleis) {
        return this.oldplan.getStopEntry(gleis).wirdDurchfahren();
    }

    protected synchronized void deregister(PlatformTimeTable table, boolean from_iterator) {
        if (!from_iterator) {
            this.registered_tables.remove(table.platform_name);
            for (DecryptedTimeTableSingle plan : this.getTrain().plan) {
                if (!this.control.register(plan.gleis, this)) continue;
                this.register(this.control.getPlatform_timetable().get(plan.gleis));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        boolean register_again = false;
        HashMap<String, PlatformTimeTable> hashMap = this.registered_tables;
        synchronized (hashMap) {
            Iterator<String> platforms = this.registered_tables.keySet().iterator();
            while (platforms.hasNext()) {
                String platform = platforms.next();
                if (this.registered_tables.get(platform) == null) {
                    System.err.println("null");
                }
                if (this.registered_tables.get(platform).hasElement(this) && !this.getTrain().plan.hasStopEntry(this.registered_tables.get((Object)platform).platform_name)) {
                    this.control.getPlatform_timetable().get(this.registered_tables.get((Object)platform).platform_name).deregister(this.getTrain().zid);
                    platforms.remove();
                    register_again = true;
                } else if (this.getTrain().plan.hasStopEntry(this.registered_tables.get((Object)platform).platform_name) && !this.control.getPlatform_timetable().get(this.registered_tables.get((Object)platform).platform_name).hasElement(this)) {
                    this.control.getPlatform_timetable().get(this.registered_tables.get((Object)platform).platform_name).register(this);
                    this.register(this.registered_tables.get(platform));
                }
                if (this.registered_tables.get(platform) == null) continue;
                this.registered_tables.get(platform).rebuild_entries();
            }
        }
        if (register_again) {
            for (DecryptedTimeTableSingle plan : this.getTrain().plan) {
                if (!this.control.register(plan.gleis, this)) continue;
                this.register(this.control.getPlatform_timetable().get(plan.gleis));
            }
        }
    }

    public void setTrain(Train train) {
        this.train = train;
    }

    public PlatformControl getControl() {
        return this.control;
    }

    public void setControl(PlatformControl control) {
        this.control = control;
    }

    public int hashCode() {
        this.hashchanger = this.hash != this.train.hashCode() ? 1 : 0;
        this.hash = this.train.hashCode();
        return this.hash + this.hashchanger;
    }
}

