/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import layout.TableLayout;
import plugin.Blinker;
import plugin.DecryptedTimeTableSingle;
import plugin.OptionsManager;
import plugin.PlatformComparator;
import plugin.PlatformTrain;
import plugin.PlatformUI;

public class PlatformTimeTable
extends JPanel
implements Comparable<PlatformTimeTable> {
    private static final long serialVersionUID = 1L;
    protected String platform_name;
    private HashMap<Integer, PlatformTrain> timetable = new HashMap();
    private String name = "";
    private int number;
    protected boolean ready = false;
    protected int column_owner = 1;
    private final double[][] trainSize = new double[][]{{0.5, -1.0}, {-1.0}};
    private final double[][] timeSize = new double[][]{{-3.0, -1.0}, {-1.0}};
    private JPanel timetable_pane;
    private JLabel name_label;
    private JPanel nextstop_pane;
    private JLabel nextstop_namelabel;
    private JLabel nextstop_timelabel;
    private JLabel currentstop_namelabel;
    private JLabel currentstop_timelabel;
    private JSplitPane splitPane;
    private JPanel currentstop_pane;
    private JPanel nextstop_timepanel;
    private JLabel nextstop_timedescription;
    private JLabel currentstop_timedescription;
    private JPanel currentstop_timepanel;
    private OptionsManager options;
    private JPanel laststop_pane;
    private JPanel laststop_timepanel;
    private JLabel laststop_timedescription;
    private JLabel laststop_namelabel;
    private JLabel laststop_timelabel;
    private Timer laststop_timer;
    private int laststop_timer_count;
    private JPanel mainpane;
    protected JButton rightbutton;
    protected JButton leftbutton;
    private CardLayout mainpane_cards;
    protected PlatformUI platformUI;
    protected JButton upbutton;
    protected JButton downbutton;

    public PlatformTimeTable(String name, OptionsManager options) {
        try {
            this.options = options;
            this.platform_name = name;
            this.convertNameAndNumber();
            this.setLayout(new GridLayout(1, 1));
            this.name_label = new JLabel(this.platform_name, 0);
            this.name_label.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 1, Color.GRAY));
            this.name_label.setFont(new Font("Sans Serif", 1, 12));
            this.name_label.setMinimumSize(new Dimension(80, 50));
            this.name_label.setMaximumSize(new Dimension(2000, 50));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlatformTimeTable.this.mainpane = new JPanel();
                    JPanel jPanel = PlatformTimeTable.this.mainpane;
                    CardLayout cardLayout = new CardLayout();
                    PlatformTimeTable.this.mainpane_cards = cardLayout;
                    jPanel.setLayout(cardLayout);
                    PlatformTimeTable.this.timetable_pane = new JPanel();
                    PlatformTimeTable.this.timetable_pane.setLayout(new GridLayout(3, 1));
                    PlatformTimeTable.this.currentstop_namelabel = new JLabel("", new ImageIcon(PlatformTimeTable.this.options.isAnimationEnabled() ? "./src/plugin/images/platform_now.gif" : "./src/plugin/images/platform_now.png"), 2);
                    PlatformTimeTable.this.currentstop_namelabel.setDisabledIcon(new ImageIcon("./src/plugin/images/platform_now_disabled.png"));
                    PlatformTimeTable.this.currentstop_namelabel.setEnabled(false);
                    PlatformTimeTable.this.currentstop_timelabel = new JLabel("", 4);
                    PlatformTimeTable.this.nextstop_namelabel = new JLabel("", new ImageIcon("./src/plugin/images/platform_next.png"), 2);
                    PlatformTimeTable.this.nextstop_namelabel.setDisabledIcon(new ImageIcon("./src/plugin/images/platform_next_disabled.png"));
                    PlatformTimeTable.this.nextstop_namelabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
                    PlatformTimeTable.this.nextstop_timelabel = new JLabel("", 4);
                    PlatformTimeTable.this.nextstop_timedescription = new JLabel(new ImageIcon("./src/plugin/images/platform_icon_an.png"), 2);
                    PlatformTimeTable.this.nextstop_timedescription.setVisible(false);
                    PlatformTimeTable.this.nextstop_timedescription.setFont(new Font("Monospaced", 1, 12));
                    PlatformTimeTable.this.nextstop_timedescription.setOpaque(false);
                    PlatformTimeTable.this.nextstop_timepanel = new JPanel((LayoutManager)new TableLayout(PlatformTimeTable.this.timeSize));
                    PlatformTimeTable.this.nextstop_timepanel.add((Component)PlatformTimeTable.this.nextstop_timedescription, "0,0");
                    PlatformTimeTable.this.nextstop_timepanel.add((Component)PlatformTimeTable.this.nextstop_timelabel, "1,0");
                    PlatformTimeTable.this.nextstop_timepanel.setOpaque(false);
                    PlatformTimeTable.this.nextstop_pane = new JPanel();
                    PlatformTimeTable.this.nextstop_pane.setLayout((LayoutManager)new TableLayout(PlatformTimeTable.this.trainSize));
                    PlatformTimeTable.this.nextstop_pane.add((Component)PlatformTimeTable.this.nextstop_namelabel, "0,0");
                    PlatformTimeTable.this.nextstop_pane.add((Component)PlatformTimeTable.this.nextstop_timepanel, "1,0");
                    PlatformTimeTable.this.nextstop_pane.setBackground(Color.LIGHT_GRAY);
                    PlatformTimeTable.this.nextstop_pane.setOpaque(true);
                    PlatformTimeTable.this.nextstop_namelabel.setFont(new Font("Monospaced", 1, 12));
                    PlatformTimeTable.this.nextstop_timelabel.setFont(new Font("Monospaced", 1, 12));
                    PlatformTimeTable.this.mainpane.add((Component)PlatformTimeTable.this.timetable_pane, "TIMETABLE");
                    JPanel shiftpane = new JPanel();
                    shiftpane.setLayout(new GridLayout(1, 3));
                    PlatformTimeTable.this.leftbutton = new JButton(new ImageIcon("./src/plugin/images/shift_left.png"));
                    PlatformTimeTable.this.rightbutton = new JButton(new ImageIcon("./src/plugin/images/shift_right.png"));
                    PlatformTimeTable.this.upbutton = new JButton(new ImageIcon("./src/plugin/images/shift_up.png"));
                    PlatformTimeTable.this.downbutton = new JButton(new ImageIcon("./src/plugin/images/shift_down.png"));
                    PlatformTimeTable.this.leftbutton.setDisabledIcon(new ImageIcon("./src/plugin/images/shift_left_disabled.png"));
                    PlatformTimeTable.this.rightbutton.setDisabledIcon(new ImageIcon("./src/plugin/images/shift_right_disabled.png"));
                    PlatformTimeTable.this.upbutton.setDisabledIcon(new ImageIcon("./src/plugin/images/shift_up_disabled.png"));
                    PlatformTimeTable.this.downbutton.setDisabledIcon(new ImageIcon("./src/plugin/images/shift_down_disabled.png"));
                    PlatformTimeTable.this.rightbutton.setFocusPainted(false);
                    PlatformTimeTable.this.leftbutton.setFocusPainted(false);
                    PlatformTimeTable.this.upbutton.setFocusPainted(false);
                    PlatformTimeTable.this.downbutton.setFocusPainted(false);
                    PlatformTimeTable.this.rightbutton.setEnabled(false);
                    PlatformTimeTable.this.leftbutton.setEnabled(false);
                    PlatformTimeTable.this.upbutton.setEnabled(false);
                    PlatformTimeTable.this.downbutton.setEnabled(true);
                    PlatformTimeTable.this.rightbutton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            if ((this).PlatformTimeTable.this.platformUI != null) {
                                (this).PlatformTimeTable.this.platformUI.shiftRight(PlatformTimeTable.this);
                            }
                        }
                    });
                    PlatformTimeTable.this.leftbutton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            if ((this).PlatformTimeTable.this.platformUI != null) {
                                (this).PlatformTimeTable.this.platformUI.shiftLeft(PlatformTimeTable.this);
                            }
                        }
                    });
                    PlatformTimeTable.this.upbutton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            if ((this).PlatformTimeTable.this.platformUI != null) {
                                (this).PlatformTimeTable.this.platformUI.shiftUp(PlatformTimeTable.this);
                            }
                        }
                    });
                    PlatformTimeTable.this.downbutton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            if ((this).PlatformTimeTable.this.platformUI != null) {
                                (this).PlatformTimeTable.this.platformUI.shiftDown(PlatformTimeTable.this);
                            }
                        }
                    });
                    JPanel up_down_pane = new JPanel();
                    up_down_pane.setLayout(new GridLayout(2, 1));
                    up_down_pane.add(PlatformTimeTable.this.upbutton);
                    up_down_pane.add(PlatformTimeTable.this.downbutton);
                    shiftpane.add(PlatformTimeTable.this.leftbutton);
                    shiftpane.add(up_down_pane);
                    shiftpane.add(PlatformTimeTable.this.rightbutton);
                    PlatformTimeTable.this.mainpane.add((Component)shiftpane, "CONFIG");
                    PlatformTimeTable.this.splitPane = new JSplitPane(1, PlatformTimeTable.this.name_label, PlatformTimeTable.this.mainpane);
                    PlatformTimeTable.this.add(PlatformTimeTable.this.splitPane);
                    PlatformTimeTable.this.currentstop_pane = new JPanel();
                    PlatformTimeTable.this.currentstop_pane.setLayout((LayoutManager)new TableLayout(PlatformTimeTable.this.trainSize));
                    PlatformTimeTable.this.currentstop_pane.add((Component)PlatformTimeTable.this.currentstop_namelabel, "0,0");
                    PlatformTimeTable.this.currentstop_pane.setBackground(Color.LIGHT_GRAY);
                    PlatformTimeTable.this.currentstop_pane.setOpaque(true);
                    PlatformTimeTable.this.currentstop_namelabel.setFont(new Font("Monospaced", 1, 12));
                    PlatformTimeTable.this.currentstop_timelabel.setFont(new Font("Monospaced", 1, 12));
                    PlatformTimeTable.this.currentstop_timedescription = new JLabel(new ImageIcon("./src/plugin/images/platform_icon_ab.png"), 2);
                    PlatformTimeTable.this.currentstop_timedescription.setVisible(false);
                    PlatformTimeTable.this.currentstop_timedescription.setFont(new Font("Monospaced", 1, 12));
                    PlatformTimeTable.this.currentstop_timedescription.setOpaque(false);
                    PlatformTimeTable.this.currentstop_timepanel = new JPanel((LayoutManager)new TableLayout(PlatformTimeTable.this.timeSize));
                    PlatformTimeTable.this.currentstop_timepanel.add((Component)PlatformTimeTable.this.currentstop_timedescription, "0,0");
                    PlatformTimeTable.this.currentstop_timepanel.add((Component)PlatformTimeTable.this.currentstop_timelabel, "1,0");
                    PlatformTimeTable.this.currentstop_timepanel.setOpaque(false);
                    PlatformTimeTable.this.currentstop_pane.add((Component)PlatformTimeTable.this.currentstop_timepanel, "1,0");
                    PlatformTimeTable.this.laststop_namelabel = new JLabel("", new ImageIcon("./src/plugin/images/platform_last.png"), 2);
                    PlatformTimeTable.this.laststop_namelabel.setEnabled(false);
                    PlatformTimeTable.this.laststop_timelabel = new JLabel("", 4);
                    PlatformTimeTable.this.laststop_namelabel.setFont(new Font("Monospaced", 1, 12));
                    PlatformTimeTable.this.laststop_timelabel.setFont(new Font("Monospaced", 1, 12));
                    PlatformTimeTable.this.laststop_timedescription = new JLabel(new ImageIcon("./src/plugin/images/platform_icon_vor.png"), 2);
                    PlatformTimeTable.this.laststop_timedescription.setVisible(false);
                    PlatformTimeTable.this.laststop_timedescription.setFont(new Font("Monospaced", 1, 12));
                    PlatformTimeTable.this.laststop_timedescription.setOpaque(false);
                    PlatformTimeTable.this.laststop_timepanel = new JPanel((LayoutManager)new TableLayout(PlatformTimeTable.this.timeSize));
                    PlatformTimeTable.this.laststop_timepanel.add((Component)PlatformTimeTable.this.laststop_timedescription, "0,0");
                    PlatformTimeTable.this.laststop_timepanel.add((Component)PlatformTimeTable.this.laststop_timelabel, "1,0");
                    PlatformTimeTable.this.laststop_timepanel.setOpaque(false);
                    PlatformTimeTable.this.laststop_namelabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
                    PlatformTimeTable.this.laststop_pane = new JPanel();
                    PlatformTimeTable.this.laststop_pane.setLayout((LayoutManager)new TableLayout(PlatformTimeTable.this.trainSize));
                    PlatformTimeTable.this.laststop_pane.add((Component)PlatformTimeTable.this.laststop_namelabel, "0,0");
                    PlatformTimeTable.this.laststop_pane.setBackground(Color.LIGHT_GRAY);
                    PlatformTimeTable.this.laststop_pane.setOpaque(true);
                    PlatformTimeTable.this.laststop_pane.add((Component)PlatformTimeTable.this.laststop_timepanel, "1,0");
                    PlatformTimeTable.this.laststop_pane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
                    PlatformTimeTable.this.currentstop_pane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
                    PlatformTimeTable.this.timetable_pane.add(PlatformTimeTable.this.laststop_pane);
                    PlatformTimeTable.this.timetable_pane.add(PlatformTimeTable.this.currentstop_pane);
                    PlatformTimeTable.this.timetable_pane.add(PlatformTimeTable.this.nextstop_pane);
                    PlatformTimeTable.this.laststop_namelabel.setForeground(Color.GRAY);
                    PlatformTimeTable.this.laststop_timelabel.setForeground(Color.GRAY);
                    PlatformTimeTable.this.laststop_timedescription.setForeground(Color.GRAY);
                    PlatformTimeTable.this.currentstop_namelabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
                    PlatformTimeTable.this.splitPane.setEnabled(false);
                    PlatformTimeTable.this.rebuild_entries();
                    PlatformTimeTable.this.ready = true;
                }
            });
            this.setMinimumSize(new Dimension(10, 10));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setPlatformUI(PlatformUI platformUI) {
        this.platformUI = platformUI;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.splitPane != null) {
            this.splitPane.setBackground(color);
        }
    }

    @Override
    public void setOpaque(boolean b) {
        if (this.splitPane != null) {
            this.splitPane.setOpaque(b);
        } else {
            super.setOpaque(b);
        }
    }

    protected void blink(JPanel nextstop_pane2) {
        new Blinker(nextstop_pane2);
    }

    @Override
    public String toString() {
        return this.platform_name;
    }

    protected boolean hasElement(PlatformTrain train) {
        return this.timetable.containsValue(train);
    }

    public boolean hasElement(int zid) {
        return this.timetable.containsKey(zid);
    }

    public synchronized void register(PlatformTrain train) {
        if (!this.timetable.containsValue(train)) {
            this.timetable.put(train.getTrain().zid, train);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlatformTimeTable.this.rebuild_entries();
                }
            });
        }
    }

    protected void rebuild_entries() {
        LinkedList<PlatformTrain> trains = new LinkedList<PlatformTrain>();
        trains.addAll(this.timetable.values());
        for (PlatformTrain platformTrain : this.timetable.values()) {
            if (platformTrain.getTrain().gleis != null) continue;
            trains.remove(platformTrain);
        }
        if (trains.size() > 0) {
            String[] oldlabel = new String[]{this.laststop_namelabel.getText(), this.currentstop_namelabel.getText(), this.nextstop_namelabel.getText()};
            Collections.sort(trains, new PlatformComparator(this.platform_name));
            int minuten = Integer.MIN_VALUE;
            boolean has_train_holding = false;
            if (((PlatformTrain)trains.getFirst()).getTrain().amgleis && ((DecryptedTimeTableSingle)((PlatformTrain)trains.getFirst()).getTrain().plan.getFirst()).gleis.equals(this.platform_name) || trains.size() > 1 && ((PlatformTrain)trains.get((int)1)).getTrain().amgleis && ((DecryptedTimeTableSingle)((PlatformTrain)trains.get((int)1)).getTrain().plan.getFirst()).gleis.equals(this.platform_name)) {
                has_train_holding = true;
                PlatformTrain holding_train = ((PlatformTrain)trains.getFirst()).getTrain().amgleis && ((DecryptedTimeTableSingle)((PlatformTrain)trains.getFirst()).getTrain().plan.getFirst()).gleis.equals(this.platform_name) ? (PlatformTrain)trains.getFirst() : (PlatformTrain)trains.get(1);
                PlatformTrain next_train = ((PlatformTrain)trains.getFirst()).getTrain().amgleis && ((DecryptedTimeTableSingle)((PlatformTrain)trains.getFirst()).getTrain().plan.getFirst()).gleis.equals(this.platform_name) ? (PlatformTrain)trains.get(1) : (PlatformTrain)trains.getFirst();
                minuten = holding_train.getTrain().getUi().getMainUI().getClock().getMinutesToTime(holding_train.getTrain().plan.getStopEntry((String)this.platform_name).ab / 1000L);
                this.currentstop_namelabel.setText(this.options.mainUI.schweiz_mode ? this.options.mainUI.schweiz_xml.getNameOf(holding_train.getTrain().name) : holding_train.getTrain().name);
                this.currentstop_namelabel.setEnabled(true);
                this.currentstop_timelabel.setText(--minuten <= 0 ? (minuten == Integer.MIN_VALUE ? "" : "jetzt") : String.valueOf(minuten) + " Min.");
                this.currentstop_timedescription.setVisible(true);
                if (trains.size() > 1) {
                    minuten = next_train.getTrain().getUi().getMainUI().getClock().getMinutesToTime(next_train.getTrain().plan.getStopEntry((String)this.platform_name).an / 1000L);
                    this.nextstop_namelabel.setText(this.options.mainUI.schweiz_mode ? this.options.mainUI.schweiz_xml.getNameOf(next_train.getTrain().name) : next_train.getTrain().name);
                    this.nextstop_timedescription.setIcon(next_train.getTrain().plan.getStopEntry(this.platform_name).getSymbol(true));
                    this.nextstop_timelabel.setText((minuten += next_train.getTrain().verspaetung) <= 0 ? (minuten == Integer.MIN_VALUE ? "" : "jetzt") : String.valueOf(minuten) + " Min.");
                    this.nextstop_timedescription.setVisible(true);
                } else {
                    this.nextstop_namelabel.setText("");
                    this.nextstop_timelabel.setText("");
                    this.nextstop_pane.setToolTipText("");
                    this.nextstop_namelabel.setEnabled(false);
                    this.nextstop_timedescription.setVisible(false);
                    this.nextstop_pane.setBackground(Color.LIGHT_GRAY);
                    this.nextstop_pane.setOpaque(true);
                }
            } else {
                minuten = ((PlatformTrain)trains.getFirst()).getTrain().getUi().getMainUI().getClock().getMinutesToTime(((PlatformTrain)trains.getFirst()).getTrain().plan.getStopEntry((String)this.platform_name).an / 1000L);
                minuten += ((PlatformTrain)trains.getFirst()).getTrain().verspaetung;
                this.nextstop_namelabel.setText(this.options.mainUI.schweiz_mode ? this.options.mainUI.schweiz_xml.getNameOf(((PlatformTrain)trains.getFirst()).getTrain().name) : ((PlatformTrain)trains.getFirst()).getTrain().name);
                ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
                ToolTipManager.sharedInstance().setInitialDelay(0);
                this.nextstop_pane.setToolTipText("<html><B><U>" + (this.options.mainUI.schweiz_mode ? this.options.mainUI.schweiz_xml.getNameOf(((PlatformTrain)trains.getFirst()).getTrain().name) : ((PlatformTrain)trains.getFirst()).getTrain().name) + "</U></B><br>Von: " + ((PlatformTrain)trains.getFirst()).getTrain().von + "<br>Nach: " + ((PlatformTrain)trains.getFirst()).getTrain().nach + "<br><br><U>Info zu Gleis " + this.platform_name + ":</U><br> " + ((PlatformTrain)trains.getFirst()).getTrain().plan.getStopEntry(this.platform_name).getDescriptionString() + "</html>");
                this.nextstop_timedescription.setIcon(((PlatformTrain)trains.getFirst()).getTrain().plan.getStopEntry(this.platform_name).getSymbol(true));
                this.nextstop_timelabel.setText(minuten <= 0 ? (minuten == Integer.MIN_VALUE ? "" : "jetzt") : minuten + " Min.");
                this.nextstop_timedescription.setVisible(true);
            }
            if (!has_train_holding) {
                if (this.currentstop_timedescription.isVisible()) {
                    this.laststop_namelabel.setText(this.currentstop_namelabel.getText());
                    this.laststop_namelabel.setEnabled(true);
                    this.laststop_timelabel.setText("0s");
                    this.laststop_timedescription.setVisible(true);
                    this.laststop_pane.setBackground(Color.WHITE);
                    this.laststop_pane.setOpaque(true);
                    if (this.laststop_timer != null) {
                        this.laststop_timer.stop();
                        this.laststop_timer_count = 0;
                    }
                    this.laststop_timer = new Timer(1000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            if (PlatformTimeTable.this.laststop_timer_count < 60) {
                                PlatformTimeTable platformTimeTable = PlatformTimeTable.this;
                                platformTimeTable.laststop_timer_count = platformTimeTable.laststop_timer_count + 1;
                                PlatformTimeTable.this.laststop_timelabel.setText(String.valueOf(PlatformTimeTable.this.laststop_timer_count) + "s");
                            } else {
                                PlatformTimeTable.this.laststop_timer.stop();
                                PlatformTimeTable.this.laststop_timer_count = 0;
                                PlatformTimeTable.this.laststop_namelabel.setText("");
                                PlatformTimeTable.this.laststop_namelabel.setEnabled(false);
                                PlatformTimeTable.this.laststop_namelabel.setEnabled(false);
                                PlatformTimeTable.this.laststop_pane.setBackground(Color.LIGHT_GRAY);
                                PlatformTimeTable.this.laststop_timelabel.setText("");
                                PlatformTimeTable.this.laststop_timedescription.setVisible(false);
                            }
                        }
                    });
                    this.laststop_timer.start();
                }
                this.currentstop_timedescription.setVisible(false);
                this.currentstop_timelabel.setText("");
                this.currentstop_namelabel.setText("");
                this.currentstop_namelabel.setEnabled(false);
                this.currentstop_pane.setBackground(Color.LIGHT_GRAY);
                this.currentstop_pane.setOpaque(true);
            }
            this.nextstop_namelabel.setEnabled(minuten != Integer.MIN_VALUE && !this.nextstop_namelabel.getText().equals(""));
            if (!oldlabel[2].equals(this.nextstop_namelabel.getText()) && !this.nextstop_namelabel.getText().equals("")) {
                this.nextstop_pane.setBackground(Color.WHITE);
                this.blink(this.nextstop_pane);
            }
            if (!oldlabel[1].equals(this.currentstop_namelabel.getText()) && !this.currentstop_namelabel.getText().equals("")) {
                this.currentstop_pane.setBackground(Color.WHITE);
                this.blink(this.currentstop_pane);
            }
        } else {
            this.nextstop_namelabel.setText("");
            this.nextstop_timelabel.setText("");
            this.nextstop_pane.setToolTipText("");
            this.nextstop_namelabel.setEnabled(false);
            this.nextstop_pane.setBackground(Color.LIGHT_GRAY);
            this.nextstop_pane.setOpaque(true);
            this.nextstop_timedescription.setVisible(false);
        }
        this.nextstop_timelabel.setForeground(this.nextstop_timelabel.getText().equals("jetzt") ? Color.RED : Color.BLACK);
        this.currentstop_timelabel.setForeground(this.currentstop_timelabel.getText().equals("jetzt") ? Color.RED : Color.BLACK);
    }

    public synchronized void deregister(int zid) {
        this.timetable.remove(zid);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlatformTimeTable.this.rebuild_entries();
            }
        });
    }

    @Override
    public int compareTo(PlatformTimeTable other) {
        if (this.name.equals(other.name)) {
            return this.number == 0 ? this.platform_name.compareToIgnoreCase(other.platform_name) : this.number - other.number;
        }
        return this.platform_name.compareToIgnoreCase(other.platform_name);
    }

    /*
     * Unable to fully structure code
     */
    private void convertNameAndNumber() {
        block5: {
            ret = new StringBuilder(this.platform_name);
            while (ret.length() > 0 && !Character.isDigit(ret.charAt(0))) {
                this.name = String.valueOf(this.name) + ret.charAt(0);
                ret.deleteCharAt(0);
            }
            try {
                this.number = Integer.parseInt(ret.toString());
                break block5;
            }
            catch (NumberFormatException e) {
                ret2 = new StringBuilder(this.platform_name);
                tmpNumber = "";
                ** while (ret2.length() > 0)
            }
lbl-1000:
            // 1 sources

            {
                if (!Character.isDigit(ret2.charAt(0))) {
                    ret2.deleteCharAt(0);
                    continue;
                }
                tmpNumber = String.valueOf(tmpNumber) + ret2.charAt(0);
                ret2.deleteCharAt(0);
                continue;
            }
lbl22:
            // 1 sources

            this.number = tmpNumber.equals("") != false ? 0 : Integer.parseInt(tmpNumber);
        }
    }

    public void setDividerLoc(int dividerLocation) {
        this.splitPane.setDividerLocation(dividerLocation);
    }

    public void edit(boolean edit_mode) {
        this.mainpane_cards.show(this.mainpane, edit_mode ? "CONFIG" : "TIMETABLE");
    }

    public void setTrainArrived(int zid) {
        if (!this.timetable.get(zid).wasDurchfahrt(this.platform_name)) {
            return;
        }
        this.laststop_namelabel.setText(this.timetable.get((Object)Integer.valueOf((int)zid)).getTrain().name);
        this.laststop_namelabel.setEnabled(true);
        this.laststop_timelabel.setText("0s");
        this.laststop_timedescription.setVisible(true);
        this.laststop_pane.setBackground(Color.WHITE);
        this.laststop_pane.setOpaque(true);
        if (this.laststop_timer != null) {
            this.laststop_timer.stop();
            this.laststop_timer_count = 0;
        }
        this.laststop_timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (PlatformTimeTable.this.laststop_timer_count < 60) {
                    PlatformTimeTable platformTimeTable = PlatformTimeTable.this;
                    platformTimeTable.laststop_timer_count = platformTimeTable.laststop_timer_count + 1;
                    PlatformTimeTable.this.laststop_timelabel.setText(String.valueOf(PlatformTimeTable.this.laststop_timer_count) + "s");
                } else {
                    PlatformTimeTable.this.laststop_timer.stop();
                    PlatformTimeTable.this.laststop_timer_count = 0;
                    PlatformTimeTable.this.laststop_namelabel.setText("");
                    PlatformTimeTable.this.laststop_namelabel.setEnabled(false);
                    PlatformTimeTable.this.laststop_namelabel.setEnabled(false);
                    PlatformTimeTable.this.laststop_pane.setBackground(Color.LIGHT_GRAY);
                    PlatformTimeTable.this.laststop_timelabel.setText("");
                    PlatformTimeTable.this.laststop_timedescription.setVisible(false);
                }
            }
        });
        this.laststop_timer.start();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlatformTimeTable.this.rebuild_entries();
            }
        });
    }
}

