/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import plugin.DecryptedTimeTableSingle;
import plugin.PlatformTimeTable;
import plugin.PlatformTrain;
import plugin.PlatformUI;
import plugin.Train;

public class PlatformControl {
    private PlatformUI platformUI;
    private int lasthash = 0;
    private HashMap<Integer, PlatformTrain> saved_zuglist = new HashMap();
    private TreeMap<String, PlatformTimeTable> platform_timetable;
    protected static final boolean DEBUG = false;

    protected PlatformControl(PlatformUI platformUI) {
        this.setPlatformUI(platformUI);
        this.setPlatform_timetable(platformUI.getBahnsteige());
    }

    protected PlatformUI getMainUI() {
        return this.platformUI;
    }

    private void setPlatformUI(PlatformUI platformUI) {
        this.platformUI = platformUI;
    }

    public void push(HashMap<Integer, Train> zuglist) {
        try {
            if (zuglist.hashCode() != this.lasthash) {
                for (Integer zid : zuglist.keySet()) {
                    Train zug = zuglist.get(zid);
                    PlatformTrain other = this.saved_zuglist.get(zid);
                    if (!this.saved_zuglist.containsKey(zid)) {
                        for (DecryptedTimeTableSingle einzelplan : zuglist.get((Object)zid).plan) {
                            this.register(einzelplan.gleis, zuglist.get(zid));
                        }
                        continue;
                    }
                    if (zug.hashCode() == other.hashCode()) continue;
                    other.update();
                }
                Iterator<Integer> it = this.saved_zuglist.keySet().iterator();
                while (it.hasNext()) {
                    int zid = it.next();
                    if (zuglist.containsKey(zid)) continue;
                    for (PlatformTimeTable platform : this.platform_timetable.values()) {
                        platform.deregister(zid);
                    }
                    it.remove();
                }
            }
            this.lasthash = zuglist.hashCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean register(String gleis, PlatformTrain train) {
        boolean result = false;
        if (!this.platform_timetable.get(gleis).hasElement(train.getTrain().zid)) {
            this.platform_timetable.get(gleis).register(train);
            result = true;
        }
        return result;
    }

    protected void register(String gleis, Train train) {
        PlatformTrain temptrain;
        if (!this.saved_zuglist.containsKey(train.zid)) {
            temptrain = new PlatformTrain(train, this, this.platform_timetable.get(gleis));
            this.saved_zuglist.put(train.zid, temptrain);
        } else {
            temptrain = this.saved_zuglist.get(train.zid);
        }
        if (!this.platform_timetable.get(gleis).hasElement(train.zid)) {
            this.platform_timetable.get(gleis).register(temptrain);
            temptrain.register(this.platform_timetable.get(gleis));
        }
    }

    public TreeMap<String, PlatformTimeTable> getPlatform_timetable() {
        return this.platform_timetable;
    }

    public void setPlatform_timetable(TreeMap<String, PlatformTimeTable> platform_timetable) {
        this.platform_timetable = platform_timetable;
    }
}

