/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import layout.TableLayout;
import plugin.ButtonPane;
import plugin.OptionsManager;

public class OptionsTrainSingle
extends JPanel
implements Comparable<OptionsTrainSingle> {
    private OptionsManager options;
    private JCheckBox vorrang_checkbox;
    private Boolean active;
    private String k\u00fcrzel;
    private JCheckBox ausblenden_checkbox;
    private double[][] tbSize = new double[][]{{-1.0, -2.0, -2.0, -1.0}, {-1.0}};
    private static final long serialVersionUID = 1L;

    public OptionsTrainSingle(String k\u00fcrzel, Boolean active, OptionsManager options) {
        this.options = options;
        this.k\u00fcrzel = k\u00fcrzel;
        this.active = active;
        this.setLayout((LayoutManager)new TableLayout(this.tbSize));
        this.vorrang_checkbox = new JCheckBox(new ImageIcon("./src/plugin/images/zug_vorrang.png"), (boolean)active);
        this.vorrang_checkbox.setFont(new Font("Dialog", 1, 10));
        this.vorrang_checkbox.setSelectedIcon(new ImageIcon("./src/plugin/images/zug_vorrang_selected.png"));
        this.vorrang_checkbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OptionsTrainSingle.this.options.setTrainEnabled(OptionsTrainSingle.this.k\u00fcrzel, OptionsTrainSingle.this.vorrang_checkbox.isSelected());
            }
        });
        this.ausblenden_checkbox = new JCheckBox(new ImageIcon("./src/plugin/images/zug_ausblenden.png"), options.isTrainInvisible(k\u00fcrzel));
        this.ausblenden_checkbox.setSelectedIcon(new ImageIcon("./src/plugin/images/zug_ausblenden_selected.png"));
        this.ausblenden_checkbox.setFont(new Font("Dialog", 1, 10));
        this.ausblenden_checkbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OptionsTrainSingle.this.options.setTrainInvisible(OptionsTrainSingle.this.k\u00fcrzel, OptionsTrainSingle.this.ausblenden_checkbox.isSelected());
            }
        });
        this.setPreferredSize(new Dimension(90, 18));
        this.setMaximumSize(new Dimension(500, 18));
        this.add((Component)new JLabel(k\u00fcrzel), "0,0");
        this.add((Component)this.vorrang_checkbox, "1,0");
        this.add((Component)this.ausblenden_checkbox, "2,0");
        this.add((Component)this.getColorChooser(), "3,0");
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 5));
    }

    private JComboBox getColorChooser() {
        Integer[] labels = new Integer[ButtonPane.MarkerColors.values().length];
        ButtonPane.MarkerColors[] markerColorsArray = ButtonPane.MarkerColors.values();
        int n = markerColorsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ButtonPane.MarkerColors color = markerColorsArray[n2];
            labels[color.ordinal()] = new Integer(color.ordinal());
            ++n2;
        }
        JComboBox<Integer> box = new JComboBox<Integer>(labels);
        ComboBoxRenderer renderer = new ComboBoxRenderer(box, this.k\u00fcrzel);
        box.setRenderer(renderer);
        box.setMaximumRowCount(ButtonPane.MarkerColors.values().length);
        box.setForeground(Color.GRAY);
        box.setBackground(ButtonPane.MarkerColors.values()[box.getSelectedIndex()].getBackground());
        box.setSelectedIndex(this.options.getTrainColor(this.k\u00fcrzel));
        return box;
    }

    @Override
    public int compareTo(OptionsTrainSingle other) {
        return this.k\u00fcrzel.equals(other.k\u00fcrzel) ? 0 : (this.active != other.active ? other.active.compareTo(this.active) : this.k\u00fcrzel.compareTo(other.k\u00fcrzel));
    }

    protected class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        private int oldvalue;

        public ComboBoxRenderer(final JComboBox box, String k\u00fcrzel) {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
            this.oldvalue = 0;
            box.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    if (ComboBoxRenderer.this.oldvalue != box.getSelectedIndex()) {
                        ComboBoxRenderer.this.oldvalue = box.getSelectedIndex();
                        box.setBackground(ButtonPane.MarkerColors.values()[box.getSelectedIndex()].getBackground());
                        OptionsTrainSingle.this.options.setTrainColor(OptionsTrainSingle.this.k\u00fcrzel, box.getSelectedIndex());
                    }
                }
            });
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int selectedIndex = (Integer)value;
            list.setSelectionBackground(ButtonPane.MarkerColors.values()[selectedIndex].getBackground());
            this.setText(!ButtonPane.MarkerColors.values()[selectedIndex].getColorName().equals("keine") ? "    " : "farblos");
            this.setBackground(ButtonPane.MarkerColors.values()[selectedIndex].getBackground());
            this.setForeground(ButtonPane.MarkerColors.values()[selectedIndex].getBackground());
            this.setFont(list.getFont());
            return this;
        }
    }
}

