/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import plugin.MainUI;
import plugin.OptionsPaneContent;
import plugin.PlatformOptions;

public class OptionsManager {
    private boolean animations;
    private final Preferences prefs_root = Preferences.userRoot().node("/de/armar/sts/analyse");
    private Preferences prefs_platform;
    private final Preferences prefs_shorts = Preferences.userRoot().node("/de/armar/sts/analyse/shorts");
    private final Preferences prefs_shorts_invisible = Preferences.userRoot().node("/de/armar/sts/analyse/shorts_invisible");
    private final Preferences prefs_shorts_color = Preferences.userRoot().node("/de/armar/sts/analyse/shorts_color");
    private int showMinutes;
    private int showStops;
    private int size_x;
    private int size_y;
    private boolean sound;
    private HashMap<String, Boolean> zuggattungen_vorrang = new HashMap();
    private HashMap<String, Boolean> zuggattungen_ausblenden = new HashMap();
    private HashMap<String, Integer> zuggattungen_color = new HashMap();
    private OptionsPaneContent optionspane;
    protected MainUI mainUI;
    private boolean alarmStandardEnabled;
    private int popupVersionDone;
    private boolean verspaetung_mode_hard;
    private PlatformOptions pOptions_bak = null;

    protected OptionsManager(MainUI mainUI) {
        this.mainUI = mainUI;
        this.writeDefaults();
        this.readOptions();
    }

    protected void setOptionsPane(OptionsPaneContent optionspane) {
        this.optionspane = optionspane;
    }

    protected int getMaxMinutes() {
        return this.showMinutes;
    }

    protected void setMaxMinutes(int max) {
        this.showMinutes = max;
        this.prefs_root.putInt("show_only_minutes", max);
    }

    protected int getMaxStops() {
        return this.showStops;
    }

    protected void setMaxStops(int max) {
        this.showStops = max;
        this.prefs_root.putInt("show_stops_maximum", max);
        if (this.mainUI != null && this.mainUI.getConnection() != null) {
            this.mainUI.getConnection().setNewMaxStops(max);
        }
    }

    public int getPopupVersion() {
        return this.popupVersionDone;
    }

    protected Dimension getSizeConfig() {
        return new Dimension(this.size_x, this.size_y);
    }

    protected void setSizeConfig(Dimension size) {
        this.size_x = size.width;
        this.size_y = size.height;
        this.prefs_root.putInt("size_x", this.size_x);
        this.prefs_root.putInt("size_y", this.size_y);
    }

    protected HashMap<String, Boolean> getZugVorrangConfig() {
        return this.zuggattungen_vorrang;
    }

    protected HashMap<String, Integer> getZugColorConfig() {
        return this.zuggattungen_color;
    }

    protected HashMap<String, Boolean> getZugAusblendenConfig() {
        return this.zuggattungen_ausblenden;
    }

    protected void setZugVorrangConfig(HashMap<String, Boolean> zugConfig) {
        this.zuggattungen_vorrang = zugConfig;
        for (String gattung : zugConfig.keySet()) {
            this.prefs_shorts.putBoolean(gattung, zugConfig.get(gattung));
        }
    }

    protected void setZugColorConfig(HashMap<String, Integer> zugConfig) {
        this.zuggattungen_color = zugConfig;
        for (String gattung : zugConfig.keySet()) {
            this.prefs_shorts_color.putInt(gattung, zugConfig.get(gattung));
        }
    }

    protected void setZugAusblendenConfig(HashMap<String, Boolean> zugConfig) {
        this.zuggattungen_ausblenden = zugConfig;
        for (String gattung : zugConfig.keySet()) {
            this.prefs_shorts_invisible.putBoolean(gattung, zugConfig.get(gattung));
        }
    }

    protected boolean isAnimationEnabled() {
        return this.animations;
    }

    protected boolean isSoundEnabled() {
        return this.sound;
    }

    protected void setSoundEnabled(boolean e) {
        this.sound = e;
        this.prefs_root.putBoolean("sound_enabled", e);
    }

    protected void setPopupVersion(int ver) {
        this.popupVersionDone = ver;
        this.prefs_root.putInt("popup_done", ver);
    }

    protected void setAnimationEnabled(boolean e) {
        this.animations = e;
        this.prefs_root.putBoolean("animations_enabled", e);
        if (this.mainUI != null && this.mainUI.getConnection() != null) {
            this.mainUI.getConnection().setAnimationsEnabled(e);
        }
    }

    public boolean isAlarmEnabled() {
        return this.alarmStandardEnabled;
    }

    public void setAlarmEnabled(boolean e) {
        this.alarmStandardEnabled = e;
        this.prefs_root.putBoolean("alarm_enabled_standard", e);
        if (this.mainUI != null && this.mainUI.getConnection() != null) {
            this.mainUI.getConnection().setAlarmEnabled(e);
        }
    }

    protected void sethardModeEnabled(boolean selected) {
        this.verspaetung_mode_hard = !selected;
        this.prefs_root.putBoolean("delay_analysis_mode", this.verspaetung_mode_hard);
        if (this.mainUI != null && this.mainUI.getConnection() != null) {
            this.mainUI.getConnection().setVerspaetungsModeHard(this.verspaetung_mode_hard);
        }
    }

    protected boolean isTrainEnabled(String t) {
        return this.zuggattungen_vorrang.containsKey(t) ? this.zuggattungen_vorrang.get(t) : false;
    }

    protected int getTrainColor(String t) {
        return this.zuggattungen_color.containsKey(t) ? this.zuggattungen_color.get(t) : 0;
    }

    public boolean isTrainInvisible(String t) {
        return this.zuggattungen_ausblenden.containsKey(t) ? this.zuggattungen_ausblenden.get(t) : false;
    }

    protected void setTrainEnabled(String k\u00fcrzel, boolean selected) {
        if (!this.isInteger(k\u00fcrzel)) {
            if (!this.zuggattungen_vorrang.containsKey(k\u00fcrzel)) {
                this.zuggattungen_vorrang.put(k\u00fcrzel, selected);
                if (this.optionspane != null) {
                    this.optionspane.refresh();
                }
            } else {
                this.zuggattungen_vorrang.remove(k\u00fcrzel);
                this.zuggattungen_vorrang.put(k\u00fcrzel, selected);
            }
            this.prefs_shorts.putBoolean(k\u00fcrzel.toLowerCase(), selected);
        }
    }

    private boolean isInteger(String k\u00fcrzel) {
        boolean result = false;
        try {
            Integer.parseInt(k\u00fcrzel);
            result = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    protected void setTrainColor(String k\u00fcrzel, int color_number) {
        if (!this.zuggattungen_color.containsKey(k\u00fcrzel)) {
            this.zuggattungen_color.put(k\u00fcrzel, color_number);
            if (this.optionspane != null) {
                this.optionspane.refresh();
            }
        } else {
            this.zuggattungen_color.remove(k\u00fcrzel);
            this.zuggattungen_color.put(k\u00fcrzel, color_number);
        }
        this.prefs_shorts_color.putInt(k\u00fcrzel.toLowerCase(), color_number);
        this.mainUI.getConnection().setTrainColor(k\u00fcrzel, color_number);
    }

    protected void setTrainInvisible(String k\u00fcrzel, boolean selected) {
        if (!this.zuggattungen_ausblenden.containsKey(k\u00fcrzel)) {
            this.zuggattungen_ausblenden.put(k\u00fcrzel, selected);
            if (this.optionspane != null) {
                this.optionspane.refresh();
            }
        } else {
            this.zuggattungen_ausblenden.remove(k\u00fcrzel);
            this.zuggattungen_ausblenden.put(k\u00fcrzel, selected);
        }
        this.prefs_shorts_invisible.putBoolean(k\u00fcrzel.toLowerCase(), selected);
    }

    private void writeDefaults() {
        if (this.isNotInitialized()) {
            String gattung;
            this.prefs_root.putInt("size_x", 700);
            this.prefs_root.putInt("size_y", 300);
            this.prefs_root.putBoolean("sound_enabled", false);
            this.prefs_root.putBoolean("animations_enabled", true);
            this.prefs_root.putBoolean("alarm_enabled_standard", false);
            this.prefs_root.putInt("show_only_minutes", 15);
            this.prefs_root.putInt("show_stops_maximum", 3);
            String[] standard_true = new String[]{"ice", "ic", "ec", "ice-t", "ice-a", "ice-w"};
            String[] standard_false = new String[]{"re", "rb", "akn", "s", "nob", "me", "hlb", "via"};
            String[] stringArray = standard_true;
            int n = standard_true.length;
            int n2 = 0;
            while (n2 < n) {
                gattung = stringArray[n2];
                this.prefs_shorts.putBoolean(gattung, true);
                this.prefs_shorts_invisible.putBoolean(gattung, false);
                this.prefs_shorts_color.putInt(gattung, 0);
                ++n2;
            }
            stringArray = standard_false;
            n = standard_false.length;
            n2 = 0;
            while (n2 < n) {
                gattung = stringArray[n2];
                this.prefs_shorts.putBoolean(gattung, false);
                this.prefs_shorts_invisible.putBoolean(gattung, false);
                this.prefs_shorts_color.putInt(gattung, 0);
                ++n2;
            }
        }
    }

    private boolean isNotInitialized() {
        boolean result = true;
        try {
            result = this.prefs_root.keys().length == 0;
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void readOptions() {
        try {
            String key;
            String[] stringArray = this.prefs_shorts.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                key = stringArray[n2];
                this.zuggattungen_vorrang.put(key.toUpperCase(), this.prefs_shorts.getBoolean(key, false));
                ++n2;
            }
            stringArray = this.prefs_shorts_invisible.keys();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                key = stringArray[n2];
                this.zuggattungen_ausblenden.put(key.toUpperCase(), this.prefs_shorts_invisible.getBoolean(key, false));
                ++n2;
            }
            stringArray = this.prefs_shorts_color.keys();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                key = stringArray[n2];
                this.zuggattungen_color.put(key.toUpperCase(), this.prefs_shorts_color.getInt(key, 0));
                ++n2;
            }
            this.sound = this.prefs_root.getBoolean("sound_enabled", false);
            this.animations = this.prefs_root.getBoolean("animations_enabled", true);
            this.showMinutes = this.prefs_root.getInt("show_only_minutes", 15);
            this.verspaetung_mode_hard = this.prefs_root.getBoolean("delay_analysis_mode", true);
            this.showStops = this.prefs_root.getInt("show_stops_maximum", 3);
            this.size_x = this.prefs_root.getInt("size_x", 700);
            this.size_y = this.prefs_root.getInt("size_y", 300);
            this.alarmStandardEnabled = this.prefs_root.getBoolean("alarm_enabled_standard", false);
            this.popupVersionDone = this.prefs_root.getInt("popup_done", 503);
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    protected boolean hasTrain(String string) {
        return this.zuggattungen_vorrang.containsKey(string);
    }

    protected int getEingetroffenSek() {
        return 60;
    }

    public boolean isHardModeEnabled() {
        return this.verspaetung_mode_hard;
    }

    public void savePlatformOptions(PlatformOptions pOptions) {
        if (this.pOptions_bak == null || !this.pOptions_bak.equals(pOptions)) {
            this.pOptions_bak = pOptions;
            this.prefs_platform.putInt("var_mode", pOptions.getMode());
            HashMap<String, Integer> leftlist = pOptions.getLeftList();
            HashMap<String, Integer> middlelist = pOptions.getMiddleList();
            HashMap<String, Integer> rightlist = pOptions.getRightList();
            try {
                this.prefs_platform.node("vars_left").removeNode();
                this.prefs_platform.node("vars_middle").removeNode();
                this.prefs_platform.node("vars_right").removeNode();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
            for (String platform_name : leftlist.keySet()) {
                this.prefs_platform.node("vars_left").node(platform_name).putInt("pos", leftlist.get(platform_name));
                this.prefs_platform.node("vars_left").node(platform_name).putBoolean("visible", pOptions.isPlatformVisible(platform_name));
            }
            for (String platform_name : middlelist.keySet()) {
                this.prefs_platform.node("vars_middle").node(platform_name).putInt("pos", middlelist.get(platform_name));
                this.prefs_platform.node("vars_middle").node(platform_name).putBoolean("visible", pOptions.isPlatformVisible(platform_name));
            }
            for (String platform_name : rightlist.keySet()) {
                this.prefs_platform.node("vars_right").node(platform_name).putInt("pos", rightlist.get(platform_name));
                this.prefs_platform.node("vars_right").node(platform_name).putBoolean("visible", pOptions.isPlatformVisible(platform_name));
            }
        }
    }

    public PlatformOptions getPlatformOptions() {
        return this.pOptions_bak == null ? this.loadOptions(this.convertName(this.mainUI.getConnection().getName())) : this.pOptions_bak;
    }

    private PlatformOptions loadOptions(String platformName) {
        if (this.prefs_platform == null) {
            this.prefs_platform = Preferences.userRoot().node("/de/armar/sts/analyse/platforms/" + platformName);
        }
        return new PlatformOptions(platformName, true, this.prefs_platform.getInt("var_mode", 1) == 1, this.prefs_platform.getInt("var_mode", 1) == 2, this.prefs_platform.getInt("var_mode", 1) == 3, this.getPlatformListOf("vars_left"), this.getPlatformListOf("vars_middle"), this.getPlatformListOf("vars_right"), this.getPlatformVisibleListOf("vars_left"), this.getPlatformVisibleListOf("vars_middle"), this.getPlatformVisibleListOf("vars_right"), true);
    }

    private HashMap<String, Integer> getPlatformListOf(String pos) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        try {
            String[] stringArray = this.prefs_platform.node(pos).childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String platform_name = stringArray[n2];
                result.put(platform_name, this.prefs_platform.node(pos).node(platform_name).getInt("pos", -1));
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    private HashMap<String, Boolean> getPlatformVisibleListOf(String pos) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        try {
            String[] stringArray = this.prefs_platform.node(pos).childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String platform_name = stringArray[n2];
                result.put(platform_name, this.prefs_platform.node(pos).node(platform_name).getBoolean("visible", true));
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String convertName(String name) {
        String result = name.replaceAll("[ [^\\w\\d\\-\u00e4\u00fc\u00f6\u00c4\u00dc\u00d6&\\._]]", "_");
        result = result.replaceAll("[\u00e4]", "ae");
        result = result.replaceAll("[\u00fc]", "ue");
        result = result.replaceAll("[\u00f6]", "oe");
        result = result.replaceAll("[\u00d6]", "Oe");
        result = result.replaceAll("[\u00c4]", "Ae");
        result = result.replaceAll("[\u00dc]", "Ue");
        result = result.replaceAll("[&]", "und");
        result = result.replaceAll("[.]", "");
        return result.toLowerCase();
    }

    public boolean hasPlatformDataOf(String name) {
        boolean result = false;
        try {
            result = this.prefs_platform.nodeExists("");
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return result;
    }
}

