/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowStateListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import layout.TableLayout;
import plugin.Analysis;
import plugin.Clock;
import plugin.ConnectionManager;
import plugin.ConnectionWindow;
import plugin.OptionsManager;
import plugin.PlatformUI;
import plugin.TabbedPluginPane;
import plugin.TrainAllPane;
import plugin.XMLHandler;

public class MainUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    protected int build = 625;
    private String build_text = "";
    public static final boolean DEBUG = false;
    public static final boolean GRID_ENABLED = false;
    private Image appicon = Toolkit.getDefaultToolkit().createImage("./src/plugin/images/train_icon.png");
    private JMenu bstMenu;
    private Clock clock;
    protected boolean connected;
    private ConnectionManager connection;
    private ConnectionWindow connectionwindow;
    private Timer connectTimer;
    protected int eigeneVerspaetungen = 0;
    protected int eigeneVerspaetungenFix = 0;
    private TabbedPluginPane t;
    private JLabel verspLabel;
    private JLabel verspFixLabel;
    protected boolean focustemp = false;
    protected PlatformUI platformUI = null;
    private final double[][] lastlineSize = new double[][]{{-1.0, -3.0, -3.0, -1.0}, {-1.0}};
    protected boolean workerBusy = false;
    private JButton updateButton;
    private JPanel lastline;
    private JPanel lastline_buttons;
    private OptionsManager options;
    private JPanel clockpane;
    private Timer updatecheckTimer;
    protected int onlineversion = 0;
    protected JButton platform_button;
    protected XMLHandler schweiz_xml;
    private String anlagen_name;
    protected boolean schweiz_mode = false;
    private boolean schweiz_mode_asked = false;
    private JPanel versp_pane;
    private CardLayout versp_cards;

    public static void main(String[] args) {
        System.err.println("Plugin gestarted mit Java " + System.getProperty("java.runtime.version") + " " + System.getProperty("os.arch"));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainUI();
            }
        });
    }

    protected MainUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.options = new OptionsManager(this);
        this.setIconImage(this.appicon);
        this.setTitle("STS Plugin: Analyse");
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        JLabel l = new JLabel("");
        l.setHorizontalTextPosition(4);
        p.add((Component)l, "East");
        this.t = new TabbedPluginPane(this);
        this.connection = new ConnectionManager(this.bstMenu, this.t);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainUI.this.connect();
            }
        });
        this.connectionwindow = null;
        if (!this.connected) {
            this.connectionwindow = new ConnectionWindow();
            this.addConnectTimer();
        }
        this.add((Component)this.t, "Center");
        this.verspLabel = new JLabel("(Leicht) Meine Versp\u00e4tungen: " + this.getVerspaetungenString(), 4);
        this.verspLabel.setFont(new Font("Courier", 1, 12));
        this.verspFixLabel = new JLabel("(Normal) Meine Versp\u00e4tungen: " + this.getVerspaetungenString(), 4);
        this.verspFixLabel.setFont(new Font("Courier", 1, 12));
        this.lastline = new JPanel();
        this.lastline.setLayout((LayoutManager)new TableLayout(this.lastlineSize));
        this.clockpane = new JPanel();
        this.clockpane.setLayout(new GridLayout(1, 1));
        this.clock = this.connection.createClock();
        this.lastline.add((Component)this.clockpane, "0,0");
        this.versp_pane = new JPanel();
        this.versp_cards = new CardLayout();
        this.versp_pane.setLayout(this.versp_cards);
        this.versp_pane.add((Component)this.verspLabel, "NORMAL");
        this.versp_pane.add((Component)this.verspFixLabel, "HART");
        this.versp_cards.show(this.versp_pane, this.getOptions().isHardModeEnabled() ? "HART" : "NORMAL");
        this.lastline.add((Component)this.versp_pane, "3,0");
        this.verspLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.verspFixLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.lastline_buttons = new JPanel();
        this.lastline_buttons.setLayout(new BoxLayout(this.lastline_buttons, 2));
        this.lastline_buttons.add(Box.createHorizontalGlue());
        this.lastline_buttons.add(this.get_PN_Button());
        this.lastline_buttons.add(Box.createHorizontalGlue());
        this.lastline.add((Component)this.lastline_buttons, "1,0");
        this.platform_button = new JButton("Bahnsteig-Fenster");
        this.platform_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.platformUI.setVisible(!MainUI.this.platformUI.isVisible());
            }
        });
        this.platform_button.setFocusPainted(false);
        this.platform_button.setFont(new Font("Dialog", 1, 10));
        this.platform_button.setEnabled(false);
        this.lastline.add((Component)this.platform_button, "2,0");
        this.add((Component)this.lastline, "Last");
        this.initComponents();
        if (this.connected) {
            this.setVisible(true);
            this.setSize(this.getSize().width + 3, this.getSize().height + 3);
            this.pack();
            this.platformUI = new PlatformUI(this);
            this.addComponentListener();
        }
        this.addUpdatecheckTimer();
    }

    protected void setSizeAndPos(Dimension size, Point location) {
        location.x += size.width;
        size.width = this.getSize().width == 0 ? 300 : this.getSize().width;
        this.setPreferredSize(size);
        this.setSize(size);
        this.setLocation(location);
        this.pack();
    }

    private void addComponentListener() {
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (MainUI.this.platformUI.docked) {
                    MainUI.this.platformUI.setSizeAndPos(MainUI.this.getSize(), MainUI.this.getLocation());
                }
            }

            @Override
            public void componentResized(ComponentEvent e) {
                if (MainUI.this.platformUI.docked) {
                    MainUI.this.platformUI.setSize(MainUI.this.platformUI.getSize().width, MainUI.this.getSize().height);
                }
                if (MainUI.this.platformUI.docked) {
                    MainUI.this.platformUI.setLocation(new Point(MainUI.this.getLocation().x + MainUI.this.getSize().width, MainUI.this.platformUI.getLocation().y));
                }
                MainUI.this.getOptions().setSizeConfig(MainUI.this.getSize());
                if (MainUI.this.platformUI.docked) {
                    MainUI.this.platformUI.setSizeAndPos(MainUI.this.getSize(), MainUI.this.getLocation());
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                if (MainUI.this.platformUI.docked) {
                    MainUI.this.platformUI.setSizeAndPos(MainUI.this.getSize(), MainUI.this.getLocation());
                }
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent arg0) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(0) && Toolkit.getDefaultToolkit().isFrameStateSupported(1) && MainUI.this.platformUI.docked) {
                    MainUI.this.platformUI.setExtendedState(MainUI.this.getExtendedState());
                }
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                if (!MainUI.this.platformUI.focustemp) {
                    boolean bl = MainUI.this.focustemp = !MainUI.this.focustemp;
                }
                if (MainUI.this.platformUI.docked && MainUI.this.focustemp && !MainUI.this.platformUI.focustemp) {
                    MainUI.this.platformUI.requestFocus();
                }
                if (MainUI.this.platformUI.docked && MainUI.this.focustemp && !MainUI.this.platformUI.focustemp) {
                    MainUI.this.requestFocus();
                }
            }
        });
    }

    private void addConnectTimer() {
        this.connectTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!MainUI.this.connected && !MainUI.this.workerBusy) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainUI.this.connectionwindow.waitForSim();
                            MainUI.this.connect();
                        }
                    });
                } else if (MainUI.this.connected) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (MainUI.this.connectionwindow != null) {
                                MainUI.this.connectionwindow.dispose();
                            }
                            MainUI.this.setSize((this).MainUI.this.getSize().width + 3, (this).MainUI.this.getSize().height + 3);
                            MainUI.this.clock = MainUI.this.connection.createClock();
                            MainUI.this.clockpane.removeAll();
                            MainUI.this.clockpane.add(MainUI.this.clock);
                            MainUI.this.clockpane.revalidate();
                            MainUI.this.clockpane.repaint();
                            MainUI.this.pack();
                            MainUI.this.setVisible(true);
                            (this).MainUI.this.platformUI = new PlatformUI(MainUI.this);
                            MainUI.this.getConnection().setPlatform_ui((this).MainUI.this.platformUI);
                            MainUI.this.addComponentListener();
                            MainUI.this.connectTimer.stop();
                            MainUI.this.connectTimer = null;
                            (this).MainUI.this.schweiz_xml = new XMLHandler(true);
                        }
                    });
                }
            }
        });
        this.connectTimer.setInitialDelay(100);
        this.connectTimer.start();
    }

    private void addUpdatecheckTimer() {
        this.updatecheckTimer = new Timer(1200000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new XMLHandler(MainUI.this).convertFromUpdateXML();
                    }
                });
            }
        });
        this.updatecheckTimer.setInitialDelay(2000);
        this.updatecheckTimer.start();
    }

    protected void connect() {
        SwingWorker<Boolean, Boolean> worker = new SwingWorker<Boolean, Boolean>(){

            @Override
            protected Boolean doInBackground() {
                MainUI.this.workerBusy = true;
                boolean result = false;
                try {
                    MainUI.this.connection.connect("localhost");
                    result = true;
                }
                catch (IOException ex) {
                    System.out.println("Verbindungsfehler: Sim nicht erreichbar");
                }
                return result;
            }

            @Override
            protected void done() {
                try {
                    MainUI.this.connected = (Boolean)this.get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                MainUI.this.workerBusy = false;
            }
        };
        worker.execute();
    }

    protected Clock getClock() {
        return this.clock;
    }

    protected ConnectionManager getConnection() {
        return this.connection;
    }

    private String getVerspaetungenString() {
        return String.valueOf(this.stunden(this.eigeneVerspaetungen)) + ":" + this.minuten(this.eigeneVerspaetungen);
    }

    private String getVerspaetungenFixString() {
        return String.valueOf(this.stunden(this.eigeneVerspaetungenFix)) + ":" + this.minuten(this.eigeneVerspaetungenFix);
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent _) {
                MainUI.this.getConnection().close();
            }
        });
        this.setLocationByPlatform(true);
        this.setMinimumSize(new Dimension(700, 300));
        this.setPreferredSize(this.getOptions().getSizeConfig());
        this.setSize(this.getSize().width + 1, this.getSize().height);
        this.pack();
    }

    protected void exit() {
        new Analysis(this, this.t.getAllpanel().getArchive());
        this.platformUI.dispose();
        this.dispose();
    }

    protected void meldeVerspaetung() {
        ++this.eigeneVerspaetungen;
        ++this.eigeneVerspaetungenFix;
        this.verspLabel.setText("(Leicht) Meine Versp\u00e4tungen: " + this.getVerspaetungenString());
        this.verspFixLabel.setText("(Normal) Meine Versp\u00e4tungen: " + this.getVerspaetungenFixString());
    }

    protected void korrigiereVerspaetung(int plusminus) {
        this.eigeneVerspaetungen += plusminus;
        if (this.eigeneVerspaetungen < 0) {
            this.eigeneVerspaetungen = 0;
        }
        this.verspLabel.setText("(Leicht) Meine Versp\u00e4tungen: " + this.getVerspaetungenString());
    }

    protected String minuten(int zeit) {
        String tmp = "" + zeit % 60;
        if (("" + zeit % 60).length() == 1) {
            tmp = "0" + tmp;
        }
        return tmp;
    }

    protected void setStellwerk(String name) {
        DecimalFormat df = new DecimalFormat("0000");
        this.setTitle("STS Analyse (Stellwerk: " + name + ") - Plugin Build " + df.format(this.build) + (this.build_text.length() > 0 ? " (" + this.build_text + ")" : ""));
        this.anlagen_name = name;
        if (this.schweiz_xml != null) {
            this.checkSwitzerland();
        }
        this.connection.updateOptionsTrainlist();
    }

    private void checkSwitzerland() {
        if (!this.schweiz_mode_asked && this.schweiz_xml.istAnlageInSchweiz(this.anlagen_name)) {
            this.schweiz_mode_asked = true;
            boolean bl = this.schweiz_mode = JOptionPane.showConfirmDialog(this, "Schweizer Stellwerk erkannt.\r\nFehlende Zugk\u00fcrzel automatisch hinzuf\u00fcgen?  ", "Schweizer Stellwerk", 0, 3, new ImageIcon("./src/plugin/images/wappen_schweiz.jpg")) == 0;
            if (this.schweiz_mode) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainUI.this.connection.parseAllTrainNames();
                        MainUI.this.connection.updateOptionsTrainlist();
                    }
                });
            }
        }
    }

    protected void setWarning(int status) {
        this.t.setWarning(status);
    }

    protected String stunden(int zeit) {
        String tmp = "" + zeit / 60;
        if (("" + zeit / 60).length() == 1) {
            tmp = "0" + tmp;
        }
        return tmp;
    }

    protected TrainAllPane getAllList() {
        return this.t.getAllpanel();
    }

    protected void setUpdateInfos(String version) {
        this.onlineversion = Integer.parseInt(version);
        if (Integer.parseInt(version) > this.build) {
            this.addUpdateButton();
        }
        if (this.options.getPopupVersion() < Integer.parseInt(version)) {
            this.t.getChangelog().showNewPopup(this, version);
            this.options.setPopupVersion(Integer.parseInt(version));
        }
    }

    private void addUpdateButton() {
        this.updateButton = new JButton("Update verf\u00fcgbar!");
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Desktop.isDesktopSupported()) {
                    Desktop desk = Desktop.getDesktop();
                    try {
                        desk.browse(new URI("http://sts.armar.de"));
                    }
                    catch (IOException e1) {
                        System.err.println("Konnte http://sts.armar.de nicht \u00f6ffnen!");
                    }
                    catch (URISyntaxException e1) {
                        System.err.println("Konnte http://sts.armar.de nicht \u00f6ffnen!");
                    }
                }
            }
        });
        this.updateButton.setOpaque(false);
        this.updateButton.setForeground(new Color(190, 0, 0));
        this.updateButton.setMaximumSize(new Dimension(200, 200));
        this.updateButton.setFont(new Font("Dialog", 1, 12));
        this.updateButton.setFocusPainted(false);
        this.lastline_buttons.removeAll();
        this.lastline_buttons.add(Box.createHorizontalGlue());
        this.lastline_buttons.add((Component)this.updateButton, 1);
        this.lastline_buttons.add(Box.createHorizontalGlue());
        this.lastline.revalidate();
        this.lastline.repaint();
    }

    private Component get_PN_Button() {
        JButton pnButton = new JButton("Feedback an duncyo");
        pnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Desktop.isDesktopSupported()) {
                    Desktop desk = Desktop.getDesktop();
                    try {
                        desk.browse(new URI("http://sts.js-home.org/stellwerksim/forum/ucp.php?i=pm&mode=compose&u=15208"));
                    }
                    catch (IOException e1) {
                        System.err.println("Konnte STS-Forum nicht \u00f6ffnen!");
                    }
                    catch (URISyntaxException e1) {
                        System.err.println("Konnte STS-Forum nicht \u00f6ffnen!");
                    }
                }
            }
        });
        pnButton.setOpaque(false);
        pnButton.setFocusPainted(false);
        pnButton.setFont(new Font("Dialog", 1, 10));
        pnButton.setMaximumSize(new Dimension(200, 200));
        return pnButton;
    }

    protected OptionsManager getOptions() {
        return this.options;
    }

    public PlatformUI getPlatformUI() {
        return this.platformUI;
    }

    protected void updateHardMode() {
        this.versp_cards.show(this.versp_pane, this.getOptions().isHardModeEnabled() ? "HART" : "NORMAL");
    }
}

