/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import js.java.schaltungen.flagdata;
import js.java.stspluginlib.PluginClient;
import plugin.ConnectionManager;
import plugin.DecryptedTimeTable;
import plugin.StopTimeIcon;
import plugin.Train;

public class DecryptedTimeTableSingle {
    private PluginClient.ZugFahrplanZeile data;
    protected String plan;
    protected String gleis;
    protected long an;
    protected long ab;
    protected flagdata flags;
    private String anFormatted;
    private String abFormatted;
    private ConnectionManager cManager;
    private Integer zid_future;
    private LinkedList<String> descriptions;
    private boolean durchfahrt = false;
    private boolean bedarfshalt = false;
    private int holds;
    private String abNext = "-/-";
    private Timer refreshTimer;
    private Train trainNew;
    private DecryptedTimeTable masterplan;
    private boolean fluegelt = false;
    private boolean kuppelt = false;
    private boolean lokwechsel = false;
    private boolean lokumsetzung = false;
    private boolean rename = false;
    private boolean reverse = false;
    private boolean vorzeitig;
    private int eta = 0;

    protected LinkedList<String> getDescriptions() {
        return this.descriptions;
    }

    protected DecryptedTimeTableSingle(DecryptedTimeTable masterplan, PluginClient.ZugFahrplanZeile zeile, ConnectionManager cManager) {
        this.cManager = cManager;
        this.data = zeile;
        this.plan = this.data.plan;
        this.gleis = this.data.gleis;
        this.an = this.data.an;
        this.ab = this.data.ab;
        this.flags = this.data.flags;
        this.anFormatted = this.data.getFormattedAn();
        this.abFormatted = this.data.getFormattedAb();
        this.descriptions = new LinkedList();
        this.masterplan = masterplan;
        this.decrypt();
    }

    private void decrypt() {
        String f = this.flags.toString();
        Iterator iterator = this.flags.iterator();
        while (iterator.hasNext()) {
            Integer zid_future;
            this.zid_future = zid_future = (Integer)iterator.next();
        }
        this.trainNew = this.cManager.getOtherTrain(this.zid_future);
        try {
            if (f.contains("D")) {
                if (this.an == this.ab) {
                    this.descriptions.add("Durchfahrt");
                    this.durchfahrt = true;
                } else {
                    this.descriptions.add("Bedarfshalt/Fahrzeitreserve");
                    this.bedarfshalt = true;
                }
            }
            if (f.contains("B1")) {
                this.descriptions.add("(Bereitstellung aus Depot)");
            }
            if (f.contains("W")) {
                this.descriptions.add("Erh\u00e4lt neue Lok!");
                this.lokwechsel = true;
            } else if (f.contains("L")) {
                this.descriptions.add("Lok setzt um!");
                this.lokumsetzung = true;
            } else if (f.contains("F")) {
                this.descriptions.add("Fl\u00fcgelt, hinterer Zugteil wird zu: " + this.trainNew.name + " (nach " + this.trainNew.nach + ")");
                this.fluegelt = true;
            }
            if (f.contains("K")) {
                this.descriptions.add("Kuppelt an: " + this.trainNew.name + " (nach " + this.trainNew.nach + ")");
                this.setDataOfNextTrain(this.trainNew.name, this.plan);
                this.kuppelt = true;
                this.autosave_abfahrt_naechster_zug();
            }
            if (f.contains("E")) {
                this.descriptions.add("\u00c4ndert Name in: " + this.trainNew.name + " (nach " + this.trainNew.nach + ")");
                this.setDataOfNextTrain(this.trainNew.name, this.plan);
                this.rename = true;
                this.autosave_abfahrt_naechster_zug();
            }
            if (f.contains("R")) {
                this.descriptions.add("\u00c4ndert Fahrtrichtung");
                this.reverse = true;
            }
            if (f.contains("A")) {
                this.descriptions.add("(Vorzeitige Abfahrt m\u00f6glich)");
                this.vorzeitig = true;
            }
            this.holds = (int)((this.ab - this.an) / 1000L / 60L);
            this.eta = this.masterplan.getMain().getClock().getMinutesToTime(this.an / 1000L);
        }
        catch (Exception e) {
            this.cManager.sysErr(this.trainNew == null ? String.valueOf(this.gleis) + "/" + this.anFormatted + ", DecryptedTimeTableSingle: neuer Zug hat noch keine Daten, wird sp\u00e4ter aktualisiert" : "unerwarteter Fehler");
        }
    }

    private void autosave_abfahrt_naechster_zug() {
        try {
            this.abNext = ((DecryptedTimeTableSingle)this.trainNew.plan.getFirst()).getFormattedAb();
        }
        catch (NullPointerException e) {
            this.refreshTimer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.try_again();
                }

                private void try_again() {
                    if (((DecryptedTimeTableSingle)DecryptedTimeTableSingle.this).trainNew.plan != null && ((DecryptedTimeTableSingle)DecryptedTimeTableSingle.this).trainNew.plan.getFirst() != null) {
                        DecryptedTimeTableSingle.this.abNext = ((DecryptedTimeTableSingle)((DecryptedTimeTableSingle)DecryptedTimeTableSingle.this).trainNew.plan.getFirst()).getFormattedAb();
                        ((DecryptedTimeTableSingle)DecryptedTimeTableSingle.this).masterplan.nextAb = ((DecryptedTimeTableSingle)((DecryptedTimeTableSingle)DecryptedTimeTableSingle.this).trainNew.plan.getFirst()).getFormattedAb();
                        DecryptedTimeTableSingle.this.refreshTimer.stop();
                        DecryptedTimeTableSingle.this.refreshTimer = null;
                    }
                }
            });
            this.refreshTimer.start();
        }
    }

    protected ImageIcon getSymbol(boolean animations) {
        ImageIcon result = null;
        if (this.wirdFluegeln()) {
            result = animations ? new ImageIcon("./src/plugin/images/icon_fluegelt.gif") : new ImageIcon("./src/plugin/images/x_icon_fluegelt.gif");
        } else if (this.wirdKuppeln()) {
            result = animations ? new ImageIcon("./src/plugin/images/icon_kuppelt.gif") : new ImageIcon("./src/plugin/images/x_icon_kuppelt.gif");
        } else if (this.wirdLokGewechselt()) {
            result = animations ? new ImageIcon("./src/plugin/images/icon_lokwechsel.gif") : new ImageIcon("./src/plugin/images/x_icon_lokwechsel.gif");
        } else if (this.wirdLokUmgesetzt()) {
            result = animations ? new ImageIcon("./src/plugin/images/icon_lokumsetzung.gif") : new ImageIcon("./src/plugin/images/x_icon_lokumsetzung.gif");
        } else if (this.wirdDurchfahren()) {
            result = new ImageIcon("./src/plugin/images/icon_durchfahrt.gif");
        } else if (this.wirdUmbenannt()) {
            result = this.wirdUmdrehen() ? new ImageIcon("./src/plugin/images/icon_umbenennen_umdrehen.gif") : new ImageIcon("./src/plugin/images/icon_umbenennen.gif");
        } else {
            int zeit = (int)((this.ab - this.an) / 1000L / 60L);
            result = !this.wirdBeiBedarfHalten() && !this.wirdVorzeitigAbfahren() ? (this.wirdUmdrehen() ? new StopTimeIcon().getStopReverseImage(zeit) : new StopTimeIcon().getStopImage(zeit)) : (this.wirdBeiBedarfHalten() ? new StopTimeIcon().getStopIfNeededImage(zeit) : new StopTimeIcon().getStopForceImage(zeit));
        }
        return result;
    }

    protected int getStopTime() {
        return this.holds;
    }

    protected String getFormattedAn() {
        return this.anFormatted;
    }

    protected String getFormattedAb() {
        return this.abFormatted;
    }

    protected String getFormattedAbNextTrain() {
        return this.abNext;
    }

    public String toString() {
        String result = "";
        for (String s : this.descriptions) {
            result = String.valueOf(result) + s + " ### ";
        }
        return result;
    }

    protected boolean wirdDurchfahren() {
        return this.durchfahrt;
    }

    protected boolean wirdBeiBedarfHalten() {
        return this.bedarfshalt;
    }

    protected boolean wirdVorzeitigAbfahren() {
        return this.vorzeitig;
    }

    protected String getNewName() {
        return this.masterplan.nextName;
    }

    protected void setDataOfNextTrain(String newName, String newVon) {
        this.masterplan.nextName = newName;
        this.masterplan.nextVon = newVon;
    }

    protected boolean wirdFluegeln() {
        return this.fluegelt;
    }

    protected boolean wirdKuppeln() {
        return this.kuppelt;
    }

    protected boolean wirdLokUmgesetzt() {
        return this.lokumsetzung;
    }

    protected boolean wirdLokGewechselt() {
        return this.lokwechsel;
    }

    protected boolean wirdUmdrehen() {
        return this.reverse;
    }

    protected boolean wirdUmbenannt() {
        return this.rename;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.ab ^ this.ab >>> 32);
        result = 31 * result + (int)(this.an ^ this.an >>> 32);
        result = 31 * result + this.eta;
        result = 31 * result + (this.gleis == null ? 0 : this.gleis.hashCode());
        return result;
    }

    public String getDescriptionString() {
        String result = "";
        for (String description : this.descriptions) {
            result = String.valueOf(result) + description;
            result = String.valueOf(result) + "<br>";
        }
        return result;
    }
}

