/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import js.java.stspluginlib.PluginClient;
import plugin.ButtonPane;
import plugin.Clock;
import plugin.DecryptedTimeTable;
import plugin.PlatformTimeTable;
import plugin.PlatformUI;
import plugin.TabbedPluginPane;
import plugin.Train;
import plugin.TrainPane;
import plugin.TrainPaneGreen;
import plugin.TrainPaneOutside;

public class ConnectionManager
extends PluginClient {
    private Timer refreshTimer;
    private String name;
    private final TreeMap<String, PlatformTimeTable> bahnsteige = new TreeMap();
    private HashMap<Integer, Train> zuglist = new HashMap();
    private TabbedPluginPane ui;
    private PlatformUI platform_ui;
    private LinkedList<String> error_stack;
    public static final boolean EVENTS_ENABLED = true;
    private Clock clock;
    private Timer idleTimer;
    private String idlecheckstring = "init";
    private boolean closed = false;
    private boolean animations_enabled_tmp;
    private int stops_tmp;
    private boolean alarm_enabled_tmp;
    private boolean verspaetung_mode_hard_enabled_tmp;
    private boolean reconnect = false;

    protected TabbedPluginPane getUi() {
        return this.ui;
    }

    protected PlatformUI getPlatform_ui() {
        return this.platform_ui;
    }

    protected void setPlatform_ui(PlatformUI platform_ui) {
        this.platform_ui = platform_ui;
    }

    protected ConnectionManager(JMenu menu, TabbedPluginPane ui) {
        super("STS Analyse", "duncyo", "0.510", "STS Analyse Plugin");
        this.ui = ui;
        this.platform_ui = ui.getMainUI().getPlatformUI();
        this.animations_enabled_tmp = ui.getMainUI().getOptions().isAnimationEnabled();
        this.stops_tmp = ui.getMainUI().getOptions().getMaxStops();
        this.addAutoRefresh();
        this.addIdleChecker();
        this.createStack();
    }

    private void createStack() {
        this.error_stack = new LinkedList();
    }

    protected void repaint() {
    }

    protected Clock createClock() {
        this.clock = new Clock(this);
        return this.clock;
    }

    private void addIdleChecker() {
        this.idleTimer = new Timer(20000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (ConnectionManager.this.idlecheckstring.equals("")) {
                        System.err.println("close aus idlechecker");
                        ConnectionManager.this.close();
                        ConnectionManager.this.idleTimer.stop();
                    } else {
                        ConnectionManager.this.idlecheckstring = "";
                        ConnectionManager.this.request_anlageninfo();
                    }
                }
                catch (Exception e) {
                    System.err.println("SIM nicht mehr erreichbar - exit");
                    ConnectionManager.this.close();
                }
            }
        });
        this.idleTimer.setInitialDelay(2500);
    }

    public void close() {
        super.close();
    }

    private void addAutoRefresh() {
        this.refreshTimer = new Timer(3000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    ConnectionManager.this.request_zugliste();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ConnectionManager.this.ui.push(ConnectionManager.this.zuglist);
                            ConnectionManager.this.platform_ui.getControl().push(ConnectionManager.this.zuglist);
                            ConnectionManager.this.platform_ui.push(ConnectionManager.this.zuglist);
                        }
                    });
                }
                catch (Exception e) {
                    System.err.println("PluginClient nicht mehr erreichbar - exit");
                    ConnectionManager.this.close();
                }
            }
        });
    }

    protected synchronized void closed() {
        this.idleTimer.stop();
        this.refreshTimer.stop();
        if (!this.closed) {
            this.closed = true;
            if (!this.reconnect) {
                this.ui.getMainUI().exit();
            } else {
                this.reconnect = false;
                this.addIdleChecker();
                this.addAutoRefresh();
                this.ui.getMainUI().connect();
            }
        }
    }

    public void reset() {
        System.err.println("Sim-Zeit ung\u00fcltig, Plugin-Schnittstelle reset");
        this.reconnect = true;
        this.idleTimer.stop();
        this.refreshTimer.stop();
        this.close();
    }

    protected void connected() {
        this.request_setdebug(true);
        this.request_anlageninfo();
        this.request_bahnsteigliste();
        this.refreshTimer.setInitialDelay(1000);
        this.refreshTimer.start();
        this.idleTimer.start();
    }

    protected synchronized void response_anlageninfo(int aid, String name, String build) {
        this.idlecheckstring = name;
        this.name = name;
        this.ui.setStellwerk(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void response_bahnsteigliste(HashMap<String, HashSet<String>> bl) {
        TreeMap<String, PlatformTimeTable> treeMap = this.bahnsteige;
        synchronized (treeMap) {
            this.bahnsteige.clear();
            for (String s : bl.keySet()) {
                this.bahnsteige.put(s, null);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){
            private Timer bahnsteigInitTimer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TreeMap treeMap = ConnectionManager.this.bahnsteige;
                synchronized (treeMap) {
                    try {
                        for (Map.Entry entry : ConnectionManager.this.bahnsteige.entrySet()) {
                            PlatformTimeTable p = new PlatformTimeTable((String)entry.getKey(), ConnectionManager.this.ui.getMainUI().getOptions());
                            entry.setValue(p);
                        }
                        ((ConnectionManager)ConnectionManager.this).ui.getMainUI().platformUI.setBahnsteige(ConnectionManager.this.bahnsteige);
                    }
                    catch (NullPointerException nullPointerException) {
                        this.bahnsteigInitTimer = new Timer(500, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent evt) {
                                try {
                                    ((ConnectionManager)(this).ConnectionManager.this).ui.getMainUI().platformUI.setBahnsteige(ConnectionManager.this.bahnsteige);
                                    bahnsteigInitTimer.stop();
                                    bahnsteigInitTimer = null;
                                }
                                catch (NullPointerException e) {
                                    System.err.println("retry: initialize platform");
                                }
                            }
                        });
                        this.bahnsteigInitTimer.start();
                    }
                }
            }
        });
    }

    protected synchronized void response_zugliste(HashMap<Integer, String> zl) {
        for (Integer zid : zl.keySet()) {
            if (!this.zuglist.containsKey(zid)) {
                this.zuglist.put(zid, null);
                this.register_ereignis(zid, "einfahrt");
                this.register_ereignis(zid, "ankunft");
                this.register_ereignis(zid, "abfahrt");
                this.register_ereignis(zid, "ausfahrt");
            }
            try {
                this.request_zugdetails(zid);
            }
            catch (Exception e) {
                System.err.println(e + ", Abgefangen in Connection.java");
            }
        }
        Iterator<Integer> it = this.zuglist.keySet().iterator();
        while (it.hasNext()) {
            int zid = it.next();
            if (zl.containsKey(zid)) continue;
            try {
                if (this.zuglist.get(zid).getTrainPanel() != null && !this.zuglist.get(zid).getTrainPanel().isRemoving()) {
                    this.zuglist.get(zid).getTrainPanel().abwinken2();
                }
                if (this.zuglist.get(zid).getTrainPanelGreen() != null && !this.zuglist.get(zid).getTrainPanelGreen().isRemoving()) {
                    this.zuglist.get(zid).getTrainPanelGreen().abwinken2();
                }
                if (this.zuglist.get(zid).getTrainPanelOutside() != null && !this.zuglist.get(zid).getTrainPanelOutside().isRemoving()) {
                    this.zuglist.get(zid).getTrainPanelOutside().abwinken2();
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            it.remove();
        }
    }

    protected synchronized void response_ereignis(int zid, String eventName, PluginClient.ZugDetails zd) {
        TrainPaneOutside trainPane3;
        TrainPane trainPane = this.zuglist.get(zid) != null ? this.zuglist.get(zid).getTrainPanel() : null;
        TrainPaneGreen trainPane2 = this.zuglist.get(zid) != null ? this.zuglist.get(zid).getTrainPanelGreen() : null;
        TrainPaneOutside trainPaneOutside = trainPane3 = this.zuglist.get(zid) != null ? this.zuglist.get(zid).getTrainPanelOutside() : null;
        if (eventName.equals("einfahrt")) {
            if (trainPane3 != null) {
                trainPane3.showAlarm();
            }
            if (trainPane2 != null) {
                trainPane2.setTrainArrivedNow();
            }
        }
        try {
            if ((eventName.equals("ankunft") || eventName.equals("abfahrt")) && this.zuglist.get(zid) != null && trainPane2 != null) {
                trainPane2.pushEvent(eventName, zd);
            }
            if (eventName.equals("ankunft") && this.zuglist.get(zid) != null) {
                this.getPlatform_ui().setTrainArrived(zid, zd.gleis);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (eventName.equals("ausfahrt")) {
            this.ui.removeFromAllList(zid, this.zuglist.get(zid));
            try {
                if (trainPane != null && trainPane.removesOnEvent(eventName) && !trainPane.isRemoving()) {
                    trainPane.abwinken2();
                }
                if (trainPane2 != null && trainPane2.removesOnEvent(eventName) && !trainPane2.isRemoving()) {
                    trainPane2.abwinken2();
                }
            }
            catch (Exception e) {
                System.out.println("zuglist.get(zid)==null: " + (this.zuglist.get(zid) == null) + (this.zuglist.get(zid) == null ? "-" : ", zuglist.get(zid).getTrainPanel()==null: " + (this.zuglist.get(zid).getTrainPanel() == null)));
                e.printStackTrace();
            }
        }
        if (eventName.equals("ausfahrt")) {
            // empty if block
        }
    }

    protected void setAnimationsEnabled(boolean b) {
        if (b != this.animations_enabled_tmp) {
            this.animations_enabled_tmp = b;
            for (Train zug : this.zuglist.values()) {
                zug.setAnimationsEnabled(b);
            }
        }
    }

    public void setAlarmEnabled(final boolean e) {
        if (e != this.alarm_enabled_tmp) {
            this.alarm_enabled_tmp = e;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (Train zug : ConnectionManager.this.zuglist.values()) {
                        zug.setAlarmEnabled(e);
                    }
                }
            });
        }
    }

    public void setVerspaetungsModeHard(boolean verspaetung_mode_hard) {
        if (verspaetung_mode_hard != this.verspaetung_mode_hard_enabled_tmp) {
            this.verspaetung_mode_hard_enabled_tmp = verspaetung_mode_hard;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (Train zug : ConnectionManager.this.zuglist.values()) {
                        zug.refreshVerspaetungHardMode();
                    }
                }
            });
            this.getUi().getMainUI().updateHardMode();
        }
    }

    protected void setNewMaxStops(int stops) {
        if (stops != this.stops_tmp) {
            this.stops_tmp = stops;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (Train zug : ConnectionManager.this.zuglist.values()) {
                        zug.setNewMaxStops();
                    }
                }
            });
        }
    }

    public void setTrainColor(final String k\u00fcrzel, final int color_number) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Train zug : ConnectionManager.this.zuglist.values()) {
                    if (zug == null || zug.name == null || !zug.name.split(" ")[0].equals(k\u00fcrzel)) continue;
                    zug.setNotecolorEverywhere(ButtonPane.MarkerColors.values()[color_number]);
                }
            }
        });
    }

    public void parseAllTrainNames() {
        boolean retry = false;
        block2: do {
            retry = false;
            for (Train zug : this.zuglist.values()) {
                try {
                    zug.updateName();
                }
                catch (Exception e) {
                    retry = true;
                    continue block2;
                }
            }
        } while (retry);
    }

    protected void updateOptionsTrainlist() {
        for (Integer zid : this.zuglist.keySet()) {
            try {
                if (!this.ui.getMainUI().schweiz_mode && !this.ui.getMainUI().getOptions().hasTrain(this.zuglist.get((Object)zid).name.split(" ")[0])) {
                    this.ui.getMainUI().getOptions().setTrainEnabled(this.zuglist.get((Object)zid).name.split(" ")[0], false);
                }
                if (!this.ui.getMainUI().schweiz_mode || this.ui.getMainUI().getOptions().hasTrain(this.ui.getMainUI().schweiz_xml.getKuerzel(this.zuglist.get((Object)zid).name))) continue;
                this.ui.getMainUI().getOptions().setTrainEnabled(this.ui.getMainUI().schweiz_xml.getKuerzel(this.zuglist.get((Object)zid).name), false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected synchronized void response_zugdetails(int zid, PluginClient.ZugDetails details) {
        Train zd = this.zuglist.get(zid);
        if (zd == null) {
            zd = new Train(details, this.ui);
            this.zuglist.put(zid, zd);
            this.ui.addToAllList(zid, this.zuglist.get(zid));
            this.ui.addToOutsideList(zid, this.zuglist.get(zid));
            this.request_zugfahrplan(zid);
        } else {
            zd.update(details);
            try {
                this.request_zugfahrplan(zid);
            }
            catch (Exception e) {
                System.err.println(e + ", Abgefangen in Connection.java");
            }
        }
        this.repaint();
    }

    protected synchronized void response_zugfahrplan(int zid, LinkedList<PluginClient.ZugFahrplanZeile> plan) {
        Train zd = this.zuglist.get(zid);
        if (zd != null) {
            zd.plan = new DecryptedTimeTable(plan, this, zd);
            zd.forceGleisUpdate();
        } else {
            System.out.println("Fehler: F\u00fcr " + zid + " fehlen die Details!");
        }
    }

    public String getName() {
        return this.name;
    }

    protected Train getOtherTrain(Integer zid) {
        return this.zuglist.get(zid);
    }

    public void sysErr(String string) {
        if (!this.error_stack.contains(string)) {
            System.err.println(string);
            this.error_stack.add(string);
        }
    }
}

