/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import plugin.ConnectionManager;

public class Clock
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel stunden;
    private JLabel minuten;
    private ConnectionManager connection;
    private Timer refreshTimer;
    private JLabel sekunden;
    private long time;
    private long starttime = 0L;
    private String start_realtime;

    protected Clock(ConnectionManager connection) {
        this.setLayout(new BoxLayout(this, 2));
        this.stunden = new JLabel("XX");
        this.minuten = new JLabel("XX");
        this.sekunden = new JLabel("XX");
        this.connection = connection;
        Font font = new Font("Courier", 1, 12);
        this.add(new JLabel("Uhrzeit: "));
        this.add(this.stunden);
        this.add(new JLabel(":"));
        this.add(this.minuten);
        this.add(new JLabel(":"));
        this.add(this.sekunden);
        this.add(Box.createHorizontalGlue());
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.setFont(font);
            ++n2;
        }
        this.addRefreshTimer();
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
    }

    private void addRefreshTimer() {
        this.refreshTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Clock.this.setTime(Clock.this.connection.getSimutime());
            }
        });
        this.refreshTimer.start();
    }

    protected String getStartTime() {
        return String.valueOf(this.stunden(this.starttime)) + ":" + this.minuten(this.starttime);
    }

    protected String getTotalTime() {
        long totaltime = this.time - this.starttime + 59L;
        return String.valueOf(this.stunden(totaltime)) + ":" + this.minuten(totaltime);
    }

    protected String getEndTime() {
        return String.valueOf(this.stunden(this.time)) + ":" + this.minuten(this.time);
    }

    protected String getRealCurrentTime() {
        Calendar zeit = Calendar.getInstance();
        zeit.setTimeInMillis(System.currentTimeMillis());
        String stunden = "" + zeit.get(11);
        String minuten = "" + zeit.get(12);
        if (stunden.length() == 1) {
            stunden = "0" + stunden;
        }
        if (minuten.length() == 1) {
            minuten = "0" + minuten;
        }
        return String.valueOf(stunden) + ":" + minuten;
    }

    protected String getRealStartTime() {
        return this.start_realtime;
    }

    protected void setTime(long t) {
        this.time = t / 1000L;
        if (this.starttime == 0L) {
            this.starttime = this.time;
            Calendar zeit = Calendar.getInstance();
            zeit.setTimeInMillis(System.currentTimeMillis());
            String stunden = "" + zeit.get(11);
            String minuten = "" + zeit.get(12);
            if (stunden.length() == 1) {
                stunden = "0" + stunden;
            }
            if (minuten.length() == 1) {
                minuten = "0" + minuten;
            }
            this.start_realtime = String.valueOf(stunden) + ":" + minuten;
        }
        if (!this.sekunden.getText().equals(this.sekunden(this.time))) {
            this.stunden.setText(this.stunden(this.time));
            this.minuten.setText(this.minuten(this.time));
            this.sekunden.setText(this.sekunden(this.time));
            this.revalidate();
            this.repaint();
        }
        if (this.connection.getSimutime() < 10000L || this.connection.getSimutime() > 86400000L && this.connection.getUi().getMainUI().connected) {
            this.refreshTimer.stop();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Clock.this.connection.reset();
                }
            });
        }
    }

    private String minuten(long time) {
        String tmp = "" + (int)(time / 60L) % 60;
        if (("" + (int)(time / 60L % 60L)).length() == 1) {
            tmp = "0" + tmp;
        }
        return tmp;
    }

    private String stunden(long time) {
        String tmp = "" + (int)(time / 60L / 60L);
        if (("" + (int)(time / 60L / 60L)).length() == 1) {
            tmp = "0" + tmp;
        }
        return tmp;
    }

    private String sekunden(long time) {
        String tmp = "" + time % 60L;
        if (("" + time % 60L).length() == 1) {
            tmp = "0" + tmp;
        }
        return tmp;
    }

    protected boolean isReached(long time) {
        return time <= this.time;
    }

    protected int getMinutesToTime(long time) {
        return (int)(time / 60L - this.time / 60L);
    }

    protected long getTime() {
        return this.time;
    }

    protected String getTimeString() {
        String stunden = this.stunden(this.time);
        String minuten = this.minuten(this.time);
        if (stunden.length() == 1) {
            stunden = "0" + stunden;
        }
        if (minuten.length() == 1) {
            minuten = "0" + minuten;
        }
        return String.valueOf(stunden) + ":" + minuten;
    }
}

