/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import plugin.ChangelogSingleUpdate;
import plugin.XMLHandler;

public class ChangeLogPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane scrollPane;
    private JTextArea editorPane;
    private List<ChangelogSingleUpdate> updatelist = new LinkedList<ChangelogSingleUpdate>();

    protected ChangeLogPanel() {
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.scrollPane = new JScrollPane();
        this.scrollPane.setAutoscrolls(false);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.add(this.scrollPane);
        this.editorPane = new JTextArea();
        this.editorPane.setAutoscrolls(false);
        this.editorPane.setEditable(false);
        this.editorPane.setLineWrap(true);
        this.editorPane.setWrapStyleWord(true);
        this.editorPane.setText("");
        this.scrollPane.setViewportView(this.editorPane);
        this.scrollPane.setPreferredSize(new Dimension(600, 350));
        this.scrollPane.setMinimumSize(new Dimension(600, 350));
        this.scrollPane.setMaximumSize(new Dimension(600, 350));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChangeLogPanel.this.scrollPane.getVerticalScrollBar().setValue(0);
            }
        });
        XMLHandler handler = new XMLHandler(this);
        handler.convertFromChangelogXML();
    }

    public void addUpdate(String version, String date, String[] upgrades, String[] fixed) {
        ChangelogSingleUpdate new_update = new ChangelogSingleUpdate(version, date, upgrades, fixed);
        this.updatelist.add(new_update);
        this.editorPane.setText(String.valueOf(this.editorPane.getText()) + new_update.toString());
        this.editorPane.setCaretPosition(0);
    }

    public void showNewPopup(Component frame, String version) {
        for (ChangelogSingleUpdate update : this.updatelist) {
            if (!update.version.equals(version)) continue;
            String updatetext = update.toString();
            updatetext = String.valueOf(updatetext) + "Dieses Fenster wird je Update einmalig angezeigt.\r\n";
            JOptionPane.showMessageDialog(frame, updatetext, "Neues Update verf\u00fcgbar!", 1);
        }
    }
}

