/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import plugin.Train;

public class ButtonPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected boolean levelHigh;
    protected JPopupMenu menu;

    protected ButtonPane() {
        this(true);
    }

    protected ButtonPane(boolean warninglevelHigh) {
        this.setBackground(new Color(255, 115, 115));
        this.setBorder(new CompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(0, 0, 0, 5)));
        this.levelHigh = warninglevelHigh;
        this.addMouseListeners();
        this.initPopup();
    }

    protected void addMouseListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ButtonPane.this.setBackground(ButtonPane.this.isWarningLevelHigh() ? new Color(255, 145, 145) : new Color(255, 244, 128));
                ButtonPane.this.setBorder(new CompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(0, 0, 0, 5)));
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ButtonPane.this.setBackground(ButtonPane.this.isWarningLevelHigh() ? new Color(255, 115, 115) : new Color(255, 240, 84));
                ButtonPane.this.setBorder(new CompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(0, 0, 0, 5)));
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.checkPopup(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.checkPopup(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.checkPopup(evt);
            }

            private void checkPopup(MouseEvent evt) {
                if (evt.isPopupTrigger() || SwingUtilities.isRightMouseButton(evt)) {
                    ButtonPane.this.showPopUpMenu(evt.getX(), evt.getY(), ButtonPane.this, ButtonPane.this.getZug());
                } else if (evt.isAltDown() || evt.getButton() == 3) {
                    ButtonPane.this.copyToClipboard();
                } else {
                    ButtonPane.this.leftclick();
                }
            }
        });
    }

    protected void showPopUpMenu(int x, int y, Component t, Train zug) {
    }

    protected void setWarningLevelHigh(boolean levelHigh) {
        this.levelHigh = levelHigh;
        this.setBackground(this.isWarningLevelHigh() ? new Color(255, 115, 115) : new Color(255, 240, 84));
    }

    protected boolean isWarningLevelHigh() {
        return this.levelHigh;
    }

    protected void leftclick() {
    }

    protected void copyToClipboard() {
    }

    protected void copyToClipboardAll() {
    }

    protected void copyToClipboardGWB() {
    }

    protected void copyToClipboard_einfahrt() {
    }

    protected void copyToClipboard_stoerungEnde(boolean einfahrt) {
    }

    protected void copyToClipboard_stoerung(boolean einfahrt) {
    }

    protected void initPopup() {
        this.menu = new JPopupMenu();
        JMenuItem item = new JMenuItem(new AbstractAction(" Zug-Nummer (auch via Mouse3) "){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPane.this.copyToClipboard();
            }
        });
        item.setIcon(new ImageIcon("./src/plugin/images/number.png"));
        JMenuItem item2 = new JMenuItem(new AbstractAction(" Zug-Daten "){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPane.this.copyToClipboardAll();
            }
        });
        item2.setIcon(new ImageIcon("./src/plugin/images/data.png"));
        JMenuItem item3_1 = new JMenuItem(new AbstractAction(" Zug: Linksfahrt anfragen "){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPane.this.copyToClipboardGWB();
            }
        });
        item3_1.setIcon(new ImageIcon("./src/plugin/images/change_left.png"));
        JMenuItem item3_2 = new JMenuItem(new AbstractAction(" Zug: Um Einfahrtr\u00e4umung bitten "){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPane.this.copyToClipboard_einfahrt();
            }
        });
        item3_2.setIcon(new ImageIcon("./src/plugin/images/broom.png"));
        JMenu item3 = new JMenu(" St\u00f6rungstext");
        JMenuItem item3_3 = new JMenuItem(new AbstractAction(" [EINFAHRT] Aktuell keine Einfahrt m\u00f6glich"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPane.this.copyToClipboard_stoerung(true);
            }
        });
        item3.setIcon(new ImageIcon("./src/plugin/images/repair.png"));
        JMenuItem item3_4 = new JMenuItem(new AbstractAction(" [EINFAHRT] Einfahrt wieder m\u00f6glich, St\u00f6rung behoben"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPane.this.copyToClipboard_stoerungEnde(true);
            }
        });
        JMenuItem item3_5 = new JMenuItem(new AbstractAction(" [AUSFAHRT] Aktuell keine Ausfahrt m\u00f6glich"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPane.this.copyToClipboard_stoerung(false);
            }
        });
        JMenuItem item3_6 = new JMenuItem(new AbstractAction(" [AUSFAHRT] Ausfahrt wieder m\u00f6glich, St\u00f6rung behoben"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPane.this.copyToClipboard_stoerungEnde(false);
            }
        });
        JMenuItem description_copy = new JMenuItem(" Kopieren in Zwischenablage " + (this.getZug() == null ? "" : "(" + this.getZug().name + ")"));
        description_copy.setFont(new Font("Dialog", 1, 12));
        MouseListener[] mouseListenerArray = description_copy.getMouseListeners();
        int n = mouseListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseListener m = mouseListenerArray[n2];
            description_copy.removeMouseListener(m);
            ++n2;
        }
        description_copy.setBackground(Color.LIGHT_GRAY);
        description_copy.setOpaque(true);
        description_copy.setBorder(BorderFactory.createRaisedBevelBorder());
        JMenu item_color = new JMenu(" Farbmarkierung ");
        item_color.setFont(new Font("Dialog", 1, 12));
        item_color.setIcon(new ImageIcon("./src/plugin/images/color_fill.png"));
        item_color.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        AbstractAction abstractAction = new AbstractAction(" Zug aus allen Ansichten entfernen!"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showConfirmDialog(ButtonPane.this, "Diesen Zug wirklich l\u00f6schen?", "Best\u00e4tigung", 0) == 0) {
                    ButtonPane.this.removeFromAll();
                }
            }
        };
        JMenuItem debug = new JMenuItem(abstractAction);
        debug.setIcon(new ImageIcon("./src/plugin/images/delete.png"));
        ButtonGroup colors = new ButtonGroup();
        JRadioButtonMenuItem[] items = new JRadioButtonMenuItem[MarkerColors.values().length];
        MarkerColors[] markerColorsArray = MarkerColors.values();
        int n3 = markerColorsArray.length;
        int n4 = 0;
        while (n4 < n3) {
            final MarkerColors color = markerColorsArray[n4];
            items[color.ordinal()] = new JRadioButtonMenuItem(new AbstractAction(" " + color.getColorName() + " "){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonPane.this.setNoteColor(color);
                }
            });
            items[color.ordinal()].setBackground(color.getBackground());
            items[color.ordinal()].setForeground(color.getForeground());
            items[color.ordinal()].setOpaque(color != MarkerColors.Keine);
            items[color.ordinal()].setFont(new Font("Dialog", 1, 12));
            ((Container)item_color).add(items[color.ordinal()]);
            colors.add(items[color.ordinal()]);
            if (color == MarkerColors.Keine) {
                items[color.ordinal()].setSelected(true);
            }
            ++n4;
        }
        item3_3.setIcon(new ImageIcon("./src/plugin/images/stop.png"));
        item3_4.setIcon(new ImageIcon("./src/plugin/images/done.png"));
        item3_5.setIcon(new ImageIcon("./src/plugin/images/stop.png"));
        item3_6.setIcon(new ImageIcon("./src/plugin/images/done.png"));
        item3.add(item3_4);
        item3.addSeparator();
        item3.add(item3_5);
        item3.add(item3_6);
        this.menu.add(item_color);
        this.menu.addSeparator();
        this.menu.add(description_copy);
        this.menu.add(item);
        this.menu.add(item2);
        this.menu.addSeparator();
        this.menu.add(item3_1);
        this.menu.add(item3_2);
        this.menu.add(item3);
        this.menu.addSeparator();
        this.menu.add(debug);
        item3.add(item3_3);
        if (!this.isTrainDel_Enabled()) {
            debug.setEnabled(false);
        }
    }

    protected void setNoteColor(MarkerColors color) {
    }

    protected void removeFromAll() {
    }

    protected Train getZug() {
        return null;
    }

    protected boolean isTrainDel_Enabled() {
        return false;
    }

    protected static enum MarkerColors {
        Keine("keine", new Color(215, 215, 215)),
        Violett("", Color.MAGENTA, Color.WHITE, Color.GREEN),
        Rot("", Color.RED, Color.BLACK, Color.YELLOW),
        Orange("", Color.ORANGE),
        Gelb("", Color.YELLOW),
        Hellgelb("", new Color(255, 255, 195)),
        Gr\u00fcn("", Color.GREEN),
        T\u00fcrkis("", Color.CYAN),
        Blau("", Color.BLUE, Color.WHITE, Color.ORANGE);

        private String name;
        private Color color;
        private Color foreground;
        private Color foreground_active;

        private MarkerColors(String name, Color color) {
            this(name, color, Color.BLACK, Color.RED);
        }

        private MarkerColors(String name, Color background, Color foreground, Color foreground_active) {
            this.color = background;
            this.name = name;
            this.foreground = foreground;
            this.foreground_active = foreground_active;
        }

        public String getColorName() {
            return this.name;
        }

        public Color getBackground() {
            return this.color;
        }

        public Color getForeground() {
            return this.foreground;
        }

        public Color getForegroundActive() {
            return this.foreground_active;
        }
    }
}

