/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;

public class Blinker {
    protected int rounds = 1;
    private JComponent c;
    private Timer blinktimer;
    private Color color;
    private Color normalcolor;
    private boolean foreground_mode;

    protected Blinker(JComponent c) {
        this(c, new Color(186, 255, 186), false);
    }

    protected Blinker(JComponent c, Color blinkColor, boolean foreground) {
        this.c = c;
        this.foreground_mode = foreground;
        this.normalcolor = foreground ? c.getForeground() : c.getBackground();
        this.color = blinkColor;
        this.blinktimer = new Timer(800, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Blinker.this.fireAction();
            }
        });
        this.blinktimer.setInitialDelay(0);
        this.blinktimer.start();
    }

    protected void fireAction() {
        ++this.rounds;
        if (this.foreground_mode) {
            this.c.setForeground(this.rounds % 2 == 0 ? this.color : this.normalcolor);
        } else {
            this.c.setBackground(this.rounds % 2 == 0 ? this.color : this.normalcolor);
        }
        if (this.rounds == 9) {
            this.blinktimer.stop();
            this.blinktimer = null;
            this.c = null;
        }
    }
}

