/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import layout.TableLayout;
import plugin.MainUI;
import plugin.Train;

public class Analysis
extends JFrame {
    private static final long serialVersionUID = 1L;
    private String windowtitle = "STS Analyse: Auswertung";
    private String stellwerkname;
    private String startzeit;
    private String endzeit;
    private String gesamtzeit;
    private String echt_startzeit;
    private String echt_endzeit;
    private String gesamtverspaetung;
    private Image appicon = Toolkit.getDefaultToolkit().createImage("./src/plugin/images/train_icon.png");
    private String contentText;

    protected Analysis(MainUI ui, LinkedList<Train> zugarchiv) {
        this.setIconImage(this.appicon);
        this.stellwerkname = ui.getConnection().getName();
        this.startzeit = ui.getClock().getStartTime();
        this.endzeit = ui.getClock().getEndTime();
        this.gesamtzeit = ui.getClock().getTotalTime();
        this.echt_startzeit = ui.getClock().getRealStartTime();
        this.echt_endzeit = ui.getClock().getRealCurrentTime();
        this.gesamtverspaetung = this.convertMinutesToTime(ui.getOptions().isHardModeEnabled() ? ui.eigeneVerspaetungenFix : ui.eigeneVerspaetungen);
        JTextArea editor = new JTextArea();
        JPanel pane = new JPanel();
        double[][] tbSize = new double[][]{{-1.0}, {-3.0, -1.0}};
        pane.setLayout(new GridLayout(1, 1));
        pane.add((Component)editor, "0,1");
        JButton copyButton = new JButton("KOPIEREN");
        copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(Analysis.this.contentText), null);
                }
                catch (HeadlessException ex) {
                    System.err.println("Konnte nicht kopiert werden");
                }
            }
        });
        copyButton.setOpaque(false);
        copyButton.setFocusPainted(false);
        copyButton.setDoubleBuffered(true);
        copyButton.setFocusCycleRoot(false);
        copyButton.setMaximumSize(new Dimension(200, 200));
        copyButton.setMinimumSize(new Dimension(200, 70));
        copyButton.setFont(new Font("Dialog", 1, 14));
        pane.add((Component)copyButton, "0,0");
        JScrollPane scroller = new JScrollPane(pane, 22, 30);
        scroller.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createEtchedBorder()));
        this.contentText = "";
        this.contentText = String.valueOf(this.contentText) + "Datum: " + this.getDateString() + "\r\n";
        this.contentText = String.valueOf(this.contentText) + "Stellwerk: " + this.stellwerkname + "\r\n";
        this.contentText = String.valueOf(this.contentText) + "\r\n";
        this.contentText = String.valueOf(this.contentText) + "Spielzeit: " + this.startzeit + " bis " + this.endzeit + " (Dauer: " + this.gesamtzeit + ")" + "\r\n";
        this.contentText = String.valueOf(this.contentText) + "Echtzeit: " + this.echt_startzeit + " bis " + this.echt_endzeit + "\r\n";
        this.contentText = String.valueOf(this.contentText) + "\r\n";
        this.contentText = String.valueOf(this.contentText) + "Anzahl abgefertigter Z\u00fcge: " + zugarchiv.size() + "\r\n";
        this.contentText = String.valueOf(this.contentText) + "Eigene Versp\u00e4tung aller Z\u00fcge: " + this.gesamtverspaetung + "\r\n";
        int max_verspaetung = 0;
        String max_versp_name = "";
        for (Train zug : zugarchiv) {
            if ((ui.getOptions().isHardModeEnabled() ? zug.eigeneVerspaetungFix : zug.eigeneVerspaetung) <= max_verspaetung) continue;
            max_verspaetung = ui.getOptions().isHardModeEnabled() ? zug.eigeneVerspaetungFix : zug.eigeneVerspaetung;
            max_versp_name = String.valueOf(zug.name) + " (von " + zug.von + " nach " + zug.nach + ")";
        }
        this.contentText = max_verspaetung != 0 ? String.valueOf(this.contentText) + "Maximale Versp\u00e4tung: " + this.convertMinutesToTime(max_verspaetung) + " (durch " + max_versp_name + ")" + "\r\n" : String.valueOf(this.contentText) + "Maximale Versp\u00e4tung: Keine\r\n";
        this.contentText = String.valueOf(this.contentText) + "\r\n";
        this.contentText = ui.getAllList().maxTrains > 0 ? String.valueOf(this.contentText) + "Anzahl der meisten Z\u00fcge im Stellwerk: " + ui.getAllList().maxTrains + " " + (ui.getAllList().maxTrains == 1 ? "Zug" : "Z\u00fcge") + " um " + ui.getAllList().maxTrainsTime + " (" + ui.getAllList().maxTrainsRealTime + " Echtzeit)" + "\r\n" : String.valueOf(this.contentText) + "Anzahl der meisten Z\u00fcge im Stellwerk: 0\r\n";
        this.contentText = String.valueOf(this.contentText) + "\r\n\r\n==========| Liste abgefertigter Z\u00fcge |==========\r\n";
        Collections.sort(zugarchiv);
        for (Train zug : zugarchiv) {
            String string = null;
            string = zug.verspaetung > 0 ? String.format("%-13s von %22s nach %-22s | Meine Versp.: %5s (von %5s Gesamtversp.) | STW verlassen um %5s\r\n", zug.name, zug.von, zug.nach, this.convertMinutesToTime(ui.getOptions().isHardModeEnabled() ? zug.eigeneVerspaetungFix : zug.eigeneVerspaetung), this.convertMinutesToTime(zug.verspaetung), this.convertMinutesToTime((int)(zug.real_exit / 60L))) : String.format("%-13s von %22s nach %-22s | Meine Versp.: %5s (%5s Fahrzeitreserve)  | STW verlassen um %5s\r\n", zug.name, zug.von, zug.nach, this.convertMinutesToTime(ui.getOptions().isHardModeEnabled() ? zug.eigeneVerspaetungFix : zug.eigeneVerspaetung), this.convertMinutesToTime(zug.verspaetung), this.convertMinutesToTime((int)(zug.real_exit / 60L)));
            this.contentText = String.valueOf(this.contentText) + string;
        }
        if (zugarchiv.size() == 0) {
            this.contentText = String.valueOf(this.contentText) + "\r\nKein Zug hat das Stellwerk verlassen!";
        }
        editor.setText(this.contentText);
        editor.setEditable(false);
        editor.setFont(new Font("Courier", 0, 12));
        this.setPreferredSize(new Dimension(800, 600));
        editor.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel outer_pane = new JPanel();
        outer_pane.setLayout((LayoutManager)new TableLayout((double[][])tbSize));
        outer_pane.add((Component)copyButton, "0,0");
        outer_pane.add((Component)scroller, "0,1");
        this.setContentPane(outer_pane);
        this.pack();
        this.setLocationRelativeTo(ui);
        this.setTitle(this.windowtitle);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    private String getDateString() {
        Calendar zeit = Calendar.getInstance();
        zeit.setTimeInMillis(System.currentTimeMillis());
        String result = "";
        String tag = this.getFormattedString(zeit.get(5));
        String monat = this.getFormattedString(zeit.get(2) + 1);
        String jahr = "" + zeit.get(1);
        result = String.valueOf(tag) + "." + monat + "." + jahr;
        return result;
    }

    private String getFormattedString(int i) {
        String result = "" + i;
        if (result.length() == 1) {
            result = "0" + result;
        }
        return result;
    }

    private String convertMinutesToTime(int minutes) {
        if (minutes < 0) {
            minutes = 0 - minutes;
        }
        String stunden = "" + minutes / 60;
        String minuten = "" + minutes % 60;
        if (stunden.length() == 1) {
            stunden = "0" + stunden;
        }
        if (minuten.length() == 1) {
            minuten = "0" + minuten;
        }
        return String.valueOf(stunden) + ":" + minuten;
    }
}

