/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import layout.TableLayout;
import plugin.AlignBox;
import plugin.DecryptedTimeTableSingle;
import plugin.Train;
import plugin.TrainPane;

public class AlarmWindow
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Font font = new Font("Dialog", 1, 14);
    private JPanel pane;
    protected TrainPane trainpane;
    private String title_old;
    private double[][] mainpanelSize = new double[][]{{-1.0}, {-3.0, -3.0, -3.0, -1.0, -3.0, -3.0}};
    private double[][] zwischenhalt_box_size = new double[][]{{-1.0}, {-3.0, -3.0, -3.0}};
    private JPanel zugdetailplan;
    protected JLabel name_label;
    protected JLabel plan_label;
    protected JLabel labelTop;
    protected JPanel labelTopBox;
    private Train zug;
    private JButton button;
    private boolean durchfahrt = false;
    private String gleis = "";
    private String eventname;

    protected AlarmWindow(TrainPane trainpane) {
        this(trainpane, trainpane.getMain());
    }

    protected AlarmWindow(TrainPane trainpane, Frame owner) {
        super(owner, "Einfahrt " + trainpane.getZug().name);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.zug = trainpane.getZug();
        super.setModal(true);
        this.setUndecorated(true);
        this.trainpane = trainpane;
        this.pane = new JPanel();
        this.pane.setLayout((LayoutManager)new TableLayout(this.mainpanelSize));
        this.labelTop = new JLabel("Zug-Einfahrt", 0);
        this.labelTopBox = new JPanel();
        this.labelTopBox.setBackground(Color.RED);
        this.labelTopBox.setBorder(new CompoundBorder(BorderFactory.createLineBorder(this.getBackground(), 5), BorderFactory.createEtchedBorder()));
        this.labelTop.setFont(new Font("Dialog", 1, 14));
        this.labelTopBox.add(this.labelTop);
        this.labelTopBox.setLayout(new GridLayout(1, 1));
        this.pane.add((Component)this.labelTopBox, "0,0");
        this.name_label = !this.zug.von.equals("") ? new JLabel(String.valueOf(trainpane.getMain().schweiz_mode ? trainpane.getMain().schweiz_xml.getNameOf(this.zug.name) : this.zug.name) + ": Einfahrt von " + this.zug.von, 0) : new JLabel(String.valueOf(this.zug.name) + ": Abfahrt von " + this.zug.gleis, 0);
        this.name_label.setFont(new Font("Dialog", 1, 16));
        this.pane.add((Component)this.name_label, "0,1");
        this.plan_label = this.zug.nach.equals("") ? new JLabel("(Nach " + this.zug.plan.nextVon + ", \u00fcber " + this.zug.plangleis + ")", 0) : new JLabel("(Nach " + this.zug.nach + ", \u00fcber " + this.zug.plangleis + ")", 0);
        this.plan_label.setFont(this.font);
        this.plan_label.setForeground(new Color(50, 50, 50));
        this.pane.add((Component)this.plan_label, "0,2");
        this.zugdetailplan = new JPanel();
        this.zugdetailplan.setLayout(new BoxLayout(this.zugdetailplan, 2));
        this.zugdetailplan.add(Box.createHorizontalGlue());
        for (DecryptedTimeTableSingle einzelplan : this.zug.plan) {
            this.addEinzelplanPanel(einzelplan);
        }
        this.addNachPanel();
        this.zugdetailplan.add(Box.createHorizontalGlue());
        JScrollPane scroll_zugdetailplan = new JScrollPane(this.zugdetailplan, 21, 30);
        this.pane.add((Component)scroll_zugdetailplan, "0,3");
        JLabel infoLabel = this.trainpane.getZug().getNote().length() == 0 ? new JLabel("Keine Notiz", new ImageIcon("./src/plugin/images/infobutton_small.gif"), 0) : new JLabel(this.trainpane.getZug().getNote(), new ImageIcon("./src/plugin/images/infobutton_small_blink.gif"), 0);
        infoLabel.setForeground(this.trainpane.getZug().getNote().length() == 0 ? Color.BLACK : Color.RED);
        infoLabel.setBorder(BorderFactory.createLineBorder(this.getBackground(), 2));
        AlignBox label4 = new AlignBox(infoLabel);
        infoLabel.setFont(new Font("Courier", 1, 14));
        this.pane.add((Component)label4, "0,4");
        this.button = new JButton("Schlie\u00dfen");
        this.button.setContentAreaFilled(false);
        this.button.setOpaque(true);
        this.button.setForeground(Color.WHITE);
        this.button.setBackground(Color.BLACK);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlarmWindow.this.exit();
            }
        });
        this.button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                AlarmWindow.this.button.setBackground(Color.GRAY);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AlarmWindow.this.button.setBackground(Color.BLACK);
            }
        });
        this.button.setBorder(BorderFactory.createEtchedBorder());
        JPanel testpane = new JPanel();
        testpane.setLayout(new GridLayout(1, 1));
        testpane.add(this.button);
        testpane.setBackground(Color.BLACK);
        this.pane.add((Component)testpane, "0,5");
        this.button.setFont(this.font);
        this.button.setFocusPainted(false);
        this.setBorderColor(Color.BLACK);
        this.setContentPane(this.pane);
    }

    protected void setBorderColor(Color bordercolor) {
        this.pane.setBorder(BorderFactory.createLineBorder(bordercolor, 5));
    }

    private void addNachPanel() {
    }

    private void addEinzelplanPanel(DecryptedTimeTableSingle einzelplan) {
        JPanel zelle_au\u00dfen = new JPanel();
        JPanel zelle_innen = new JPanel();
        JLabel halt_name_label = new JLabel(einzelplan.plan, 0);
        halt_name_label.setBorder(new CompoundBorder(BorderFactory.createLineBorder(this.getBackground(), 2), BorderFactory.createEtchedBorder()));
        halt_name_label.setFont(new Font("Dialog", 1, 12));
        JPanel halt_name_labelbox = new JPanel();
        halt_name_labelbox.setLayout(new GridLayout(1, 1));
        halt_name_labelbox.setBackground(new Color(200, 200, 200));
        halt_name_labelbox.add(halt_name_label);
        zelle_au\u00dfen.setLayout((LayoutManager)new TableLayout(this.zwischenhalt_box_size));
        zelle_au\u00dfen.setPreferredSize(new Dimension(250, 2000));
        zelle_au\u00dfen.setMinimumSize(new Dimension(250, 1));
        zelle_au\u00dfen.setMaximumSize(new Dimension(250, 2000));
        zelle_au\u00dfen.add((Component)halt_name_labelbox, "0,0");
        JPanel zeitpanel = new JPanel();
        zeitpanel.setLayout(new GridLayout(2, 1));
        zeitpanel.setMaximumSize(new Dimension(2000, 200));
        zeitpanel.setPreferredSize(new Dimension(2000, 200));
        zelle_innen.setMinimumSize(new Dimension(1, 200));
        if (einzelplan.wirdDurchfahren()) {
            zeitpanel.add(new JLabel(einzelplan.getFormattedAb(), 0));
            zeitpanel.add(new JLabel("(Durchfahrt)", 0));
            zelle_innen.setLayout(new GridLayout(1, 1));
            zelle_innen.add(new JLabel(""));
        } else if (einzelplan.getDescriptions().size() == 0) {
            if (!einzelplan.getFormattedAb().equals("00:00")) {
                zeitpanel.add(einzelplan.getFormattedAn().equals("00:00") ? new JLabel(einzelplan.getFormattedAb(), 0) : new JLabel(String.valueOf(einzelplan.getFormattedAn()) + " bis " + einzelplan.getFormattedAb(), 0));
            } else {
                zeitpanel.add(einzelplan.getFormattedAn().equals("00:00") ? new JLabel("unbekannte Zeit", 0) : new JLabel(String.valueOf(einzelplan.getFormattedAn()) + " bis " + einzelplan.getFormattedAbNextTrain() + "*", 0));
            }
            if (einzelplan.getStopTime() > 1) {
                zeitpanel.add(new JLabel("H\u00e4lt " + einzelplan.getStopTime() + " Minuten", 0));
            } else if (einzelplan.getStopTime() == 1) {
                zeitpanel.add(new JLabel("H\u00e4lt " + einzelplan.getStopTime() + " Minute", 0));
            } else if (einzelplan.getStopTime() == 0) {
                zeitpanel.add(new JLabel("Kurzhalt", 0));
            }
            zelle_innen.setLayout(new GridLayout(1, 1));
            zelle_innen.add(new JLabel(""));
        } else {
            if (!einzelplan.getFormattedAb().equals("00:00")) {
                zeitpanel.add(einzelplan.getFormattedAn().equals("00:00") ? new JLabel(einzelplan.getFormattedAb(), 0) : new JLabel(String.valueOf(einzelplan.getFormattedAn()) + " bis " + einzelplan.getFormattedAb(), 0));
            } else {
                zeitpanel.add(einzelplan.getFormattedAn().equals("00:00") ? new JLabel("unbekannte Zeit", 0) : new JLabel(String.valueOf(einzelplan.getFormattedAn()) + " bis " + einzelplan.getFormattedAbNextTrain() + "*", 0));
            }
            if (einzelplan.getStopTime() > 1) {
                zeitpanel.add(new JLabel("H\u00e4lt " + einzelplan.getStopTime() + " Minuten", 0));
            } else if (einzelplan.getStopTime() == 1) {
                zeitpanel.add(new JLabel("H\u00e4lt " + einzelplan.getStopTime() + " Minute", 0));
            } else if (einzelplan.getStopTime() == 0) {
                zeitpanel.add(new JLabel("Kurzhalt", 0));
            }
            zelle_innen.setLayout(new BoxLayout(zelle_innen, 3));
            for (String halt_beschreibung : einzelplan.getDescriptions()) {
                JLabel beschreibung = new JLabel(halt_beschreibung, 0);
                zelle_innen.add(beschreibung);
            }
        }
        zelle_innen.setBorder(new CompoundBorder(BorderFactory.createLineBorder(this.getBackground(), 2), new CompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createLineBorder(this.getBackground(), 3))));
        zeitpanel.setBorder(new CompoundBorder(BorderFactory.createLineBorder(this.getBackground(), 2), BorderFactory.createEtchedBorder()));
        zelle_innen.add(Box.createVerticalGlue());
        zelle_au\u00dfen.add((Component)zeitpanel, "0,1");
        zelle_au\u00dfen.add((Component)zelle_innen, "0,2");
        this.zugdetailplan.add(zelle_au\u00dfen);
    }

    protected void exit() {
        this.trainpane.getMain().setTitle(this.title_old);
        this.dispose();
    }

    protected void showNow() {
        this.showNow(true);
    }

    private void showNow(boolean beep) {
        this.title_old = this.trainpane.getMain().getTitle();
        int w = this.trainpane.getMain().getSize().width;
        int h = this.trainpane.getMain().getSize().height;
        this.setPreferredSize(new Dimension(w - 20, h - 60 > 410 ? 410 : h - 60));
        this.setMaximumSize(new Dimension(3000, 600));
        this.pack();
        this.setLocationRelativeTo(this.trainpane.getMain());
        this.repaint();
        if (beep && this.zug.getUi().getMainUI().getOptions().isSoundEnabled()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Toolkit.getDefaultToolkit().beep();
                }
            });
        }
        this.trainpane.getMain().setTitle(this.getTitle());
        this.setVisible(true);
    }

    protected void showWithoutBeep() {
        this.showNow(false);
    }

    protected void setDurchfahrt(boolean b) {
        this.durchfahrt = b;
    }

    protected void setGleis(String gleis) {
        this.gleis = gleis;
    }

    protected void setEventname(String eventname) {
        this.eventname = eventname;
    }

    protected String getAlarmGleis() {
        return this.gleis;
    }

    protected boolean isDurchfahrt() {
        return this.durchfahrt;
    }

    protected String getEventname() {
        return this.eventname;
    }
}

