/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import plugin.DecryptedTimeTableSingle;
import plugin.TrainPane;

public class AlarmChoice
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    private TrainPane trainPane;

    public AlarmChoice(TrainPane trainPane) {
        this.trainPane = trainPane;
        this.initPopup();
    }

    @Override
    public void show(Component invoker, int x, int y) {
        super.show(invoker, x, y);
    }

    private void initPopup() {
        JMenuItem description = new JMenuItem(" Alarm-Auswahl ");
        description.setIcon(TrainPane.ICON_DISARMED);
        description.setFont(new Font("Dialog", 1, 12));
        MouseListener[] mouseListenerArray = description.getMouseListeners();
        int n = mouseListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseListener m = mouseListenerArray[n2];
            description.removeMouseListener(m);
            ++n2;
        }
        this.add(description);
        this.addSeparator();
        int i = 1;
        for (DecryptedTimeTableSingle einzelplan : this.trainPane.getZug().plan) {
            String itemDescription = einzelplan.wirdDurchfahren() ? "Durchfahrt:" : "Halt:      ";
            String optionalDescription = "";
            if (einzelplan.wirdBeiBedarfHalten()) {
                optionalDescription = "(Bedarfshalt)";
            }
            if (einzelplan.wirdFluegeln()) {
                optionalDescription = "(Fl\u00fcgelt)";
            }
            if (einzelplan.wirdKuppeln()) {
                optionalDescription = "(Kuppelt)";
            }
            if (einzelplan.wirdLokGewechselt()) {
                optionalDescription = "(Lokwechsel)";
            }
            if (einzelplan.wirdLokUmgesetzt()) {
                optionalDescription = "(Lok-Umsetzung)";
            }
            if (einzelplan.wirdUmdrehen()) {
                optionalDescription = "(Richtungswechsel)";
            }
            this.add(this.createItemOf(einzelplan.gleis, itemDescription, optionalDescription, einzelplan.getSymbol(this.trainPane.animations), einzelplan.wirdKuppeln() || einzelplan.wirdUmbenannt(), i == 1 && this.trainPane.getZug().von.equals("")));
            ++i;
        }
        this.addSeparator();
        JMenuItem versp_item = new JMenuItem(" Bei neuer Versp\u00e4tung ");
        versp_item.setFont(new Font("Courier", 1, 12));
        versp_item.setForeground(Color.LIGHT_GRAY);
        MouseListener[] mouseListenerArray2 = versp_item.getMouseListeners();
        int n3 = mouseListenerArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            MouseListener m = mouseListenerArray2[n4];
            versp_item.removeMouseListener(m);
            ++n4;
        }
        this.add(versp_item);
    }

    private JMenu createItemOf(final String gleis, final String description, String optionalDescription, ImageIcon icon, boolean isDestination, boolean isStart) {
        JMenu item = new JMenu(" Gleis: " + gleis + " " + optionalDescription);
        JMenuItem description_item = new JMenuItem(" Gleis " + gleis + " ");
        description_item.setFont(new Font("Courier", 1, 12));
        description_item.setForeground(Color.GRAY);
        MouseListener[] mouseListenerArray = description_item.getMouseListeners();
        int n = mouseListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseListener m = mouseListenerArray[n2];
            description_item.removeMouseListener(m);
            ++n2;
        }
        item.add(description_item);
        item.addSeparator();
        if (!isStart) {
            JMenuItem item_child = new JMenuItem(new AbstractAction(" " + (description.equals("Durchfahrt:") ? "DURCHFAHRT " + gleis : "ANKUNFT") + "  "){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlarmChoice.this.trainPane.setAlarm("ankunft", gleis, description.equals("Durchfahrt:"));
                }
            });
            item_child.setFont(description.equals("Durchfahrt:") ? new Font("Courier", 1, 12) : new Font("Courier", 1, 12));
            item.add(item_child);
        }
        if (!description.equals("Durchfahrt:") && !isDestination) {
            JMenuItem item_child2 = new JMenuItem(new AbstractAction(" ABFAHRT  "){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlarmChoice.this.trainPane.setAlarm("abfahrt", gleis, false);
                }
            });
            item.add(item_child2);
            item_child2.setFont(new Font("Courier", 1, 12));
        }
        item.setIcon(icon);
        item.setFont(description.equals("Durchfahrt:") ? new Font("Courier", 1, 12) : new Font("Courier", 1, 12));
        if (description.equals("Durchfahrt:")) {
            item.setForeground(new Color(100, 100, 100));
        }
        return item;
    }
}

